# バッチ設計書 14-ffcrm:demo:load

## 概要

本ドキュメントは、Fat Free CRMにおけるデモデータロードバッチ（ffcrm:demo:load）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Fat Free CRMのデモンストレーション用サンプルデータをデータベースにロードする処理を行う。営業支援システムとしての機能を試用・評価するためのデータセットを一括で投入する。

**業務上の目的・背景**：Fat Free CRMは顧客関係管理（CRM）システムであり、新規導入検討者や開発者がシステムの機能を評価するためには、リアルなデータセットが必要である。本バッチを実行することで、アカウント、コンタクト、リード、商談、キャンペーン、タスクなどの代表的なCRMデータが投入され、すぐにシステムを試用できる状態となる。これにより、デモ環境の構築やトレーニング環境の準備が容易になる。

**バッチの実行タイミング**：デモ環境構築時、開発環境セットアップ時、トレーニング環境準備時など、随時手動で実行される。

**主要な処理内容**：
1. Rails環境のロード
2. db/demoディレクトリのフィクスチャファイル（YML/CSV）を読み込み
3. フィクスチャデータをデータベースに投入
4. ユーザーのアバター画像を外部サービスから取得
5. ユーザーアクティビティ（バージョン履歴）をシミュレーション生成

**前後の処理との関連**：本バッチ実行前にdb:migrate等でテーブルが作成されている必要がある。ffcrm:demo:reload（No.15）から呼び出される場合もある。

**影響範囲**：accounts, contacts, leads, opportunities, campaigns, tasks, comments, emails, addresses, users, preferences, permissions, avatars, activitiesなど、CRM関連の主要テーブルすべてに影響する。

## バッチ種別

データ連携 / デモデータ投入

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | アプリケーションデータベースに接続可能であること |
| テーブル存在 | マイグレーション済みで関連テーブルが存在すること |
| ネットワーク接続 | アバター画像取得のためpravatar.ccへのHTTPS接続が可能であること |

### 実行可否判定

特別な実行可否判定は行わない。既存データがある場合は、フィクスチャのIDに基づいて上書きされる可能性がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| db/demo/*.yml | YML | フィクスチャファイル |
| db/demo/*.csv | CSV | フィクスチャファイル |
| https://i.pravatar.cc/180 | HTTP | アバター画像 |

**主要なフィクスチャファイル：**
- users.yml
- accounts.yml
- contacts.yml
- leads.yml
- opportunities.yml
- campaigns.yml
- tasks.yml
- comments.yml
- emails.yml
- addresses.yml
- preferences.yml
- permissions.yml
- avatars.yml
- activities.yml
- field_groups.yml
- account_contacts.yml
- account_opportunities.yml
- contact_opportunities.yml
- settings.yml
- research_tools.yml

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 複数テーブル | DB | フィクスチャに対応するテーブル |
| versions | DB | ユーザーアクティビティ履歴 |
| active_storage_blobs | DB | アバター画像のストレージ |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. Rails環境ロード
   └─ :environment タスクを依存関係として実行
2. フィクスチャ読み込み
   └─ Dir.globでdb/demo/*.{yml,csv}ファイルを検索
   └─ ActiveRecord::FixtureSet.create_fixturesで各ファイルをロード
3. アバター画像取得
   └─ User.find_eachで全ユーザーをループ
   └─ pravatar.ccから180x180のランダム画像を取得
   └─ Active Storageでアタッチ
4. アクティビティ生成
   └─ Account, Address, Campaign, Comment, Contact, Email, Lead, Opportunity, Taskの全レコードをループ
   └─ create/update/viewイベントのVersionレコードを生成
   └─ 過去30日以内のランダムな日時を設定
5. 処理完了
   └─ 正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rails環境ロード]
    B --> C[db/demo/*.ymlファイル一覧取得]
    C --> D[フィクスチャをDBにロード]
    D --> E[ユーザーループ開始]
    E --> F[アバター画像取得]
    F --> G{HTTP成功?}
    G -->|成功| H[画像をアタッチ]
    G -->|失敗| I[エラーメッセージ出力]
    H --> J{次のユーザーあり?}
    I --> J
    J -->|あり| F
    J -->|なし| K[エンティティループ開始]
    K --> L[Versionレコード生成]
    L --> M{次のエンティティあり?}
    M -->|あり| L
    M -->|なし| N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フィクスチャロード | accounts | INSERT | アカウントデータ投入 |
| フィクスチャロード | contacts | INSERT | コンタクトデータ投入 |
| フィクスチャロード | leads | INSERT | リードデータ投入 |
| フィクスチャロード | opportunities | INSERT | 商談データ投入 |
| フィクスチャロード | campaigns | INSERT | キャンペーンデータ投入 |
| フィクスチャロード | tasks | INSERT | タスクデータ投入 |
| フィクスチャロード | users | INSERT | ユーザーデータ投入 |
| フィクスチャロード | その他 | INSERT | 各種関連データ投入 |
| アバター更新 | avatars | UPDATE/INSERT | アバター画像設定 |
| アクティビティ生成 | versions | INSERT | 履歴データ生成 |

### テーブル別操作詳細

#### versions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | event | "create", "update", "view" | アクティビティ種別 |
| INSERT | created_at | 過去30日のランダム日時 | バックデート |
| INSERT | user_id | エンティティの所有者 | ユーザー関連付け |
| INSERT | item_id, item_type | 対象エンティティ | ポリモーフィック |
| INSERT | related_id, related_type | 関連エンティティ | ポリモーフィック |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OpenURI::HTTPError | HTTP取得エラー | アバター画像取得失敗 | エラーメッセージを出力して続行 |
| ActiveRecord::RecordInvalid | バリデーションエラー | 不正なフィクスチャデータ | フィクスチャファイルを修正 |
| ActiveRecord::StatementInvalid | DBエラー | データベース接続不可 | DB接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（アバター取得失敗時はスキップ） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. アバター画像取得エラーはスキップして処理を継続
2. その他のエラーは処理を中断
3. 必要に応じてdb:rollbackまたはdb:migrate:resetで復旧

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | フィクスチャごと |
| コミットタイミング | 各フィクスチャロード後 |
| ロールバック条件 | フィクスチャロード失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千件 |
| 目標処理時間 | 数分程度（ネットワーク速度依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ実行中はアプリケーションへのアクセスを制限することを推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | アバター取得開始 | "Fetching avatars for users..." |
| 進捗ログ | アバター取得中 | "." （10件ごと） |
| エラーログ | アバター取得失敗 | "Error fetching avatar for {email}: {message}" |
| 進捗ログ | アクティビティ生成開始 | "Generating user activities..." |
| 進捗ログ | アクティビティ生成中 | "." （10件ごと） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- pravatar.ccはランダムなアバター画像を提供する外部サービス
- $stdout.sync = trueにより、ログがバッファリングされずに即時出力される
- アクティビティは過去30日以内のランダムな日時が設定される
- フィクスチャのIDは固定されているため、再実行時は既存データが上書きされる
