# バッチ設計書 15-ffcrm:demo:reload

## 概要

本ドキュメントは、Fat Free CRMにおけるデモデータリロードバッチ（ffcrm:demo:reload）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、データベースを完全にリセットし、デモデータとデフォルトアプリケーション設定を再ロードする処理を行う。既存データをすべて削除して、クリーンなデモ環境を再構築する。

**業務上の目的・背景**：開発やデモンストレーション中に蓄積されたデータをクリアし、初期状態のデモ環境を再現したい場合がある。本バッチを実行することで、データベースを完全にリセットした上で、標準的なデモデータを再投入できる。これにより、デモ環境の再現性が確保され、一貫したデモンストレーションやトレーニングが可能となる。

**バッチの実行タイミング**：デモ環境のリセットが必要な際に随時手動で実行される。定期的なデモ環境リフレッシュ、開発中のデータクリーンアップ、トレーニング終了後の環境初期化などに使用される。

**主要な処理内容**：
1. Rails環境のロード
2. db:migrate:resetタスクを呼び出し（データベースのドロップ、再作成、マイグレーション実行）
3. ffcrm:demo:loadタスクを呼び出し（デモデータのロード）

**前後の処理との関連**：本バッチはdb:migrate:resetとffcrm:demo:load（No.14）を内部的に呼び出す複合タスク。既存のすべてのデータが削除されるため、実行前のバックアップが推奨される。

**影響範囲**：データベース全体が対象。すべてのテーブルがドロップされ、スキーマから再構築される。その後、デモデータが投入される。

## バッチ種別

データクレンジング / 環境リセット

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | アプリケーションデータベースに接続可能であること |
| データベース作成権限 | DROP/CREATE DATABASE権限があること |
| ネットワーク接続 | アバター画像取得のためpravatar.ccへのHTTPS接続が可能であること |

### 実行可否判定

特別な実行可否判定は行わない。本番環境での実行は禁止されるべきであり、development/demo環境でのみ使用することを強く推奨。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| db/schema.rb | Ruby | データベーススキーマ定義 |
| db/migrate/*.rb | Ruby | マイグレーションファイル |
| db/demo/*.yml | YML | デモ用フィクスチャファイル |
| https://i.pravatar.cc/180 | HTTP | アバター画像 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| データベース全体 | DB | 再構築されたスキーマとデモデータ |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. Rails環境ロード
   └─ :environment タスクを依存関係として実行
2. データベースリセット
   └─ Rake::Task["db:migrate:reset"].invoke
   └─ データベースをドロップ
   └─ データベースを再作成
   └─ すべてのマイグレーションを実行
3. デモデータロード
   └─ Rake::Task["ffcrm:demo:load"].invoke
   └─ フィクスチャデータ投入
   └─ アバター画像取得
   └─ アクティビティ履歴生成
4. 処理完了
   └─ 正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rails環境ロード]
    B --> C[db:migrate:reset実行]
    C --> D[データベースドロップ]
    D --> E[データベース作成]
    E --> F[マイグレーション実行]
    F --> G[ffcrm:demo:load実行]
    G --> H[フィクスチャロード]
    H --> I[アバター画像取得]
    I --> J[アクティビティ生成]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| db:drop | 全テーブル | DROP | データベース全体を削除 |
| db:create | - | CREATE | データベースを新規作成 |
| db:migrate | 全テーブル | CREATE | マイグレーションによるテーブル作成 |
| ffcrm:demo:load | 主要テーブル | INSERT | デモデータ投入 |

### テーブル別操作詳細

db:migrate:resetにより、schema.rbまたはマイグレーションファイルに定義されたすべてのテーブルが作成される。その後、ffcrm:demo:loadによりデータが投入される。詳細はNo.14の設計書を参照。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ActiveRecord::StatementInvalid | DBエラー | DB接続不可/権限不足 | DB設定と権限を確認 |
| ActiveRecord::NoDatabaseError | DBエラー | DB作成失敗 | 手動でdb:create実行 |
| OpenURI::HTTPError | HTTP取得エラー | アバター画像取得失敗 | ネットワーク接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. データベース関連エラーの場合はdatabase.ymlと権限を確認
2. マイグレーションエラーの場合は該当マイグレーションファイルを確認
3. バックアップからのリストアが必要な場合は別途手順を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各サブタスクごと |
| コミットタイミング | サブタスク完了時 |
| ロールバック条件 | サブタスク失敗時（部分的） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テーブル数（数十）+ デモデータ（数百〜千件） |
| 目標処理時間 | 数分〜10分程度 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ実行中はアプリケーションを停止する必要がある。データベースが再構築されるため、アクセスがあるとエラーとなる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| マイグレーションログ | 各マイグレーション実行時 | マイグレーション名と結果 |
| デモロードログ | ffcrm:demo:load実行時 | No.14参照 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- 本番環境での実行は絶対に避けること
- RAILS_ENV=production での実行時はRailsが警告/エラーを出す可能性がある
- db:migrate:resetはdb:drop、db:create、db:migrateの組み合わせ
- データ復旧にはバックアップからのリストアが必要
