# バッチ設計書 17-ffcrm:preference_update:run

## 概要

本ドキュメントは、Fat Free CRMにおけるプリファレンスデータ形式変換バッチ（ffcrm:preference_update:run）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、ユーザープリファレンス（設定データ）のシリアライズ形式をMarshal形式からJSON形式に変換する処理を行う。データ移行を目的とした一回限りのバッチである。

**業務上の目的・背景**：Rubyの古いバージョンやRailsの旧実装では、オブジェクトのシリアライズにMarshal形式が使用されていた。しかし、Marshal形式はRubyバージョン間での互換性問題やセキュリティ上の懸念がある。JSON形式への移行により、データの可読性向上、他システムとの連携容易化、セキュリティ強化が実現される。本バッチは、既存のMarshalシリアライズデータをJSON形式に変換することで、システムのモダン化を支援する。

**バッチの実行タイミング**：システムアップグレード時に一度のみ実行することを想定。既にJSON形式で保存されているデータに対して実行すると、予期しない動作をする可能性がある。

**主要な処理内容**：
1. Rails環境のロード
2. preferencesテーブルの全レコードを取得
3. 各レコードのvalueをBase64デコード→JSONパース→JSON再シリアライズ→Base64エンコード
4. 更新後の値をメモリに保持（注：現状のコードでは保存処理が不完全）

**前後の処理との関連**：本バッチは独立して実行される。Preferenceモデルの仕様変更に伴うデータ移行バッチとして位置づけられる。

**影響範囲**：preferencesテーブルのvalueカラムが対象。ユーザーごとの表示設定やフィルター設定などが影響を受ける。

## バッチ種別

データ変換 / データ移行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 一度のみ |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | アプリケーションデータベースに接続可能であること |
| preferencesテーブル存在 | マイグレーション済みでpreferencesテーブルが存在すること |
| Base64エンコード済みデータ | valueがBase64でエンコードされていること |

### 実行可否判定

特別な実行可否判定は行わない。ただし、現状のコード実装では更新処理が不完全であり、実際の使用には注意が必要。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| preferences | DB | 変換対象のプリファレンスデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| preferences | DB | JSON形式に変換後の設定データ（注：現在の実装では保存されない） |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. Rails環境ロード
   └─ :environment タスクを依存関係として実行
2. プリファレンス取得
   └─ Preference.all で全レコード取得
3. 変換ループ
   └─ 各preferenceに対して:
      └─ Base64.decode64(preference.value)
      └─ JSON.parse(デコード結果, symbolize_name: true)
      └─ val.to_json
      └─ Base64.encode64(JSON文字列)
      └─ preference.value に代入
4. 処理完了
   └─ 正常終了（注：saveが呼ばれていない）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rails環境ロード]
    B --> C[Preference.all取得]
    C --> D{レコードあり?}
    D -->|なし| H[バッチ終了]
    D -->|あり| E[Base64デコード]
    E --> F[JSON変換]
    F --> G[Base64エンコード]
    G --> I{次のレコードあり?}
    I -->|あり| E
    I -->|なし| H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| プリファレンス取得 | preferences | SELECT | 全レコード取得 |
| プリファレンス更新 | preferences | UPDATE | valueカラム更新（実装不完全） |

### テーブル別操作詳細

#### preferences

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | 条件なし | Preference.all |
| UPDATE | value | Base64(JSON(元データ)) | 現状saveが未呼び出し |

**テーブルスキーマ：**
- id: integer (PK)
- user_id: integer (FK)
- name: string(32) - プリファレンス名
- value: text - Base64エンコードされた設定値
- created_at: datetime
- updated_at: datetime

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| JSON::ParserError | パースエラー | 不正なJSON形式 | データ形式を確認 |
| ArgumentError | Base64エラー | 不正なBase64データ | データ形式を確認 |
| ActiveRecord::StatementInvalid | DBエラー | データベース接続不可 | DB接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラー発生レコードを特定
2. データ形式を確認（Base64/JSON/Marshal）
3. 必要に応じて個別に修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（現在の実装では保存処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ユーザー数 × プリファレンス種類数 |
| 目標処理時間 | 数秒〜数分 |
| メモリ使用量上限 | 全プリファレンスをメモリにロード |

## 排他制御

本バッチ実行中はアプリケーションからのプリファレンス更新を避けることを推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| N/A | N/A | 標準出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- **重要な実装上の問題**：現在のコードでは`preference.value = Base64.encode64(val.to_json)`の後に`preference.save`が呼ばれていないため、変更がデータベースに永続化されない
- 本バッチを使用する前に、コードの修正が必要
- Preferenceモデルでは既にJSON形式での保存/読み込みが実装されているため、このバッチの必要性を再確認すること
- symbolize_nameオプションはsymbolize_namesの誤記の可能性がある
