# バッチ設計書 18-ffcrm:missing_translations:detect

## 概要

本ドキュメントは、Fat Free CRMにおける翻訳漏れ検出バッチ（ffcrm:missing_translations:detect）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、指定されたロケールの翻訳ファイルを基準ロケール（en-US）と比較し、翻訳が不足しているキーを検出・報告する処理を行う。国際化（i18n）対応の品質管理に使用するユーティリティバッチである。

**業務上の目的・背景**：Fat Free CRMは多言語対応しており、各言語の翻訳ファイルがconfig/localesディレクトリに配置されている。新機能追加や既存機能の変更時に、基準言語（英語）に対して他言語の翻訳が追加されないことがある。本バッチを使用することで、翻訳漏れを体系的に検出し、ローカライズ品質を維持できる。開発者やローカライズ担当者が翻訳の完全性を確認するための重要なツールである。

**バッチの実行タイミング**：翻訳作業の確認時、リリース前のローカライズチェック時、新言語追加時など、随時手動で実行される。

**主要な処理内容**：
1. 基準ロケール（en-US）と対象ロケールのYAMLファイルを読み込み
2. 3種類のファイルペアで比較（通常、fat_free_crm用、ransack用）
3. 基準ロケールに存在し対象ロケールに存在しないキーを検出
4. 検出結果を標準出力に表示

**前後の処理との関連**：本バッチは独立して実行可能な参照専用バッチ。検出された翻訳漏れは手動でYAMLファイルを編集して修正する。

**影響範囲**：読み取り専用の処理であり、ファイルやデータベースの変更は行わない。検出結果が標準出力に表示されるのみ。

## バッチ種別

レポート生成 / 品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 翻訳ファイル存在 | config/locales/{locale}.yml が存在すること |
| 基準ロケール存在 | config/locales/en-US.yml が存在すること |

### 実行可否判定

対象ロケールのファイルが存在しない場合は、YAML.load_fileでエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| locale | String | Yes | なし | 比較対象のロケールコード（例：de, ja, fr） |

**実行例：**
```bash
bundle exec rake ffcrm:missing_translations:detect[ja]
bundle exec rake ffcrm:missing_translations:detect[de]
```

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| config/locales/en-US.yml | YAML | 基準ロケール |
| config/locales/{locale}.yml | YAML | 対象ロケール |
| config/locales/en-US_fat_free_crm.yml | YAML | 基準ロケール（アプリ固有） |
| config/locales/{locale}_fat_free_crm.yml | YAML | 対象ロケール（アプリ固有） |
| config/locales/en-US_ransack.yml | YAML | 基準ロケール（検索機能） |
| config/locales/{locale}_ransack.yml | YAML | 対象ロケール（検索機能） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 翻訳漏れのキーパスと値 |

### 出力ファイル仕様

ファイル出力なし。標準出力のみ。

**出力フォーマット例：**
```
Detected missing translations within "config/locales/ja.yml":

key1 => subkey1 => subkey2: Original English Text
key1 => subkey3: Another English Text
```

## 処理フロー

### 処理シーケンス

```
1. Rails環境ロード
   └─ :environment タスクを依存関係として実行
2. パラメータ取得
   └─ args[:locale] から対象ロケールを取得
3. ファイルペアループ
   └─ 以下の3ペアを処理:
      - en-US.yml vs {locale}.yml
      - en-US_fat_free_crm.yml vs {locale}_fat_free_crm.yml
      - en-US_ransack.yml vs {locale}_ransack.yml
4. 各ペアで翻訳漏れ検出
   └─ MissingTranslationDetector.new(base, target)
   └─ detector.detect()
   └─ detector.missing_translations? で結果確認
5. 結果出力
   └─ 翻訳漏れがある場合、キーパスと値を出力
6. 処理完了
   └─ 正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rails環境ロード]
    B --> C[localeパラメータ取得]
    C --> D[ファイルペアループ開始]
    D --> E[MissingTranslationDetector初期化]
    E --> F[detect実行]
    F --> G{翻訳漏れあり?}
    G -->|なし| H{次のペアあり?}
    G -->|あり| I[ファイル名表示]
    I --> J[漏れキー一覧出力]
    J --> H
    H -->|あり| E
    H -->|なし| K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Errno::ENOENT | ファイル不存在 | 翻訳ファイルが見つからない | ファイルを作成または確認 |
| Psych::SyntaxError | YAML構文エラー | 翻訳ファイルが不正 | YAMLファイルを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ファイル不存在の場合は対象ファイルを確認
2. YAML構文エラーの場合はYAMLバリデータで確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル読み取りのみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 翻訳キー数（通常数百〜数千） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 翻訳ファイル全体をメモリにロード |

## 排他制御

読み取り専用のため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ヘッダー | 翻訳漏れ検出時 | "Detected missing translations within ..." |
| 翻訳漏れ詳細 | 各漏れキー | "キーパス: 元の値" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- MissingTranslationDetectorクラスはlib/missing_translation_detector.rbに定義
- 再帰的にネストされたキーを走査し、基準ロケールに存在するが対象ロケールに存在しないキーを検出
- 翻訳漏れがない場合は何も出力されない
- 3種類のファイル（通常、fat_free_crm、ransack）それぞれで比較が行われる
