# バッチ設計書 19-spec:preparedb

## 概要

本ドキュメントは、Fat Free CRMにおけるテスト環境データベース準備バッチ（spec:preparedb）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、RSpecテスト実行前にテスト環境用のデータベースを準備する処理を行う。テスト環境でのスキーマ適用を自動化する開発支援バッチである。

**業務上の目的・背景**：Fat Free CRMの開発において、自動テスト（RSpec）を実行するためには、テスト用データベースが正しいスキーマで構築されている必要がある。開発環境とテスト環境では異なるデータベースを使用するため、テスト環境専用の準備処理が必要となる。本バッチを使用することで、テスト実行前のデータベース準備を自動化し、開発効率を向上させる。

**バッチの実行タイミング**：テスト実行前、テスト環境の初期セットアップ時、スキーマ変更後のテスト環境更新時など、開発作業の一環として随時実行される。

**主要な処理内容**：
1. Rails環境をtest環境に一時的に切り替え
2. ffcrm:config:copy_database_ymlタスクを呼び出しdatabase.ymlをセットアップ
3. db:schema:loadタスクを呼び出しスキーマを適用
4. Rails環境を元に戻す

**前後の処理との関連**：本バッチはffcrm:config:copy_database_yml（No.10）を内部的に呼び出す。テスト実行（rspec）の前に実行することが想定される。

**影響範囲**：テスト環境（test）のデータベースのみが影響を受ける。開発環境や本番環境には影響しない。

## バッチ種別

セットアップ / テスト環境準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| RSpecインストール | RSpec gemがインストールされていること |
| database.yml存在 | データベース設定ファイルが存在すること（または作成可能） |
| schema.rb存在 | db/schema.rbが存在すること |
| テストDB接続可能 | test環境のデータベースに接続可能であること |

### 実行可否判定

RSpecが定義されていない場合（`defined?(RSpec)`がfalse）、タスク自体が定義されない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| db/schema.rb | Ruby | データベーススキーマ定義 |
| config/database.{DB}.yml | YAML | データベース設定テンプレート |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| テストデータベース | DB | スキーマが適用されたテストDB |
| config/database.yml | YAML | コピーされた設定ファイル（存在しない場合） |

### 出力ファイル仕様

ファイル出力は間接的（ffcrm:config:copy_database_yml経由）。

## 処理フロー

### 処理シーケンス

```
1. 現在のRails環境を保存
   └─ tmp_env = Rails.env
2. Rails環境をtestに切り替え
   └─ Rails.env = "test"
3. database.ymlセットアップ
   └─ Rake::Task["ffcrm:config:copy_database_yml"].invoke
4. ログ出力
   └─ "Preparing test database..."
5. スキーマロード
   └─ Rake::Task["db:schema:load"].invoke
6. Rails環境を復元
   └─ Rails.env = tmp_env
7. 処理完了
   └─ 正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[現在のRails.env保存]
    B --> C[Rails.env = test]
    C --> D[ffcrm:config:copy_database_yml実行]
    D --> E[db:schema:load実行]
    E --> F[Rails.env復元]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| db:schema:load | 全テーブル | CREATE | テストDBにスキーマ適用 |

### テーブル別操作詳細

db:schema:loadにより、schema.rbに定義されたすべてのテーブルがテスト環境に作成される。既存のテーブルがある場合はドロップされる可能性がある。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ActiveRecord::StatementInvalid | DBエラー | DB接続不可 | database.ymlを確認 |
| Errno::ENOENT | ファイル不存在 | schema.rbが見つからない | db:migrateを実行 |
| LoadError | ライブラリエラー | RSpecが未インストール | RSpec gemをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. database.yml設定を確認
2. テストデータベースが作成されているか確認（db:create実行）
3. schema.rbの存在と内容を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | db:schema:loadに依存 |
| コミットタイミング | 各テーブル作成後 |
| ロールバック条件 | スキーマロード失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テーブル数（数十） |
| 目標処理時間 | 数秒〜十数秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

テスト実行と同時に実行しないこと。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | スキーマロード前 | "Preparing test database..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- RSpecが定義されていない環境では、このタスクは存在しない
- Rails.envを一時的に変更しているため、並行実行には注意
- db:schema:loadはschema.rbを使用するため、保留中のマイグレーションがある場合は先にdb:migrateを実行すること
- ENV['DB']環境変数によってデータベースタイプを切り替え可能（postgres, mysql等）
