# バッチ設計書 20-rdoc

## 概要

本ドキュメントは、Fat Free CRMにおけるRDocドキュメント生成バッチ（rdoc）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Fat Free CRMのソースコードからRDoc形式のAPIドキュメントを自動生成する処理を行う。開発者向けのコードドキュメント生成ツールである。

**業務上の目的・背景**：オープンソースプロジェクトであるFat Free CRMでは、開発者がコードを理解しやすくするためのドキュメントが重要である。RDocはRubyの標準的なドキュメント生成ツールであり、ソースコード内のコメントからHTMLドキュメントを自動生成する。本バッチを使用することで、クラス、メソッド、モジュールの構造と説明を含むドキュメントが生成され、新規開発者のオンボーディングや既存コードの理解促進に役立つ。

**バッチの実行タイミング**：ドキュメント更新が必要な際に随時実行される。リリース前のドキュメント更新、コードベースの大幅な変更後、新機能追加後などに実行される。

**主要な処理内容**：
1. RDoc::Taskの設定に基づきドキュメント生成
2. README.mdファイルをドキュメントに含める
3. lib/**/*.rbの全Rubyファイルを解析
4. rdoc/ディレクトリにHTMLドキュメントを出力

**前後の処理との関連**：本バッチは独立して実行可能。生成されたドキュメントは通常gitリポジトリには含めず、必要に応じてGitHub Pages等で公開される。

**影響範囲**：rdoc/ディレクトリにファイルが生成される。既存のrdocディレクトリは上書きされる。

## バッチ種別

レポート生成 / ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| rdoc gem | rdoc gemがインストールされていること（Ruby標準添付） |
| ソースファイル | lib/ディレクトリにRubyファイルが存在すること |
| README.md | プロジェクトルートにREADME.mdが存在すること |

### 実行可否判定

特別な実行可否判定は行わない。対象ファイルが見つからない場合は空のドキュメントが生成される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| README.md | Markdown | プロジェクト説明ファイル |
| lib/**/*.rb | Ruby | ドキュメント対象のソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| rdoc/ | HTML/CSS | 生成されたドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力ディレクトリ | rdoc/ |
| ファイル形式 | HTML |
| エンコーディング | UTF-8 |
| タイトル | 'FatFreeCRM' |
| オプション | --line-numbers（行番号表示） |

**主な出力ファイル：**
- index.html - トップページ
- 各クラス/モジュールのHTMLファイル
- CSSファイル
- JavaScriptファイル

## 処理フロー

### 処理シーケンス

```
1. RDoc::Task設定読み込み
   └─ lib/development_tasks/rdoc.rakeの設定を適用
2. 対象ファイル収集
   └─ README.md
   └─ lib/**/*.rb
3. ソースコード解析
   └─ クラス、モジュール、メソッドの抽出
   └─ コメントの解析
4. HTML生成
   └─ テンプレートに基づきHTML出力
5. 処理完了
   └─ rdoc/ディレクトリに出力完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[RDoc::Task設定読み込み]
    B --> C[README.md読み込み]
    C --> D[lib/**/*.rb収集]
    D --> E[ソースコード解析]
    E --> F[HTML生成]
    F --> G[rdoc/に出力]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| LoadError | ライブラリエラー | rdoc gemが見つからない | rdoc gemをインストール |
| Errno::ENOENT | ファイル不存在 | README.mdが見つからない | README.mdを作成 |
| Errno::EACCES | 権限エラー | rdoc/への書き込み権限なし | ディレクトリ権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. rdoc gemのインストールを確認
2. 入力ファイルの存在を確認
3. 出力ディレクトリの権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | libディレクトリのファイル数（数十〜数百） |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 全ソースコードをメモリにロード |

## 排他制御

同時に複数のrdoc生成を実行しないこと。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ファイル処理時 | 処理中のファイルパス |
| 完了ログ | 生成完了時 | ドキュメント生成完了メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- RDoc::Taskを使用しており、rakeコマンドで実行可能
- require 'rdoc/task'が失敗した場合の互換性コード（require 'rake/rdoctask'）が含まれている
- 生成されるドキュメントはRDoc標準のHTMLテンプレートを使用
- --line-numbersオプションによりソースの行番号がドキュメントに表示される
- 生成されたドキュメントをブラウザで確認するには、rdoc/index.htmlを開く
- rdocディレクトリは通常.gitignoreに追加されている
