# バッチ設計書 21-license:add

## 概要

本ドキュメントは、Fat Free CRMプロジェクトにおけるライセンス情報追加バッチ（`license:add`）の設計仕様を記載したものです。このバッチは、プロジェクト内の各種ソースファイルの先頭にMITライセンスに関する著作権情報を追加するRakeタスクです。

### 本バッチの処理概要

このバッチは、プロジェクト内のRuby、JavaScript、CSS/Sass/SCSSファイルに対して、MITライセンスの著作権表示を追加します。

**業務上の目的・背景**：オープンソースソフトウェアとして公開されているFat Free CRMにおいて、MITライセンスの条項に従い、すべてのソースファイルに著作権情報を明記する必要があります。このバッチにより、新規作成されたファイルや、何らかの理由でライセンス情報が欠落したファイルに対して、一括でライセンス情報を追加することができます。これにより、ライセンスコンプライアンスを確保し、法的リスクを軽減します。

**バッチの実行タイミング**：開発者が手動で実行する随時実行タイプのバッチです。主に以下のタイミングで実行されます：
- 新規ファイルを大量に追加した後
- リリース前のライセンスチェック時
- `annotate` gemでモデルにスキーマ情報を付与した後（annotate gemはライセンス情報を削除することがあるため）

**主要な処理内容**：
1. 対象ファイルの言語種別（Ruby/JavaScript/CSS）ごとにglobパターンを展開
2. 各ファイルの内容を読み込み、既存のライセンス情報を正規表現で削除
3. 言語に適したフォーマットでライセンス情報をファイル先頭に追加
4. ファイル内容に変更があった場合のみ書き込みを実行

**前後の処理との関連**：
- 前提：特になし（単独で実行可能）
- 関連：`license:remove`タスクと対をなす処理
- 後続：リリース準備やコードレビューの一環として実行

**影響範囲**：
- app/配下のRubyファイル、CoffeeScriptファイル
- lib/配下のRakeファイル、Rubyファイル
- spec/配下のRubyファイル
- config/配下のRubyファイル、設定ファイル
- app/assets/配下のJavaScript、Sass、SCSS、CSSファイル

## バッチ種別

コード管理 / ライセンス管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（Rakeタスク） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Rails環境 | Railsプロジェクトのルートディレクトリで実行すること |
| ファイル書き込み権限 | 対象ファイルへの書き込み権限があること |

### 実行可否判定

特別な判定ロジックはなく、Rakeタスクとして実行可能な状態であれば実行できます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | このタスクはパラメータを受け取りません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| app/**/*.rb | Rubyファイル | アプリケーションのRubyソースコード |
| app/**/*.coffee | CoffeeScriptファイル | CoffeeScriptソースコード |
| lib/**/*.rake | Rakeファイル | Rakeタスク定義ファイル |
| lib/fat_free_crm/**/*.rb | Rubyファイル | ライブラリのRubyソースコード |
| lib/fat_free_crm.rb | Rubyファイル | メインライブラリファイル |
| spec/**/*.rb | Rubyファイル | RSpecテストファイル |
| config/**/*.rb | Rubyファイル | 設定ファイル |
| config/settings.default.yml | YAMLファイル | デフォルト設定ファイル |
| app/assets/javascripts/**/*.js | JavaScriptファイル | JavaScriptソースコード |
| app/assets/javascripts/**/*.js.erb | ERB埋込JSファイル | ERBテンプレート付きJavaScript |
| app/assets/stylesheets/**/*.sass | Sassファイル | Sassスタイルシート |
| app/assets/stylesheets/**/*.scss | SCSSファイル | SCSSスタイルシート |
| app/assets/stylesheets/**/*.css | CSSファイル | CSSスタイルシート |
| app/assets/stylesheets/**/*.css.erb | ERB埋込CSSファイル | ERBテンプレート付きCSS |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 入力ファイルと同一 | 各言語形式 | ライセンス情報が追加されたファイル |
| 標準出力 | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力ファイルと同一 |
| 出力先 | 入力ファイルと同一パス |
| 文字コード | UTF-8 |
| 改行コード | LF |

#### ライセンステキスト（言語別）

**Ruby/CoffeeScript/Rake形式：**
```ruby
# Copyright (c) 2008-2013 Michael Dvorkin and contributors.
#
# Fat Free CRM is freely distributable under the terms of MIT license.
# See MIT-LICENSE file or http://www.opensource.org/licenses/mit-license.php
#------------------------------------------------------------------------------
```

**JavaScript/Sass/SCSS形式：**
```javascript
// Copyright (c) 2008-2013 Michael Dvorkin and contributors.
//
// Fat Free CRM is freely distributable under the terms of MIT license.
// See MIT-LICENSE file or http://www.opensource.org/licenses/mit-license.php
//------------------------------------------------------------------------------
```

**CSS形式：**
```css
/*
 * Copyright (c) 2008-2013 Michael Dvorkin and contributors.
 *
 * Fat Free CRM is freely distributable under the terms of MIT license.
 * See MIT-LICENSE file or http://www.opensource.org/licenses/mit-license.php
 *------------------------------------------------------------------------------
 */
```

## 処理フロー

### 処理シーケンス

```
1. FILESハッシュから言語種別ごとにglobパターンを取得
   └─ ruby, js, css の3カテゴリを順次処理
2. globパターンを展開してファイル一覧を取得
   └─ Dir.glob()で各パターンにマッチするファイルを取得し、重複を除去
3. 各ファイルに対して以下を実行
   └─ 3.1 ファイル内容を読み込み（File.read）
   └─ 3.2 既存のライセンス情報を正規表現で検索・削除
   └─ 3.3 言語に対応したライセンステキストをファイル先頭に追加
   └─ 3.4 新旧内容を比較し、差分がある場合のみファイルに書き込み
   └─ 3.5 変更があった場合は標準出力にメッセージを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[FILES定数から言語種別を取得]
    B --> C{言語種別ループ}
    C -->|ruby/js/css| D[globパターンを展開]
    D --> E{ファイルループ}
    E -->|各ファイル| F[ファイル内容読み込み]
    F --> G[既存ライセンス情報を削除]
    G --> H[新しいライセンス情報を先頭に追加]
    H --> I{内容に変更あり?}
    I -->|あり| J[ファイル書き込み]
    J --> K[処理結果を出力]
    K --> E
    I -->|なし| E
    E -->|完了| C
    C -->|完了| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | ファイル操作のみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Errno::ENOENT | 対象ファイルが存在しない | globパターンで存在するファイルのみ取得するため通常発生しない |
| - | Errno::EACCES | ファイルへの書き込み権限がない | ファイルの権限を確認し修正する |
| - | IOError | ファイル読み書き中のI/Oエラー | ディスク容量やファイルシステムの状態を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーが発生した場合、該当ファイルの状態を確認
2. ファイルの権限やディスク容量を確認
3. 必要に応じてGitで変更を元に戻す（`git checkout -- <file>`）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | Gitによるバージョン管理で対応 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ファイル程度 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

- 同時実行は想定していない
- ファイルロックは行わない
- 複数開発者が同時に実行した場合、最後に書き込んだ内容が反映される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | ファイル更新時 | `== Added license to {ファイルパス}` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

手動実行のバッチのため、監視・アラートは設定されていません。

## 備考

- `annotate` gem（モデルにスキーマ情報を追記するgem）と併用することを想定しています
- annotate gemがファイルを更新する際にライセンス情報が削除される可能性があるため、annotate実行後にこのタスクを実行することが推奨されます
- ライセンス情報の内容（著作権者、年度、ライセンス種別）を変更する場合は、`LICENSE_RB`定数の内容を編集してください
