# バッチ設計書 22-license:remove

## 概要

本ドキュメントは、Fat Free CRMプロジェクトにおけるライセンス情報削除バッチ（`license:remove`）の設計仕様を記載したものです。このバッチは、プロジェクト内の各種ソースファイルの先頭からMITライセンスに関する著作権情報を削除するRakeタスクです。

### 本バッチの処理概要

このバッチは、プロジェクト内のRuby、JavaScript、CSS/Sass/SCSSファイルから、MITライセンスの著作権表示を削除します。

**業務上の目的・背景**：開発プロセスにおいて、`annotate` gemなどのツールを使用してモデルファイルにスキーマ情報を追記する際、既存のライセンス情報が処理の妨げになる場合があります。また、ライセンス情報のフォーマットを変更する必要がある場合に、一旦既存のライセンス情報を削除してから新しいフォーマットで追加し直すことができます。このバッチにより、一括でライセンス情報を削除し、その後`license:add`タスクで再追加するワークフローが可能になります。

**バッチの実行タイミング**：開発者が手動で実行する随時実行タイプのバッチです。主に以下のタイミングで実行されます：
- ライセンス情報のフォーマット変更前
- `annotate` gem実行前の前処理として
- コードの一時的なクリーンアップ時

**主要な処理内容**：
1. 対象ファイルの言語種別（Ruby/JavaScript/CSS）ごとにglobパターンを展開
2. 各ファイルの内容を読み込み、既存のライセンス情報を正規表現で検索
3. マッチしたライセンス情報をファイルから削除
4. ファイル内容に変更があった場合のみ書き込みを実行

**前後の処理との関連**：
- 前提：特になし（単独で実行可能）
- 関連：`license:add`タスクと対をなす処理
- 後続：通常は`license:add`タスクを実行してライセンス情報を再追加

**影響範囲**：
- app/配下のRubyファイル、CoffeeScriptファイル
- lib/配下のRakeファイル、Rubyファイル
- spec/配下のRubyファイル
- config/配下のRubyファイル、設定ファイル
- app/assets/配下のJavaScript、Sass、SCSS、CSSファイル

## バッチ種別

コード管理 / ライセンス管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（Rakeタスク） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Rails環境 | Railsプロジェクトのルートディレクトリで実行すること |
| ファイル書き込み権限 | 対象ファイルへの書き込み権限があること |

### 実行可否判定

特別な判定ロジックはなく、Rakeタスクとして実行可能な状態であれば実行できます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | このタスクはパラメータを受け取りません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| app/**/*.rb | Rubyファイル | アプリケーションのRubyソースコード |
| app/**/*.coffee | CoffeeScriptファイル | CoffeeScriptソースコード |
| lib/**/*.rake | Rakeファイル | Rakeタスク定義ファイル |
| lib/fat_free_crm/**/*.rb | Rubyファイル | ライブラリのRubyソースコード |
| lib/fat_free_crm.rb | Rubyファイル | メインライブラリファイル |
| spec/**/*.rb | Rubyファイル | RSpecテストファイル |
| config/**/*.rb | Rubyファイル | 設定ファイル |
| config/settings.default.yml | YAMLファイル | デフォルト設定ファイル |
| app/assets/javascripts/**/*.js | JavaScriptファイル | JavaScriptソースコード |
| app/assets/javascripts/**/*.js.erb | ERB埋込JSファイル | ERBテンプレート付きJavaScript |
| app/assets/stylesheets/**/*.sass | Sassファイル | Sassスタイルシート |
| app/assets/stylesheets/**/*.scss | SCSSファイル | SCSSスタイルシート |
| app/assets/stylesheets/**/*.css | CSSファイル | CSSスタイルシート |
| app/assets/stylesheets/**/*.css.erb | ERB埋込CSSファイル | ERBテンプレート付きCSS |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 入力ファイルと同一 | 各言語形式 | ライセンス情報が削除されたファイル |
| 標準出力 | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力ファイルと同一 |
| 出力先 | 入力ファイルと同一パス |
| 文字コード | UTF-8 |
| 改行コード | LF |

## 処理フロー

### 処理シーケンス

```
1. FILESハッシュから言語種別ごとにglobパターンを取得
   └─ ruby, js, css の3カテゴリを順次処理
2. globパターンを展開してファイル一覧を取得
   └─ Dir.glob()で各パターンにマッチするファイルを取得し、重複を除去
3. 各ファイルに対して以下を実行
   └─ 3.1 ファイル内容を読み込み（File.read）
   └─ 3.2 正規表現（REGEXPS）でライセンス情報を検索・削除
   └─ 3.3 新旧内容を比較し、差分がある場合のみファイルに書き込み
   └─ 3.4 変更があった場合は標準出力にメッセージを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[FILES定数から言語種別を取得]
    B --> C{言語種別ループ}
    C -->|ruby/js/css| D[globパターンを展開]
    D --> E{ファイルループ}
    E -->|各ファイル| F[ファイル内容読み込み]
    F --> G[正規表現でライセンス情報を削除]
    G --> H{内容に変更あり?}
    H -->|あり| I[ファイル書き込み]
    I --> J[処理結果を出力]
    J --> E
    H -->|なし| E
    E -->|完了| C
    C -->|完了| K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | ファイル操作のみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Errno::ENOENT | 対象ファイルが存在しない | globパターンで存在するファイルのみ取得するため通常発生しない |
| - | Errno::EACCES | ファイルへの書き込み権限がない | ファイルの権限を確認し修正する |
| - | IOError | ファイル読み書き中のI/Oエラー | ディスク容量やファイルシステムの状態を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーが発生した場合、該当ファイルの状態を確認
2. ファイルの権限やディスク容量を確認
3. 必要に応じてGitで変更を元に戻す（`git checkout -- <file>`）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | Gitによるバージョン管理で対応 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ファイル程度 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

- 同時実行は想定していない
- ファイルロックは行わない
- 複数開発者が同時に実行した場合、最後に書き込んだ内容が反映される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | ファイル更新時 | `== Removed license from {ファイルパス}` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

手動実行のバッチのため、監視・アラートは設定されていません。

## 備考

- `license:add`タスクと対をなすタスクです
- ライセンス情報のフォーマットを変更する場合は、このタスクで削除してから`license:add`で再追加してください
- 正規表現でマッチするライセンス情報のみを削除するため、異なるフォーマットのライセンス情報は削除されません
- 削除対象の正規表現パターン（`REGEXPS`定数）を変更する場合は、ソースコードの修正が必要です

### 削除対象の正規表現パターン

**Ruby形式：**
```
/^# Copyright \(c\).*?\n(?:#.*\n)*?#-{10}-*\n/
```

**JavaScript/Sass/SCSS形式：**
```
/^\/\/ Copyright \(c\).*?\n(?:\/\/.*\n)*?\/\/-{10}-*\n/
```

**CSS形式：**
```
/^\/\*\n \* Copyright \(c\).*?\n(?: \*.*\n)*? \*-{10}-*\n \*\/\n/
```
