# バッチ設計書 5-ffcrm:comment_replies:run:dry

## 概要

本ドキュメントは、Fat Free CRMにおけるコメント返信メール処理のドライラン実行バッチ（ffcrm:comment_replies:run:dry）の設計について記載する。

### 本バッチの処理概要

このバッチは、ffcrm:comment_replies:runと同様にIMAPメールサーバーに接続し、コメント返信メールの処理シミュレーションを行う。ただし、実際のコメント作成やIMAPサーバー上のメールフラグ変更は行わず、処理結果をログに出力するのみとなる。

**業務上の目的・背景**：本番実行前にコメント返信処理の動作確認を行うことで、誤ったコメント作成やメールの消失を防止する。新規設定後の検証や、トラブルシューティング時の調査に活用される。運用開始前のテスト実行や、設定変更後の影響確認に不可欠な機能である。

**バッチの実行タイミング**：手動実行。本番実行（ffcrm:comment_replies:run）の前に検証目的で実行する。

**主要な処理内容**：
1. IMAPサーバーへの接続とログイン
2. 指定フォルダ内の未読メールの検索
3. 各メールの送信者検証（実際の処理はシミュレーション）
4. 件名解析と対象エンティティの特定（データベース更新なし）
5. 処理結果のログ出力
6. 処理後、メールを未読状態に戻す

**前後の処理との関連**：ffcrm:comment_replies:setupによるセットアップ完了後に実行可能。本バッチの実行結果を確認してから、ffcrm:comment_replies:runを実行することが推奨される。

**影響範囲**：データベースへの変更なし。IMAPサーバー上のメールフラグも変更されない（処理後に未読に戻す）。

## バッチ種別

データ連携 / メール処理 / ドライラン

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| IMAP設定完了 | Setting.email_comment_repliesに有効な接続情報が設定されていること |
| フォルダ存在 | scan_folderが存在すること |
| Rails環境 | Railsアプリケーション環境がロードされていること |

### 実行可否判定

IMAPサーバーへの接続が成功した場合のみ処理を継続。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Rakeタスクとして引数なしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| IMAPメールサーバー | IMAP | 指定フォルダ内の未読メールを取得 |
| settings (Setting.email_comment_replies) | DB | IMAP接続情報を取得 |
| users | DB | 送信者の認証に使用（読み取りのみ） |
| accounts, campaigns, contacts, leads, opportunities, tasks | DB | エンティティの検索（読み取りのみ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Railsログ | ログファイル | 処理結果、シミュレーション内容を出力 |

### 出力ファイル仕様

ファイル出力なし（ログ出力のみ）

## 処理フロー

### 処理シーケンス

```
1. CommentRepliesインスタンス生成
   └─ Setting.email_comment_repliesから設定を読み込み
2. IMAPサーバー接続
   └─ @dry_run = trueを設定
3. 未読メール検索
   └─ @imap.uid_search(['NOT', 'SEEN'])
4. 各メールに対して処理
   └─ メール取得
   └─ 有効性チェック（ログ出力のみ）
   └─ 送信者チェック（ログ出力のみ）
   └─ 件名解析（データ更新なし）
   └─ "Not archiving message"をログ出力
   └─ メールを未読状態に戻す
5. 処理結果サマリーをログ出力
6. 接続終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CommentRepliesインスタンス生成]
    B --> C[dry_run=true設定]
    C --> D[IMAPサーバー接続]
    D --> E{接続成功?}
    E -->|失敗| F[処理中断]
    E -->|成功| G[未読メール検索]
    G --> H{メールあり?}
    H -->|なし| I[処理終了]
    H -->|あり| J[メール取得・処理シミュレーション]
    J --> K[ログ出力]
    K --> L[メールを未読に戻す]
    L --> M{次のメール?}
    M -->|あり| J
    M -->|なし| I
    I --> N[処理結果サマリー出力]
    N --> O[切断]
    O --> P[バッチ終了]
    F --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 送信者検索 | users | SELECT | emailまたはalt_emailで検索（読み取りのみ） |
| エンティティ検索 | accounts等 | SELECT | 件名から抽出したIDで検索（読み取りのみ） |

### テーブル別操作詳細

ドライランのため、INSERT/UPDATE/DELETE操作は一切行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IMAP接続エラー | サーバー接続失敗 | 警告ログを出力し処理中断 |
| - | メール処理エラー | 個別メール処理失敗 | ログ出力し次を処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

ログを確認し、問題の原因を特定。必要に応じてIMAP設定を見直す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（データ更新なし） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数件〜数百件/実行 |
| 目標処理時間 | メール件数依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

ffcrm:comment_replies:runとの同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Not discarding or archiving any new messages..." |
| 進捗ログ | 各メール処理時 | "[Dry Run]"付きでFrom/Subject/message_id |
| 破棄ログ | 無効メール検出時 | "Not discarding message" |
| アーカイブログ | 有効メール処理時 | "Not archiving message" |
| 未読戻しログ | 各メール処理後 | "Marking message as unread" |
| 終了ログ | バッチ終了時 | 処理件数サマリー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | - |

## 備考

- 本バッチはデータを変更しないため、何度実行しても同じ結果となる
- ログに"[Dry Run]"が付与されるため、本番実行のログと区別可能
- 処理後にメールフラグを未読に戻すため、次回実行時にも同じメールが処理対象となる
- 件名の[entity:id]形式が正しく解析されるかの確認に最適
