# バッチ設計書 6-ffcrm:comment_replies:setup

## 概要

本ドキュメントは、Fat Free CRMにおけるコメント返信受信ボックスセットアップバッチ（ffcrm:comment_replies:setup）の設計について記載する。

### 本バッチの処理概要

このバッチは、コメント返信メール処理機能で使用するIMAPサーバー上のフォルダを確認・作成する初期セットアップ処理を行う。設定ファイルで指定されたスキャン用フォルダ、アーカイブ用フォルダ、無効メール用フォルダの存在を確認し、存在しない場合は自動的に作成する。

**業務上の目的・背景**：コメント返信メール処理機能を利用開始する前に、必要なIMAPフォルダ構成を自動的に準備することで、手動でのフォルダ作成の手間を省き、設定ミスを防止する。運用開始前の環境構築を簡素化し、スムーズなシステム導入を実現する。

**バッチの実行タイミング**：初期セットアップ時（1回のみ）、または設定変更後に手動実行。

**主要な処理内容**：
1. IMAPサーバーへの接続（setup: trueオプション）
2. scan_folderの存在確認、なければ作成
3. move_to_folderの存在確認、なければ作成
4. move_invalid_to_folderの存在確認、なければ作成
5. 各フォルダの状態をログ出力

**前後の処理との関連**：本バッチはffcrm:comment_replies:runの実行前に1回実行する必要がある。Setting.email_comment_repliesに有効な設定が登録されていることが前提。

**影響範囲**：IMAPサーバー上にフォルダが作成される。データベースへの影響はない。

## バッチ種別

セットアップ / 初期構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初期セットアップ時（1回のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| IMAP設定完了 | Setting.email_comment_repliesに有効な接続情報が設定されていること |
| Rails環境 | Railsアプリケーション環境がロードされていること |
| IMAPアクセス権限 | フォルダ作成権限のあるIMAP認証情報 |

### 実行可否判定

IMAPサーバーへの接続が成功した場合のみ処理を継続。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Rakeタスクとして引数なしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settings (Setting.email_comment_replies) | DB | IMAP接続情報、フォルダ名設定を取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| IMAPサーバー | IMAP | 必要なフォルダを作成 |
| Railsログ | ログファイル | フォルダ確認・作成結果を出力 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. CommentRepliesインスタンス生成
   └─ Setting.email_comment_repliesから設定を読み込み
2. IMAPサーバー接続（setup: true）
   └─ connect!(setup: true)でフォルダ選択をスキップ
3. フォルダリスト作成
   └─ scan_folder（必須）
   └─ move_to_folder（設定されている場合）
   └─ move_invalid_to_folder（設定されている場合）
4. 各フォルダの確認・作成
   └─ @imap.list("", folder)で存在確認
   └─ 存在しない場合は@imap.create(folder)
5. 接続終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CommentRepliesインスタンス生成]
    B --> C[IMAPサーバー接続]
    C --> D{接続成功?}
    D -->|失敗| E[エラー出力]
    D -->|成功| F[フォルダリスト作成]
    F --> G[scan_folder確認]
    G --> H{存在?}
    H -->|あり| I[OK ログ出力]
    H -->|なし| J[フォルダ作成]
    J --> I
    I --> K{move_to_folder設定あり?}
    K -->|あり| L[move_to_folder確認]
    K -->|なし| M{move_invalid_to_folder設定あり?}
    L --> N{存在?}
    N -->|あり| O[OK ログ出力]
    N -->|なし| P[フォルダ作成]
    P --> O
    O --> M
    M -->|あり| Q[move_invalid_to_folder確認]
    M -->|なし| R[切断]
    Q --> S{存在?}
    S -->|あり| T[OK ログ出力]
    S -->|なし| U[フォルダ作成]
    U --> T
    T --> R
    R --> V[バッチ終了]
    E --> V
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定取得 | settings | SELECT | email_comment_replies設定を取得 |

### テーブル別操作詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | var = 'email_comment_replies' | - | IMAP接続情報、フォルダ設定を取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IMAP接続エラー | サーバー接続失敗 | 警告ログを出力 |
| - | フォルダ作成エラー | 権限不足等 | 例外をキャッチしログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. IMAP接続エラーの場合、接続設定を見直す
2. フォルダ作成エラーの場合、IMAPサーバーの権限設定を確認
3. 手動でIMAPクライアントからフォルダを作成することも可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（データベース更新なし） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大3フォルダ |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行の制限なし。フォルダ存在確認後に作成するため、同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 接続時 | "connecting to {server}..." |
| 確認ログ | 接続成功時 | "logged in to {server}, checking folders..." |
| OK ログ | フォルダ存在時 | "folder {folder} OK" |
| 作成ログ | フォルダ作成時 | "folder {folder} missing, creating..." |
| エラーログ | エラー発生時 | "setup error {error}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | - |

## 備考

- 本バッチは冪等性があり、何度実行しても同じ結果となる
- フォルダが既に存在する場合は"OK"と表示されるのみで、処理はスキップされる
- Dropboxセットアップ（ffcrm:dropbox:setup）と同様の実装で、設定ソースのみ異なる
- ffcrm:dropbox:setupとは別のIMAPアカウント・フォルダを使用することも可能
