# バッチ設計書 7-ffcrm:setup

## 概要

本ドキュメントは、Fat Free CRMにおけるデータベース準備バッチ（ffcrm:setup）の設計について記載する。

### 本バッチの処理概要

このバッチは、Fat Free CRMアプリケーションの初期セットアップを行う。データベースマイグレーションの実行と、初期管理者ユーザーの作成を一括で行う。対話形式でユーザーの確認を求め、バックアップの確認後に処理を開始する。

**業務上の目的・背景**：新規インストール時やバージョンアップ時に、データベーススキーマの更新と初期管理者アカウントの作成を一括で行い、システム導入の手順を簡素化する。手動でのマイグレーション実行と管理者作成を個別に行う手間を省き、セットアップミスを防止する。

**バッチの実行タイミング**：初期インストール時またはアップグレード時に1回実行。または、データベースリセット後に実行。

**主要な処理内容**：
1. ユーザーへの確認メッセージ表示（バックアップの確認）
2. 対話形式での続行確認
3. db:migrateタスクの実行（データベースマイグレーション）
4. ffcrm:setup:adminタスクの実行（管理者ユーザー作成）

**前後の処理との関連**：本バッチ実行前に、config/database.ymlが正しく設定されている必要がある。本バッチはdb:migrateとffcrm:setup:adminを順番に呼び出す親タスクとして機能する。

**影響範囲**：データベースのスキーマ変更（全テーブル）、usersテーブルへの管理者レコード追加。

## バッチ種別

セットアップ / 初期構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初期セットアップ時（1回のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続設定 | config/database.ymlが正しく設定されていること |
| Rails環境 | Railsアプリケーション環境がロードされていること |
| データベース存在 | データベースが作成済みであること |

### 実行可否判定

- PROCEED環境変数が'true'の場合、確認なしで実行
- それ以外は対話形式でユーザーの続行確認を取得

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PROCEED | 環境変数 | No | - | 'true'を設定すると確認プロンプトをスキップ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| STDIN | 標準入力 | 対話形式での続行確認入力 |
| db/migrate/* | マイグレーションファイル | データベーススキーマ定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| データベース | DB | スキーマの更新（全テーブル） |
| users | DB | 管理者ユーザーの作成または更新 |
| STDOUT | コンソール | 処理状況メッセージ |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 環境変数PROCEED確認
   └─ 'true'でない場合、確認プロンプト表示
2. ユーザー確認
   └─ バックアップ確認メッセージ表示
   └─ "Continue [yes/no]:"で入力待ち
3. 入力判定
   └─ y/yesの場合、処理続行
   └─ それ以外は"Aborted setup."で終了
4. db:migrate実行
   └─ Rake::Task["db:migrate"].invoke
5. ffcrm:setup:admin実行
   └─ Rake::Task["ffcrm:setup:admin"].invoke
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{PROCEED=true?}
    B -->|Yes| C[db:migrate実行]
    B -->|No| D[バックアップ確認メッセージ表示]
    D --> E[Continue yes/no 入力待ち]
    E --> F{yes入力?}
    F -->|No| G[Aborted setup 終了]
    F -->|Yes| C
    C --> H[ffcrm:setup:admin実行]
    H --> I[バッチ終了]
    G --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| db:migrate | 全テーブル | CREATE/ALTER | スキーマ作成・変更 |
| ffcrm:setup:admin | users | INSERT/UPDATE | 管理者ユーザー作成・更新 |

### テーブル別操作詳細

#### schema_migrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | version | マイグレーションバージョン | 適用済みマイグレーション記録 |

#### users（ffcrm:setup:adminで処理）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | username | 入力値またはデフォルト | 管理者ユーザー名 |
| INSERT/UPDATE | email | 入力値 | 管理者メールアドレス |
| INSERT/UPDATE | password | 入力値またはデフォルト | 暗号化されて保存 |
| UPDATE | admin | true | 管理者フラグ |
| UPDATE | confirmed_at | Time.now.utc | メール確認済み |
| UPDATE | suspended_at | nil | 停止解除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | マイグレーションエラー | スキーマ不整合 | エラーメッセージを確認し手動で対応 |
| - | ユーザー作成エラー | バリデーションエラー | 入力値を見直して再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. マイグレーションエラーの場合、バックアップからリストアして問題を修正後に再実行
2. ユーザー作成エラーの場合、ffcrm:setup:adminを個別に再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | マイグレーション単位 |
| コミットタイミング | 各マイグレーション完了時 |
| ロールバック条件 | マイグレーション失敗時（自動） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | マイグレーションファイル数依存 |
| 目標処理時間 | 数分（初回セットアップ時） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は不可。データベースマイグレーションは排他的に実行される必要がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告メッセージ | 処理開始前 | "FatFree CRM is about to run migrations on your database..." |
| 進捗ログ | マイグレーション実行中 | 各マイグレーションの実行状況 |
| 終了メッセージ | ユーザー作成後 | "Admin user has been created." |
| 中断メッセージ | キャンセル時 | "Aborted setup." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | - |

## 備考

- 本バッチは対話形式のため、自動化スクリプトで使用する場合はPROCEED=true環境変数を設定すること
- 既存データベースに対して実行する場合は、事前にバックアップを取得することを強く推奨
- マイグレーション失敗時は、中間状態になる可能性があるため、バックアップからのリストアが必要な場合がある
- ffcrm:setup:adminは既存ユーザーの更新も可能なため、パスワードリセットにも使用可能
