# バッチ設計書 8-ffcrm:setup:admin

## 概要

本ドキュメントは、Fat Free CRMにおける管理者ユーザー作成バッチ（ffcrm:setup:admin）の設計について記載する。

### 本バッチの処理概要

このバッチは、Fat Free CRMの管理者ユーザーを作成または更新する。対話形式でユーザー名、パスワード、メールアドレスを入力し、管理者権限を持つユーザーを作成する。既存ユーザーが存在する場合は情報を更新する。

**業務上の目的・背景**：システム初期セットアップ時に管理者アカウントを作成し、管理者がシステムにログインできるようにする。また、パスワード忘れ等の緊急時に管理者アカウントのパスワードリセットにも使用できる。セキュアな方法で管理者認証情報を設定するための標準的な手順を提供する。

**バッチの実行タイミング**：初期インストール時、またはパスワードリセットが必要な場合に手動実行。

**主要な処理内容**：
1. 環境変数からの認証情報取得、または対話形式での入力
2. ユーザー名、パスワード、メールアドレスの確認
3. 既存ユーザーの検索、存在しなければ新規作成
4. メール確認のスキップ（skip_confirmation!）
5. 管理者フラグと停止フラグの設定

**前後の処理との関連**：ffcrm:setupタスクから呼び出されることが多い。db:migrateでusersテーブルが作成済みであることが前提。

**影響範囲**：usersテーブルへのレコード追加または更新。

## バッチ種別

セットアップ / ユーザー管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初期セットアップ時、パスワードリセット時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | usersテーブルが存在すること |
| Rails環境 | Railsアプリケーション環境がロードされていること |

### 実行可否判定

環境変数（USERNAME、PASSWORD、EMAIL）が全て設定されている場合は非対話モードで実行。それ以外は対話形式で入力を求める。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| USERNAME | 環境変数 | No | system | 管理者ユーザー名 |
| PASSWORD | 環境変数 | No | manager | 管理者パスワード |
| EMAIL | 環境変数 | No | - | 管理者メールアドレス（必須入力） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 | ENV | USERNAME、PASSWORD、EMAIL |
| STDIN | 標準入力 | 対話形式での入力 |
| users | DB | 既存ユーザーの検索 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| users | DB | 管理者ユーザーの作成または更新 |
| STDOUT | コンソール | 処理状況メッセージ |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 環境変数確認
   └─ USERNAME、PASSWORD、EMAILの取得
2. 対話形式入力（環境変数未設定時）
   └─ ユーザー名入力（デフォルト: system）
   └─ パスワード入力（デフォルト: manager、エコーなし）
   └─ メールアドレス入力（必須）
   └─ 確認プロンプト表示
3. 既存ユーザー検索
   └─ User.find_by_username(username)
4. ユーザー作成または更新
   └─ skip_confirmation!でメール確認スキップ
   └─ confirm呼び出し
   └─ username、password、email更新
   └─ confirmed_at設定
   └─ admin = true設定
   └─ suspended_at = nil設定
5. 完了メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{環境変数設定済?}
    B -->|Yes| C[環境変数から取得]
    B -->|No| D[対話形式入力開始]
    D --> E[ユーザー名入力]
    E --> F[パスワード入力]
    F --> G[メールアドレス入力]
    G --> H[確認情報表示]
    H --> I[Continue yes/no/exit 入力]
    I --> J{yes?}
    J -->|No| K{no?}
    K -->|Yes| D
    K -->|No| L[exit 終了]
    J -->|Yes| C
    C --> M[User.find_by_username]
    M --> N{ユーザー存在?}
    N -->|Yes| O[既存ユーザー取得]
    N -->|No| P[User.new]
    O --> Q[skip_confirmation!]
    P --> Q
    Q --> R[confirm]
    R --> S[update username/password/email]
    S --> T[update_attribute confirmed_at]
    T --> U[update_attribute admin=true]
    U --> V[update_attribute suspended_at=nil]
    V --> W[完了メッセージ出力]
    W --> X[バッチ終了]
    L --> X
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 既存ユーザー検索 | users | SELECT | usernameで検索 |
| ユーザー作成/更新 | users | INSERT/UPDATE | 管理者情報の保存 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | username | 入力値で検索 | 既存チェック |
| INSERT/UPDATE | username | 入力値またはデフォルト | ユーザー名 |
| INSERT/UPDATE | email | 入力値 | メールアドレス |
| INSERT/UPDATE | encrypted_password | password暗号化 | Deviseで暗号化 |
| UPDATE | confirmed_at | Time.now.utc | メール確認日時 |
| UPDATE | admin | true | 管理者フラグ |
| UPDATE | suspended_at | nil | 停止解除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 不正な入力値 | 再入力を促す |
| - | データベースエラー | DB接続失敗 | 接続設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（対話形式で再入力可能） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. バリデーションエラーの場合、入力値を確認して再実行
2. データベースエラーの場合、接続設定とマイグレーション状況を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各update操作ごと |
| コミットタイミング | 各操作完了時に自動コミット |
| ロールバック条件 | 個別操作失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件 |
| 目標処理時間 | 即時 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行の制限なし。同じユーザー名で同時実行した場合、後から実行した方の値で上書きされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 案内メッセージ | 対話開始時 | "To create the admin user you will be prompted..." |
| 確認メッセージ | 入力確認時 | Username、Password（マスク）、Email |
| 完了メッセージ | 処理完了時 | "Admin user has been created." |
| 中断メッセージ | 終了選択時 | "No admin user was created." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | - |

## 備考

- パスワード入力時はエコーを無効化（stty -echo）してセキュリティを確保
- Windows環境（mswin）ではエコー無効化をスキップ
- User.reset_column_informationで最新のカラム情報をリロード（マイグレーション直後に対応）
- admin属性とsuspended_at属性はattr_protectedのため、update_attributeで個別に設定
- 既存ユーザーの場合、パスワードも上書きされるため、パスワードリセットにも使用可能
- confirmed_atを設定することで、メール確認プロセスをスキップ
