# バッチ設計書 9-ffcrm:secret

## 概要

本ドキュメントは、Fat Free CRMにおけるシークレットトークン生成バッチ（ffcrm:secret）の設計について記載する。

### 本バッチの処理概要

このバッチは、Railsアプリケーションで使用するシークレットトークンを生成し、設定ファイルに書き込む。SecureRandomを使用して128文字（64バイト）の暗号学的に安全なランダム文字列を生成し、config/initializers/secret_token.rbファイルに保存する。

**業務上の目的・背景**：Railsアプリケーションではセッション管理やCSRF対策にシークレットトークンが必要である。本バッチは、セキュアなシークレットトークンを自動生成し、適切な設定ファイルに配置することで、セキュリティ設定の手間を省き、設定ミスを防止する。新規インストール時や、シークレットトークンの漏洩が疑われる場合の再生成に使用される。

**バッチの実行タイミング**：初期インストール時、またはシークレットトークンの再生成が必要な場合に手動実行。

**主要な処理内容**：
1. SecureRandom.hex(64)で128文字のランダム文字列を生成
2. config/initializers/secret_token.rbファイルを作成・上書き
3. 生成したトークンをRailsアプリケーション設定として書き込み

**前後の処理との関連**：本バッチはRails環境に依存せず（:environmentなし）、設定ファイルの生成のみを行う。生成後、Railsアプリケーションを再起動する必要がある。

**影響範囲**：config/initializers/secret_token.rbファイルの作成・上書き。既存のシークレットトークンがある場合は上書きされるため、セッションが無効化される可能性がある。

## バッチ種別

セットアップ / セキュリティ設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初期セットアップ時、再生成時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Railsプロジェクト | Rails.rootが利用可能であること |
| 書き込み権限 | config/initializersディレクトリへの書き込み権限 |

### 実行可否判定

特になし。常に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | Rakeタスクとして引数なしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SecureRandom | Ruby標準ライブラリ | 暗号学的に安全な乱数生成 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| config/initializers/secret_token.rb | Rubyファイル | シークレットトークン設定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | secret_token.rb |
| 出力先 | config/initializers/ |
| 文字コード | UTF-8 |
| 形式 | Rubyコード |

出力内容例：
```ruby
FatFreeCRM::Application.config.secret_token = 'a1b2c3d4e5f6...(128文字のhex文字列)'
```

## 処理フロー

### 処理シーケンス

```
1. securerandomライブラリのロード
   └─ require 'securerandom'
2. シークレットトークン生成
   └─ SecureRandom.hex(64)で128文字生成
3. ファイルパス構築
   └─ Rails.root/config/initializers/secret_token.rb
4. ファイル書き込み
   └─ File.open(..., 'w')
   └─ 設定コードを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[securerandomロード]
    B --> C[SecureRandom.hex 64 実行]
    C --> D[128文字のトークン生成]
    D --> E[ファイルパス構築]
    E --> F[secret_token.rbを開く]
    F --> G[設定コードを書き込み]
    G --> H[ファイルクローズ]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル書き込みエラー | 権限不足、ディスク容量不足 | ディレクトリ権限を確認 |
| - | パス解決エラー | Rails.root未定義 | Railsプロジェクトとして実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ファイル書き込みエラーの場合、ディレクトリ権限を確認
2. 手動でファイルを作成することも可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 即時 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行の制限なし。ファイル上書きのため、同時実行した場合は後から完了した方の値で上書きされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 標準出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | - |

## 備考

- 本バッチはRails環境（:environment依存）なしで実行可能
- 生成されるトークンは128文字の16進数文字列（64バイト = 512ビットのエントロピー）
- SecureRandomは暗号学的に安全な乱数を生成するため、予測困難なトークンが生成される
- シークレットトークンを再生成すると、既存のセッションが無効化される可能性があるため注意
- 本番環境では、シークレットトークンをバージョン管理に含めないようにする（.gitignoreに追加推奨）
- Rails 4.1以降では、secrets.ymlやcredentials.yml.encの使用が推奨されている
- 生成されたファイルはアプリケーション再起動後に有効となる
