---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-ffcrm_dropbox_run.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **想定処理件数**：具体的な数値の根拠なし
  2. **監視・アラート設定**：コード内に明示的な設定なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tasks/ffcrm/dropbox.rake` - Rakeタスク定義
- E-02: `lib/fat_free_crm/mail_processor/base.rb` - 基底クラス実装
- E-03: `lib/fat_free_crm/mail_processor/dropbox.rb` - Dropboxプロセッサ実装
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IMAPサーバーに接続してメールを処理する | E-02 (connect!メソッド, line 69-79) | ○ |
| C-02 | Account、Contact、Leadに関連付ける | E-03 (@@assets = [Account, Contact, Lead], line 21) | ○ |
| C-03 | 未読メール（NOT SEEN）を検索 | E-02 (uid_search(['NOT', 'SEEN']), line 97) | ○ |
| C-04 | 送信者がシステム内の有効なユーザーか検証 | E-02 (sent_from_known_user?, line 152-157) | ○ |
| C-05 | Emailレコードを作成 | E-03 (Email.create, line 157-168) | ○ |
| C-06 | Setting.email_dropboxから設定を読み込む | E-03 (@settings = Setting.email_dropbox.dup, line 22) | ○ |
| C-07 | dry_run引数でドライラン可能 | E-02 (run(dry_run = false), line 52) | ○ |
| C-08 | 処理済みメールをアーカイブ | E-02 (archive, line 134-142) | ○ |
| C-09 | 無効なメールを破棄 | E-02 (discard, line 122-130) | ○ |
| C-10 | メール本文1行目のキーワードで関連付け | E-03 (with_explicit_keyword, line 55-58) | ○ |
| C-11 | 転送メールからアドレス抽出 | E-03 (with_forwarded_recipient, line 81-83) | ○ |
| C-12 | Lead status='new'を'contacted'に更新 | E-03 (line 171) | ○ |
| C-13 | エンティティが存在しない場合に作成 | E-03 (create_and_attach, line 140-143) | ○ |
| C-14 | text/html以外のみ有効 | E-02 (is_valid?, line 145-149) | ○ |
| C-15 | PaperTrailでバージョン管理 | E-02 (PaperTrail.request.whodunnit, line 166) | ○ |
| C-16 | 処理件数をログ出力 | E-02 (line 61) | ○ |
| C-17 | IMAPフォルダを作成する機能 | E-02 (setup, line 28-49) | ○ |
| C-18 | move_to_folderにメールをコピー | E-02 (archive, line 138) | ○ |
| C-19 | move_invalid_to_folderに無効メールをコピー | E-02 (discard, line 126) | ○ |
| C-20 | emailまたはalt_emailで送信者検索 | E-02 (find_sender, line 160-168) | ○ |
| C-21 | アカウントにもメール関連付け可能 | E-03 (@settings[:attach_to_account], line 173-187) | ○ |
| C-22 | Shared設定時はPrivateで作成 | E-03 (default_access, line 252-254) | ○ |
| C-23 | ドメインからAccountを検索・作成 | E-03 (default_values_for_contact, line 232-246) | ○ |
| C-24 | 想定処理件数：数件〜数百件 | **根拠なし** | △ |
| C-25 | 監視・アラート設定なし | **根拠なし**（コード内に設定なし） | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠：運用実績やドキュメントなし
  - 候補：運用ログ / パフォーマンステスト結果 / 要件定義書
- 監視・アラート設定：コード内にモニタリング機能の実装なし
  - 候補：外部監視ツール設定 / インフラ設定ファイル / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックは全てコードから確認可能
- 1: 中リスク - パフォーマンス要件は推定値のため、実運用での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] IMAP接続設定（Setting.email_dropbox）が正しく定義されているか
- [ ] 想定処理件数が実際の運用と整合しているか
- [ ] エラー時の通知・監視体制が運用上整備されているか
- [ ] 同時実行防止の仕組みがcron設定等で考慮されているか
