---
generated_at: 2026-01-13 17:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-ffcrm_demo_load

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **処理時間数分程度**：パフォーマンス要件に具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tasks/ffcrm/demo.rake` （12-71行目）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （15行目）
- E-03: `db/demo/` ディレクトリ内のフィクスチャファイル群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名はffcrm:demo:load | E-02 | ○ |
| C-02 | :environment依存タスク | E-01 (13行目: task load: :environment) | ○ |
| C-03 | db/demo/*.{yml,csv}からフィクスチャ読み込み | E-01 (16行目: Dir.glob) | ○ |
| C-04 | ActiveRecord::FixtureSet.create_fixturesで投入 | E-01 (17行目) | ○ |
| C-05 | pravatar.ccからアバター画像取得 | E-01 (24行目: URI.open("https://i.pravatar.cc/180")) | ○ |
| C-06 | アバター取得失敗時はエラーメッセージ出力 | E-01 (27-28行目: rescue OpenURI::HTTPError) | ○ |
| C-07 | User.find_eachでユーザーループ | E-01 (21行目) | ○ |
| C-08 | Active Storageでアタッチ | E-01 (25行目: avatar.image.attach) | ○ |
| C-09 | 9種類のモデルのアクティビティ生成 | E-01 (42行目: %w[Account Address Campaign...]) | ○ |
| C-10 | create/update/viewイベント生成 | E-01 (61-66行目: create_version) | ○ |
| C-11 | 過去30日のランダム日時 | E-01 (58行目: rand(1..30).days) | ○ |
| C-12 | $stdout.sync = true設定 | E-01 (40行目) | ○ |
| C-13 | 進捗ログとして"."出力 | E-01 (68行目: print "." if item.id % 10 == 0) | ○ |
| C-14 | Versionモデルでアクティビティ保存 | E-01 (33-37行目: create_version) | ○ |
| C-15 | デモデータカテゴリ | E-02 | ○ |
| C-16 | フィクスチャファイル一覧 | E-03 | ○ |
| C-17 | "Fetching avatars for users..."ログ | E-01 (20行目) | ○ |
| C-18 | 処理時間数分程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスに関する実測データ
  - 候補：ベンチマーク結果 / 運用実績

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 外部サービス（pravatar.cc）への依存

## 6) レビュアーチェックリスト（最小）
- [ ] pravatar.ccへのネットワーク接続が可能か確認
- [ ] フィクスチャファイルの内容が最新か確認
- [ ] 既存データへの影響を確認（上書きの可能性）
