---
generated_at: 2026-01-13 17:48:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：15-ffcrm_demo_reload

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **処理時間数分〜10分程度**：パフォーマンス要件に具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tasks/ffcrm/demo.rake` （73-77行目）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （16行目）
- E-03: Rails標準タスク db:migrate:reset の仕様

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名はffcrm:demo:reload | E-02 | ○ |
| C-02 | :environment依存タスク | E-01 (74行目: task reload: :environment) | ○ |
| C-03 | db:migrate:resetを呼び出す | E-01 (75行目: Rake::Task["db:migrate:reset"].invoke) | ○ |
| C-04 | ffcrm:demo:loadを呼び出す | E-01 (76行目: Rake::Task["ffcrm:demo:load"].invoke) | ○ |
| C-05 | データベースをリセットしデモデータを再ロード | E-02 (説明列) | ○ |
| C-06 | デフォルトアプリケーション設定も再ロード | E-02 (説明列) | ○ |
| C-07 | db:migrate:resetはdrop/create/migrateの組み合わせ | E-03 (Rails標準仕様) | ○ |
| C-08 | デモデータカテゴリ | E-02 | ○ |
| C-09 | 既存データすべて削除 | E-03 (db:dropの動作) | ○ |
| C-10 | パラメータなし | E-01 (タスク定義) | ○ |
| C-11 | 標準出力なし（本タスク自体） | E-01 (putsなし) | ○ |
| C-12 | 処理時間数分〜10分程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスに関する実測データ
  - 候補：ベンチマーク結果 / 運用実績

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - データベース全体が削除される破壊的操作

## 6) レビュアーチェックリスト（最小）
- [ ] 本番環境で実行しないこと
- [ ] 実行前にバックアップを取得すること
- [ ] RAILS_ENVが適切（development/demo等）であることを確認
