---
generated_at: 2026-01-13 17:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：16-ffcrm_update_data_fix_countries

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **処理時間数秒〜数分**：パフォーマンス要件に具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tasks/ffcrm/update_data.rake` （9-238行目）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （17行目）
- E-03: `app/models/polymorphic/address.rb` （8-26行目 スキーマ情報）
- E-04: ソースコード内のコメント（11-29行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名はffcrm:update_data:fix_countries | E-02 | ○ |
| C-02 | :environment依存タスク | E-01 (31行目: task fix_countries: :environment) | ○ |
| C-03 | ISO 3166-1に更新する | E-02 (説明列), E-01 (30行目desc) | ○ |
| C-04 | 一度のみ実行可能 | E-02 (備考列), E-04 (19行目) | ○ |
| C-05 | Setting.have_run_country_migrationで制御 | E-01 (57行目) | ○ |
| C-06 | 警告メッセージを表示して終了 | E-01 (32-59行目) | ○ |
| C-07 | 変換テーブルに約100件の国コード | E-01 (62-207行目: convert_table配列) | ○ |
| C-08 | Australia: AS → AU の変換 | E-01 (71行目) | ○ |
| C-09 | Address.arel_tableで検索 | E-01 (215-217行目) | ○ |
| C-10 | トランザクション内で処理 | E-01 (225行目: Address.transaction) | ○ |
| C-11 | save!で保存 | E-01 (228行目) | ○ |
| C-12 | 例外時はロールバック | E-01 (231-234行目: raise ActiveRecord::Rollback) | ○ |
| C-13 | Aland Islandsは除外 | E-01 (63行目コメント) | ○ |
| C-14 | 複数回実行で誤変換の警告 | E-04 (20-24行目) | ○ |
| C-15 | データ更新カテゴリ | E-02 | ○ |
| C-16 | addressesテーブルのスキーマ | E-03 | ○ |
| C-17 | countryカラムを更新 | E-01 (220行目: t.country = ct[2]) | ○ |
| C-18 | 処理時間数秒〜数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスに関する実測データ
  - 候補：ベンチマーク結果 / 運用実績

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 一度しか実行できない破壊的操作、複数回実行でデータ破損の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 実行前にバックアップを取得すること
- [ ] Setting.have_run_country_migrationがfalseであることを確認
- [ ] 変換対象の住所データを事前に確認
- [ ] 変換後のデータを検証
