---
generated_at: 2026-01-13 17:54:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-ffcrm_missing_translations_detect

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **処理時間1秒以内**：パフォーマンス要件に具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tasks/ffcrm/missing_translations.rake` （9-36行目）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （19行目）
- E-03: `lib/missing_translation_detector.rb` （1-53行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名はffcrm:missing_translations:detect | E-02 | ○ |
| C-02 | :environment依存タスク | E-01 (14行目: => [:environment]) | ○ |
| C-03 | localeパラメータを受け取る | E-01 (14行目: :detect, [:locale]) | ○ |
| C-04 | 基準ロケールはen-US | E-01 (15行目: base_locale = 'en-US') | ○ |
| C-05 | 3種類のファイルペアを比較 | E-01 (17-19行目: 配列で3ペア定義) | ○ |
| C-06 | fat_free_crmとransackのサフィックス | E-01 (18-19行目) | ○ |
| C-07 | MissingTranslationDetectorを使用 | E-01 (20-21行目) | ○ |
| C-08 | detector.detectを呼び出す | E-01 (22行目) | ○ |
| C-09 | missing_translations?で結果確認 | E-01 (24行目) | ○ |
| C-10 | キーパスと値を出力 | E-01 (31行目: missing.key_path.join..., missing.value) | ○ |
| C-11 | 再帰的にネストキーを走査 | E-03 (17-27行目: detect メソッド) | ○ |
| C-12 | YAML.load_fileでファイル読み込み | E-03 (50行目) | ○ |
| C-13 | 翻訳漏れがない場合は出力なし | E-01 (24行目: next unless detector.missing_translations?) | ○ |
| C-14 | 国際化カテゴリ | E-02 | ○ |
| C-15 | 処理時間1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスに関する実測データ
  - 候補：ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の品質チェックツール

## 6) レビュアーチェックリスト（最小）
- [ ] 対象ロケールのファイルが存在することを確認
- [ ] YAML構文が正しいことを確認
- [ ] 検出された翻訳漏れを対象ファイルに追加
