---
generated_at: 2026-01-13 17:58:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：20-rdoc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **処理時間数秒〜数十秒**：パフォーマンス要件に具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/development_tasks/rdoc.rake` （8-22行目）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （21行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名はrdoc | E-02 | ○ |
| C-02 | RDoc::Taskを使用 | E-01 (16行目: RDoc::Task.new) | ○ |
| C-03 | 出力ディレクトリはrdoc/ | E-01 (17行目: rdoc.rdoc_dir = 'rdoc') | ○ |
| C-04 | タイトルは'FatFreeCRM' | E-01 (18行目: rdoc.title = 'FatFreeCRM') | ○ |
| C-05 | --line-numbersオプション | E-01 (19行目: rdoc.options << '--line-numbers') | ○ |
| C-06 | README.mdを含む | E-01 (20行目: rdoc.rdoc_files.include('README.md')) | ○ |
| C-07 | lib/**/*.rbを含む | E-01 (21行目: rdoc.rdoc_files.include('lib/**/*.rb')) | ○ |
| C-08 | require 'rdoc/task'を使用 | E-01 (9行目) | ○ |
| C-09 | 互換性コードでrake/rdoctaskをフォールバック | E-01 (11-13行目: rescue LoadError) | ○ |
| C-10 | 開発カテゴリ | E-02 | ○ |
| C-11 | RDocドキュメントを生成 | E-02 (説明列) | ○ |
| C-12 | パラメータなし | E-01 (16行目: RDoc::Task.new(:rdoc)) | ○ |
| C-13 | 処理時間数秒〜数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスに関する実測データ
  - 候補：ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用でファイル生成のみ

## 6) レビュアーチェックリスト（最小）
- [ ] rdoc gemがインストールされていることを確認
- [ ] README.mdが存在することを確認
- [ ] rdoc/ディレクトリへの書き込み権限を確認
