---
generated_at: 2026-01-13 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-ffcrm_dropbox_setup.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にコード根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tasks/ffcrm/dropbox.rake` - Rakeタスク定義（setup）
- E-02: `lib/fat_free_crm/mail_processor/base.rb` - 基底クラス実装（setupメソッド）
- E-03: `lib/fat_free_crm/mail_processor/dropbox.rb` - Dropboxプロセッサ実装
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | setupメソッドでフォルダ確認・作成 | E-01 (line 25-28), E-02 (line 28-49) | ○ |
| C-02 | connect!(setup: true)でフォルダ選択スキップ | E-02 (line 30, 74) | ○ |
| C-03 | scan_folderを確認 | E-02 (line 32) | ○ |
| C-04 | move_to_folderを確認（設定時） | E-02 (line 33) | ○ |
| C-05 | move_invalid_to_folderを確認（設定時） | E-02 (line 34) | ○ |
| C-06 | @imap.listでフォルダ存在確認 | E-02 (line 38) | ○ |
| C-07 | @imap.createでフォルダ作成 | E-02 (line 42) | ○ |
| C-08 | "folder {folder} OK"ログ出力 | E-02 (line 39) | ○ |
| C-09 | "folder {folder} missing, creating..."ログ出力 | E-02 (line 41) | ○ |
| C-10 | "connecting to {server}..."ログ出力 | E-02 (line 29) | ○ |
| C-11 | 例外をキャッチしてログ出力 | E-02 (line 45-46) | ○ |
| C-12 | ensureでdisconnect!呼び出し | E-02 (line 47-48) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セットアップ処理は単純で、コードから完全に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] IMAPサーバーでフォルダ作成権限があるか
- [ ] フォルダ名の設定が適切か（Setting.email_dropboxの内容確認）
- [ ] セットアップ後にffcrm:dropbox:run:dryで動作確認を行うか
