---
generated_at: 2026-01-13 12:00:00
metrics:
  claims_total: 218
  claims_with_evidence: 218
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：entities.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：218 / 218、根拠なし：0
- 優先レビュー（高）
  1. **金額計算ロジック（weighted_amount）**：ビジネス上重要な計算
  2. **カウンターキャッシュ処理**：データ整合性に関わる
  3. **アクセス制御バリデーション**：セキュリティに関わる

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/entities/account.rb`
- E-02: `app/models/entities/account_contact.rb`
- E-03: `app/models/entities/account_opportunity.rb`
- E-04: `app/models/entities/campaign.rb`
- E-05: `app/models/entities/contact.rb`
- E-06: `app/models/entities/contact_opportunity.rb`
- E-07: `app/models/entities/lead.rb`
- E-08: `app/models/entities/opportunity.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Account (UT-ENT-001 〜 UT-ENT-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :user リレーション | E-01 (L31) | ○ |
| C-02 | belongs_to :assignee リレーション | E-01 (L32) | ○ |
| C-03 | has_many :contacts through :account_contacts | E-01 (L33-34) | ○ |
| C-04 | has_many :opportunities through :account_opportunities | E-01 (L35-37) | ○ |
| C-05 | has_many :tasks as: :asset | E-01 (L38) | ○ |
| C-06 | has_one :billing_address with scope | E-01 (L39) | ○ |
| C-07 | has_one :shipping_address with scope | E-01 (L40) | ○ |
| C-08 | has_many :addresses | E-01 (L41) | ○ |
| C-09 | has_many :emails as: :mediator | E-01 (L42) | ○ |
| C-10 | scope :state フィルタリング | E-01 (L49-51) | ○ |
| C-11 | scope :created_by | E-01 (L52) | ○ |
| C-12 | scope :assigned_to | E-01 (L53) | ○ |
| C-13 | scope :text_search | E-01 (L55) | ○ |
| C-14 | scope :visible_on_dashboard | E-01 (L57-60) | ○ |
| C-15 | scope :by_name | E-01 (L62) | ○ |
| C-16 | self.per_page = 20 | E-01 (L88-90) | ○ |
| C-17 | location メソッドの郵便番号除去ロジック | E-01 (L94-99) | ○ |
| C-18 | attach! メソッド | E-01 (L103-105) | ○ |
| C-19 | discard! メソッド | E-01 (L109-115) | ○ |
| C-20 | self.create_or_select_for メソッド | E-01 (L119-137) | ○ |
| C-21 | validates_presence_of :name | E-01 (L76) | ○ |
| C-22 | validates_uniqueness_of :name | E-01 (L77) | ○ |
| C-23 | validates :rating inclusion 0..5 | E-01 (L78) | ○ |
| C-24 | validates :latitude numericality | E-01 (L80) | ○ |
| C-25 | validates :longitude numericality | E-01 (L81) | ○ |
| C-26 | users_for_shared_access バリデーション | E-01 (L143-145) | ○ |
| C-27 | nullify_blank_category before_save | E-01 (L147-149) | ○ |

### AccountContact (UT-ENT-046 〜 UT-ENT-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | belongs_to :account with counter_cache | E-02 (L21) | ○ |
| C-29 | belongs_to :contact | E-02 (L22) | ○ |
| C-30 | validates_presence_of :account_id | E-02 (L27) | ○ |

### AccountOpportunity (UT-ENT-050 〜 UT-ENT-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | belongs_to :account with counter_cache | E-03 (L21) | ○ |
| C-32 | belongs_to :opportunity | E-03 (L22) | ○ |
| C-33 | validates_presence_of :account_id, :opportunity_id | E-03 (L23) | ○ |

### Campaign (UT-ENT-055 〜 UT-ENT-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | belongs_to :user | E-04 (L35) | ○ |
| C-35 | belongs_to :assignee | E-04 (L36) | ○ |
| C-36 | has_many :tasks as: :asset | E-04 (L37) | ○ |
| C-37 | has_many :leads | E-04 (L38) | ○ |
| C-38 | has_many :opportunities | E-04 (L39) | ○ |
| C-39 | has_many :emails as: :mediator | E-04 (L40) | ○ |
| C-40 | scope :state フィルタリング | E-04 (L44-46) | ○ |
| C-41 | self.per_page = 20 | E-04 (L72-74) | ○ |
| C-42 | attach! メソッド | E-04 (L78-88) | ○ |
| C-43 | discard! メソッド | E-04 (L92-99) | ○ |
| C-44 | validates_presence_of :name | E-04 (L64) | ○ |
| C-45 | validates_uniqueness_of :name | E-04 (L65) | ○ |
| C-46 | start_and_end_dates バリデーション | E-04 (L105-107) | ○ |
| C-47 | users_for_shared_access バリデーション | E-04 (L111-113) | ○ |

### Contact (UT-ENT-079 〜 UT-ENT-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | belongs_to :user | E-05 (L41) | ○ |
| C-49 | belongs_to :lead | E-05 (L42) | ○ |
| C-50 | belongs_to :assignee | E-05 (L43) | ○ |
| C-51 | belongs_to :reporting_user | E-05 (L44) | ○ |
| C-52 | has_one :account_contact | E-05 (L45) | ○ |
| C-53 | has_one :account through | E-05 (L46) | ○ |
| C-54 | has_many :contact_opportunities | E-05 (L47) | ○ |
| C-55 | has_many :opportunities through | E-05 (L48) | ○ |
| C-56 | has_many :tasks as: :asset | E-05 (L49) | ○ |
| C-57 | has_one :business_address | E-05 (L50) | ○ |
| C-58 | delegate :campaign | E-05 (L54) | ○ |
| C-59 | scope :text_search 名前順列検索 | E-05 (L66-84) | ○ |
| C-60 | self.per_page = 20 | E-05 (L116-118) | ○ |
| C-61 | self.first_name_position = "before" | E-05 (L120-122) | ○ |
| C-62 | full_name メソッド | E-05 (L125-131) | ○ |
| C-63 | save_with_account_and_permissions | E-05 (L136-141) | ○ |
| C-64 | update_with_account_and_permissions | E-05 (L145-151) | ○ |
| C-65 | attach! メソッド | E-05 (L155-157) | ○ |
| C-66 | discard! メソッド | E-05 (L161-167) | ○ |
| C-67 | self.create_for メソッド | E-05 (L171-205) | ○ |
| C-68 | validates_length_of 各フィールド | E-05 (L100-112) | ○ |
| C-69 | users_for_shared_access バリデーション | E-05 (L211-213) | ○ |

### ContactOpportunity (UT-ENT-121 〜 UT-ENT-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | belongs_to :contact | E-06 (L22) | ○ |
| C-71 | belongs_to :opportunity | E-06 (L23) | ○ |
| C-72 | validates_presence_of :contact_id, :opportunity_id | E-06 (L24) | ○ |

### Lead (UT-ENT-125 〜 UT-ENT-163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | belongs_to :user | E-07 (L41) | ○ |
| C-74 | belongs_to :campaign | E-07 (L42) | ○ |
| C-75 | belongs_to :assignee | E-07 (L43) | ○ |
| C-76 | has_one :contact dependent: :nullify | E-07 (L44) | ○ |
| C-77 | has_many :tasks as: :asset | E-07 (L45) | ○ |
| C-78 | has_one :business_address | E-07 (L46) | ○ |
| C-79 | scope :state フィルタリング | E-07 (L54-56) | ○ |
| C-80 | scope :converted | E-07 (L57) | ○ |
| C-81 | scope :for_campaign | E-07 (L58) | ○ |
| C-82 | after_create :increment_leads_count | E-07 (L81) | ○ |
| C-83 | after_destroy :decrement_leads_count | E-07 (L82) | ○ |
| C-84 | self.per_page = 20 | E-07 (L86-88) | ○ |
| C-85 | save_with_permissions メソッド | E-07 (L96-104) | ○ |
| C-86 | update_with_lead_counters メソッド | E-07 (L108-119) | ○ |
| C-87 | promote メソッド | E-07 (L124-133) | ○ |
| C-88 | convert メソッド | E-07 (L136-138) | ○ |
| C-89 | reject メソッド | E-07 (L141-143) | ○ |
| C-90 | attach! メソッド | E-07 (L147-149) | ○ |
| C-91 | discard! メソッド | E-07 (L153-155) | ○ |
| C-92 | full_name メソッド | E-07 (L158-164) | ○ |
| C-93 | increment_leads_count private | E-07 (L170-172) | ○ |
| C-94 | decrement_leads_count private | E-07 (L175-177) | ○ |
| C-95 | users_for_shared_access バリデーション | E-07 (L181-183) | ○ |

### Opportunity (UT-ENT-163 〜 UT-ENT-218)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | belongs_to :user | E-08 (L31) | ○ |
| C-97 | belongs_to :campaign | E-08 (L32) | ○ |
| C-98 | belongs_to :assignee | E-08 (L33) | ○ |
| C-99 | has_one :account_opportunity | E-08 (L34) | ○ |
| C-100 | has_one :account through | E-08 (L35) | ○ |
| C-101 | has_many :contact_opportunities | E-08 (L36) | ○ |
| C-102 | has_many :contacts through | E-08 (L37) | ○ |
| C-103 | has_many :tasks as: :asset | E-08 (L38) | ○ |
| C-104 | scope :state フィルタリング | E-08 (L43-45) | ○ |
| C-105 | scope :won | E-08 (L48) | ○ |
| C-106 | scope :lost | E-08 (L49) | ○ |
| C-107 | scope :not_lost | E-08 (L50) | ○ |
| C-108 | scope :pipeline | E-08 (L51) | ○ |
| C-109 | scope :unassigned | E-08 (L52) | ○ |
| C-110 | scope :weighted_sort | E-08 (L53) | ○ |
| C-111 | scope :text_search 名前/ID検索 | E-08 (L56-62) | ○ |
| C-112 | scope :visible_on_dashboard | E-08 (L64-67) | ○ |
| C-113 | self.per_page = 20 | E-08 (L94-96) | ○ |
| C-114 | self.default_stage メソッド | E-08 (L98-100) | ○ |
| C-115 | weighted_amount メソッド | E-08 (L103-105) | ○ |
| C-116 | save_with_account_and_permissions | E-08 (L109-119) | ○ |
| C-117 | update_with_account_and_permissions | E-08 (L123-133) | ○ |
| C-118 | attach! メソッド | E-08 (L137-139) | ○ |
| C-119 | discard! メソッド | E-08 (L143-149) | ○ |
| C-120 | self.create_for メソッド | E-08 (L153-167) | ○ |
| C-121 | validates_presence_of :name | E-08 (L84) | ○ |
| C-122 | validates_numericality_of | E-08 (L85) | ○ |
| C-123 | after_create :increment_opportunities_count | E-08 (L89) | ○ |
| C-124 | after_destroy :decrement_opportunities_count | E-08 (L90) | ○ |
| C-125 | increment_opportunities_count private | E-08 (L178-180) | ○ |
| C-126 | decrement_opportunities_count private | E-08 (L183-185) | ○ |
| C-127 | users_for_shared_access バリデーション | E-08 (L173-175) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり
- 注意点：
  - weighted_amount の計算ロジックはビジネス上重要なため、実際の計算結果をテストで確認すること
  - カウンターキャッシュ（leads_count, opportunities_count, contacts_count）の更新はデータ整合性に関わるため重点的にテストすること
  - users_for_shared_access のアクセス制御はセキュリティに関わるため確実にテストすること

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルのリレーション定義がソースコードと一致しているか確認
- [ ] バリデーションのテストケースが全ての validates 宣言をカバーしているか確認
- [ ] スコープのテストケースが全ての scope 定義をカバーしているか確認
- [ ] コールバック（after_create, after_destroy, before_save）のテストケースが適切か確認
- [ ] 金額計算（weighted_amount）のテストケースが境界値を含んでいるか確認
- [ ] アクセス制御（users_for_shared_access）のテストケースが適切か確認
- [ ] カウンターキャッシュの増減テストが適切か確認
