---
generated_at: 2026-01-13 18:25:00
metrics:
  claims_total: 104
  claims_with_evidence: 104
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：fields.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：104 / 104、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースにソースコード根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/fields/field.rb` - Fieldモデルクラス（129行）
- E-02: `app/models/fields/field_group.rb` - FieldGroupモデルクラス（65行）
- E-03: `app/models/fields/core_field.rb` - CoreFieldモデルクラス（40行）
- E-04: `app/models/fields/custom_field.rb` - CustomFieldモデルクラス（152行）
- E-05: `app/models/fields/custom_field_pair.rb` - CustomFieldPairモデルクラス（43行）
- E-06: `app/models/fields/custom_field_date_pair.rb` - CustomFieldDatePairモデルクラス（46行）
- E-07: `app/models/fields/custom_field_datetime_pair.rb` - CustomFieldDatetimePairモデルクラス（14行）
- E-08: `spec/models/fields/field_spec.rb` - Field既存テスト（71行）
- E-09: `spec/models/fields/field_group_spec.rb` - FieldGroup既存テスト（29行）
- E-10: `spec/models/fields/custom_field_spec.rb` - CustomField既存テスト（142行）
- E-11: `spec/models/fields/custom_field_pair_spec.rb` - CustomFieldPair既存テスト（70行）
- E-12: `spec/models/fields/custom_field_date_pair_spec.rb` - CustomFieldDatePair既存テスト（92行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Field クラス (UT-FLD-001 ~ UT-FLD-033)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-FLD-001) | field_groupリレーションがbelongs_toで定義 | E-01 (L37: `belongs_to :field_group, optional: true`) | ○ |
| C-02 (UT-FLD-002) | field_groupがoptionalでnil許容 | E-01 (L37: `optional: true`) | ○ |
| C-03 (UT-FLD-003) | core_fieldsスコープが存在 | E-01 (L39: `scope :core_fields, -> { where(type: 'CoreField') }`) | ○ |
| C-04 (UT-FLD-004) | custom_fieldsスコープが存在 | E-01 (L40: `scope :custom_fields, -> { where("type != 'CoreField'") }`) | ○ |
| C-05 (UT-FLD-005) | without_pairsスコープが存在 | E-01 (L41: `scope :without_pairs, -> { where(pair_id: nil) }`) | ○ |
| C-06 (UT-FLD-006~008) | column_typeメソッドが型を返す | E-01 (L70-72: `def column_type`) | ○ |
| C-07 (UT-FLD-009) | 不正な型で例外発生 | E-01 (L71: `raise("Unknown field_type: #{field_type}")`) | ○ |
| C-08 (UT-FLD-010~011) | input_optionsメソッドが存在 | E-01 (L74-79: `def input_options`), E-08 (L48-50) | ○ |
| C-09 (UT-FLD-012~014) | collection_string=ミューテータが存在 | E-01 (L81-83: `def collection_string=`) | ○ |
| C-10 (UT-FLD-015~016) | collection_stringアクセサが存在 | E-01 (L85-87: `def collection_string`) | ○ |
| C-11 (UT-FLD-017) | render_valueメソッドが存在 | E-01 (L89-91: `def render_value`) | ○ |
| C-12 (UT-FLD-018~023) | renderメソッドが型別処理 | E-01 (L93-104: `def render`), E-08 (L52-70) | ○ |
| C-13 (UT-FLD-024) | field_typesクラスメソッドが存在 | E-01 (L109-111: `def field_types`), E-08 (L44-46) | ○ |
| C-14 (UT-FLD-025) | registerクラスメソッドが存在 | E-01 (L116-119: `def register`) | ○ |
| C-15 (UT-FLD-026) | lookup_classクラスメソッドが存在 | E-01 (L123-125: `def lookup_class`) | ○ |
| C-16 (UT-FLD-027~033) | バリデーションが定義されている | E-01 (L62-68: `validates_presence_of`, `validates_length_of`, etc.) | ○ |

### FieldGroup クラス (UT-FLD-034 ~ UT-FLD-048)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 (UT-FLD-034) | fieldsリレーションがhas_manyで定義 | E-02 (L24: `has_many :fields, -> { order :position }`), E-09 (L27) | ○ |
| C-18 (UT-FLD-035~036) | tagリレーションがbelongs_toで定義 | E-02 (L25: `belongs_to :tag, optional: true`) | ○ |
| C-19 (UT-FLD-037) | keyメソッドが存在 | E-02 (L34-36: `def key`) | ○ |
| C-20 (UT-FLD-038~039) | klassメソッドが存在 | E-02 (L38-40: `def klass`) | ○ |
| C-21 (UT-FLD-040) | with_tagsクラスメソッドが存在 | E-02 (L42-44: `def self.with_tags`) | ○ |
| C-22 (UT-FLD-041~042) | label_i18nメソッドが存在 | E-02 (L46-48: `def label_i18n`) | ○ |
| C-23 (UT-FLD-043) | labelのpresenceバリデーション | E-02 (L28: `validates_presence_of :label`) | ○ |
| C-24 (UT-FLD-044~045) | before_saveコールバックでname自動生成 | E-02 (L30-32: `before_save do`) | ○ |
| C-25 (UT-FLD-046~047) | not_default_field_groupメソッド | E-02 (L53-55: `def not_default_field_group`) | ○ |
| C-26 (UT-FLD-048) | move_fields_to_default_field_groupメソッド | E-02 (L58-62: `def move_fields_to_default_field_group`) | ○ |

### CoreField クラス (UT-FLD-049 ~ UT-FLD-052)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 (UT-FLD-049~051) | attr_readonlyで属性が読み取り専用 | E-03 (L32: `attr_readonly :name, :as, :collection`) | ○ |
| C-28 (UT-FLD-052) | error_on_destroyメソッドが存在 | E-03 (L35-37: `def error_on_destroy`) | ○ |

### CustomField クラス (UT-FLD-053 ~ UT-FLD-077)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 (UT-FLD-053) | table_nameが委譲されている | E-04 (L53: `delegate :table_name, to: :klass`) | ○ |
| C-30 (UT-FLD-054~055) | available_asメソッドが存在 | E-04 (L64-68: `def available_as`), E-10 (L80-87) | ○ |
| C-31 (UT-FLD-056~061) | custom_validatorメソッドが存在 | E-04 (L73-78: `def custom_validator`), E-10 (L123-141) | ○ |
| C-32 (UT-FLD-062~065) | db_transition_safetyメソッドが存在 | E-04 (L90-101: `def db_transition_safety`), E-10 (L69-78) | ○ |
| C-33 (UT-FLD-066~068) | generate_column_nameメソッドが存在 | E-04 (L107-115: `def generate_column_name`), E-10 (L58-67) | ○ |
| C-34 (UT-FLD-069~070) | column_optionsメソッドが存在 | E-04 (L119-121: `def column_options`) | ○ |
| C-35 (UT-FLD-071~073) | add_columnメソッドが存在 | E-04 (L125-130: `def add_column`), E-10 (L32-43) | ○ |
| C-36 (UT-FLD-074) | add_ransack_translationメソッドが存在 | E-04 (L133-138: `def add_ransack_translation`) | ○ |
| C-37 (UT-FLD-075~077) | update_columnメソッドが存在 | E-04 (L143-149: `def update_column`), E-10 (L89-105) | ○ |

### CustomFieldPair クラス (UT-FLD-078 ~ UT-FLD-087)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 (UT-FLD-078) | pairリレーションがhas_oneで定義 | E-05 (L9: `has_one :pair, class_name: 'CustomFieldPair'...`), E-11 (L13-15) | ○ |
| C-39 (UT-FLD-079~081) | create_pairクラスメソッドが存在 | E-05 (L13-21: `def self.create_pair`), E-11 (L17-31) | ○ |
| C-40 (UT-FLD-082~084) | update_pairクラスメソッドが存在 | E-05 (L25-34: `def self.update_pair`), E-11 (L33-56) | ○ |
| C-41 (UT-FLD-085~087) | paired_withメソッドが存在 | E-05 (L38-40: `def paired_with`), E-11 (L58-69) | ○ |

### CustomFieldDatePair クラス (UT-FLD-088 ~ UT-FLD-100)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 (UT-FLD-088~092) | render_valueメソッドがオーバーライド | E-06 (L12-26: `def render_value`), E-12 (L11-39) | ○ |
| C-43 (UT-FLD-093~094) | renderメソッドがオーバーライド | E-06 (L28-30: `def render`) | ○ |
| C-44 (UT-FLD-095~100) | custom_validatorメソッドがオーバーライド | E-06 (L32-43: `def custom_validator`), E-12 (L41-91) | ○ |

### CustomFieldDatetimePair クラス (UT-FLD-101 ~ UT-FLD-104)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 (UT-FLD-101~102) | renderメソッドがオーバーライド | E-07 (L9-11: `def render`) | ○ |
| C-46 (UT-FLD-103~104) | 親クラスの機能を継承 | E-07 (L8: `class CustomFieldDatetimePair < CustomFieldDatePair`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースに対してソースコード内に明確な根拠が存在する

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されている
- 注意点：
  - CustomFieldのdb_transition_safetyロジックは複雑であり、実装漏れがないか注意が必要
  - データベース操作（add_column, change_column）は本番環境での動作確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 全クラスのメソッドが網羅されているか確認
- [ ] バリデーションテストの入力値/期待結果が妥当か確認
- [ ] 境界値テストが適切に設定されているか確認
- [ ] 継承関係のテストケースが親クラスの機能を適切にカバーしているか確認
- [ ] DB操作関連テストのモック戦略が妥当か確認
- [ ] I18n依存のテスト（日付/日時フォーマット）のロケール設定を確認
