---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 124
  claims_with_evidence: 124
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：polymorphic.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：124 / 124、根拠なし：0
- 優先レビュー（高）
  1. **Task.set_due_date関連テスト**：bucketごとの期限設定ロジックの詳細確認推奨
  2. **Version.visible_toテスト**：アクセス制御の複雑なロジックの確認推奨
  3. **Comment通知関連テスト**：メール送信の実際の動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/polymorphic/address.rb` - Addressモデル定義
- E-02: `app/models/polymorphic/avatar.rb` - Avatarモデル定義
- E-03: `app/models/polymorphic/comment.rb` - Commentモデル定義
- E-04: `app/models/polymorphic/email.rb` - Emailモデル定義
- E-05: `app/models/polymorphic/tag.rb` - Tagモデル定義
- E-06: `app/models/polymorphic/tagging.rb` - Taggingモデル定義
- E-07: `app/models/polymorphic/task.rb` - Taskモデル定義
- E-08: `app/models/polymorphic/version.rb` - Versionモデル定義
- E-09: Schema Information（各ファイルのコメント内）- データベーススキーマ情報

## 3) Claims と根拠の対応（レビューの主戦場）

### Addressモデル (UT-PLM-001 〜 UT-PLM-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | addressableポリモーフィック関連テスト | E-01 L29 `belongs_to :addressable, polymorphic: true` | ○ |
| C-02 | business/billing/shipping scope定義 | E-01 L33-35 各scopeの定義 | ○ |
| C-03 | blank?メソッドの複合住所判定 | E-01 L39-45 Setting.compound_addressによる分岐 | ○ |
| C-04 | reject_addressクラスメソッド | E-01 L53-58 attributes処理と_destroy設定ロジック | ○ |

### Avatarモデル (UT-PLM-013 〜 UT-PLM-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | user/entity関連テスト | E-02 L24-25 belongs_to定義 | ○ |
| C-06 | ActiveStorage image添付 | E-02 L27 `has_one_attached :image` | ○ |

### Commentモデル (UT-PLM-017 〜 UT-PLM-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | user/commentable関連テスト | E-03 L25-26 belongs_to定義 | ○ |
| C-08 | created_by scope | E-03 L28 scopeの定義 | ○ |
| C-09 | validates_presence_of検証 | E-03 L30 `validates_presence_of :user, :commentable, :comment` | ○ |
| C-10 | expanded?/collapsed?メソッド | E-03 L37-43 state判定メソッド | ○ |
| C-11 | subscribe_user_to_entity処理 | E-03 L48-51 購読者追加ロジック | ○ |
| C-12 | notify_subscribers処理 | E-03 L54-58 メール通知ロジック | ○ |
| C-13 | subscribe_mentioned_users処理 | E-03 L63-70 @メンション解析 | ○ |

### Emailモデル (UT-PLM-032 〜 UT-PLM-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | mediator/user関連テスト | E-04 L33-34 belongs_to定義 | ○ |
| C-15 | expanded?/collapsed?メソッド | E-04 L39-45 state判定メソッド | ○ |
| C-16 | body_html/body_inlineメソッド | E-04 L47-53 文字列変換メソッド | ○ |

### Tagモデル (UT-PLM-042 〜 UT-PLM-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | no_associated_field_groups検証 | E-05 L12-13 before_destroyコールバック | ○ |
| C-18 | model_tagging_counts集計 | E-05 L17-19 グループ集計ロジック | ○ |

### Taggingモデル (UT-PLM-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | ActsAsTaggableOn::Tagging継承 | E-06 L8 クラス定義 | ○ |

### Taskモデル (UT-PLM-047 〜 UT-PLM-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | user/assignee/completor/asset関連 | E-07 L37-40 belongs_to定義 | ○ |
| C-21 | my/created_by/assigned_to等scope | E-07 L46-68 各scope定義 | ○ |
| C-22 | visible_on_dashboard scope | E-07 L72-74 ダッシュボード用scope | ○ |
| C-23 | pending/assigned/completed scope | E-07 L84-86 ステータスscope | ○ |
| C-24 | due_asap〜due_later各scope | E-07 L89-95 期限scope群 | ○ |
| C-25 | completed_today〜last_month scope | E-07 L98-103 完了日scope群 | ○ |
| C-26 | text_search scope | E-07 L105-108 検索scope | ○ |
| C-27 | validates_presence_of検証 | E-07 L116-119 バリデーション定義 | ○ |
| C-28 | my?/assigned_by?/completed?等 | E-07 L127-146 判定メソッド群 | ○ |
| C-29 | at_specific_time?メソッド | E-07 L151-153 時刻判定 | ○ |
| C-30 | computed_bucketメソッド | E-07 L157-173 バケット計算 | ○ |
| C-31 | find_all_grouped/bucket_empty?/totals | E-07 L177-212 クラスメソッド群 | ○ |
| C-32 | set_due_dateプライベートメソッド | E-07 L217-233 期限設定ロジック | ○ |
| C-33 | parse_calendar_dateメソッド | E-07 L286-288 日時パース | ○ |

### Versionモデル (UT-PLM-107 〜 UT-PLM-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | related/user関連テスト | E-08 L15-16 belongs_to定義 | ○ |
| C-35 | default_order/include_events等scope | E-08 L18-21 各scope定義 | ○ |
| C-36 | recent_for_userクラスメソッド | E-08 L24-44 履歴取得ロジック | ○ |
| C-37 | latestクラスメソッド | E-08 L46-54 フィルタリング取得 | ○ |
| C-38 | related_to/historyメソッド | E-08 L56-63 関連履歴取得 | ○ |
| C-39 | visible_toメソッド | E-08 L65-82 アクセス制御ロジック | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠不足の項目はありません。全てのテストケースがソースコードに基づいて生成されています。
- ただし、以下の点は実装確認が推奨されます：
  - Comment.notify_subscribers: SubscriptionMailerの実装詳細
  - Task.notify_assignee: 現状コメントアウトされている通知ロジック
  - Version.visible_to: User.current_userの設定方法

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なアソシエーション・スコープテスト（大部分）
- **1（中リスク）**:
  - Task.set_due_date: タイムゾーン依存のロジック
  - Address.reject_address: 副作用（_destroy設定）のあるロジック
- **2（高リスク）**:
  - Version.visible_to: 複雑なアクセス制御ロジック、セキュリティに関わる
  - Comment.notify_subscribers: メール送信の外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] Task関連の期限計算（set_due_date）が各bucketで正しく動作するか確認
- [ ] Version.visible_toのアクセス制御が正しく実装されているか確認
- [ ] Comment通知機能のユーザー除外ロジックが正しいか確認
- [ ] Address.blank?のSetting.compound_address依存が正しく動作するか確認
- [ ] Tag削除時のFieldGroup関連チェックが正しく機能するか確認
- [ ] Task.text_searchの特殊文字サニタイズが十分か確認
- [ ] 各ポリモーフィック関連（addressable, entity, commentable, mediator, asset, related）のテストが適切か確認
