---
generated_at: 2026-01-13 17:00:00
metrics:
  claims_total: 56
  claims_with_evidence: 54
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：root.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：54 / 56、根拠なし：2
- 優先レビュー（高）
  1. **UT-ROOT-041, UT-ROOT-042（unrollメソッド）**：I18n翻訳の動作確認が必要
  2. **UT-ROOT-052（ERBテンプレート）**：ERB処理の実際の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/list.rb` - Listモデル定義（行1-19）
- E-02: `app/models/research_tool.rb` - ResearchToolモデル定義（行1-4）
- E-03: `app/models/setting.rb` - Settingモデル定義（行1-121）
- E-04: Rails ActiveRecord::Base標準機能（validates, belongs_to, serialize等）
- E-05: Ruby標準ライブラリ（method_missing, respond_to?, dig等）

## 3) Claims と根拠の対応（レビューの主戦場）

### List モデル関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Listモデルにnameのpresenceバリデーションがある | E-01 行9: `validates_presence_of :name` | ○ |
| C-02 | Listモデルにurlのpresenceバリデーションがある | E-01 行10: `validates_presence_of :url` | ○ |
| C-03 | ListはUserにbelongs_to関連（optional）を持つ | E-01 行11: `belongs_to :user, optional: true` | ○ |
| C-04 | controllerメソッドがURLからコントローラー名を抽出 | E-01 行14-16: `def controller` | ○ |
| C-05 | controllerメソッドは先頭スラッシュを除去する | E-01 行15: `.sub(%r{\A/}, '')` | ○ |
| C-06 | controllerメソッドはスラッシュまたは?で分割する | E-01 行15: `.split(%r{/|\?})` | ○ |
| C-07 | urlがnilの場合、空文字列として処理される | E-01 行15: `(url || "")` | ○ |

### ResearchTool モデル関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | ResearchToolはActiveRecord::Baseを継承 | E-02 行3: `class ResearchTool < ActiveRecord::Base` | ○ |
| C-09 | ResearchToolにはカスタムメソッドがない | E-02 全体確認 | ○ |
| C-10 | 基本CRUD操作が利用可能 | E-04 ActiveRecord標準機能 | ○ |

### Setting モデル関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Settingモデルにnameのpresenceバリデーションがある | E-03 行29: `validates :name, presence: true, allow_blank: false` | ○ |
| C-12 | valueカラムはシリアライズされる | E-03 行30: `serialize :value` | ○ |
| C-13 | cacheとyaml_settingsはクラス変数アクセサ | E-03 行33-34: `cattr_accessor :cache, :yaml_settings` | ○ |
| C-14 | キャッシュはHashWithIndifferentAccessで初期化 | E-03 行34: `{}.with_indifferent_access` | ○ |
| C-15 | clear_cache!でキャッシュをクリアできる | E-03 行38-40: `def clear_cache!` | ○ |
| C-16 | []メソッドでキャッシュを優先参照 | E-03 行57-58: `return cache[name] if cache.key?(name)` | ○ |
| C-17 | []メソッドでDBをフォールバック参照 | E-03 行61-63: データベースチェックロジック | ○ |
| C-18 | []メソッドでYAML設定をフォールバック参照 | E-03 行65: `yaml_settings[name] if yaml_settings.key?(name)` | ○ |
| C-19 | []=メソッドで設定を保存できる | E-03 行70-79: `def []=(name, value)` | ○ |
| C-20 | []=で空のnameはArgumentErrorを発生 | E-03 行71: `raise ArgumentError, "name cannot be blank" if name.blank?` | ○ |
| C-21 | DB不在時に[]=はnilを返す | E-03 行73: `return nil unless database_and_table_exists?` | ○ |
| C-22 | method_missingで動的アクセスを提供 | E-03 行43-51: `def method_missing` | ○ |
| C-23 | setterは末尾の=で判定 | E-03 行47: `if method_name.last == "="` | ○ |
| C-24 | unrollメソッドでシンボル配列を展開 | E-03 行85-87: `def unroll(setting)` | ○ |
| C-25 | unrollでシンボルはI18n翻訳される | E-03 行86: `I18n.t(key)` | △ |
| C-26 | digメソッドでネストアクセス | E-03 行92-101: `def dig(key, *rest)` | ○ |
| C-27 | dig対象がdigメソッドを持たない場合TypeError | E-03 行99: `raise TypeError` | ○ |
| C-28 | database_and_table_exists?でテーブル存在確認 | E-03 行103-111: `def database_and_table_exists?` | ○ |
| C-29 | DB例外時はfalseを返す | E-03 行109-110: `rescue StandardError; false` | ○ |
| C-30 | load_settings_from_yamlでYAMLを読み込む | E-03 行114-117: `def load_settings_from_yaml` | ○ |
| C-31 | ERBテンプレートを処理する | E-03 行115: `ERB.new(File.read(file)).result` | △ |
| C-32 | 設定はdeep_mergeされる | E-03 行116: `@@yaml_settings.deep_merge!(settings)` | ○ |

## 4) 不足情報（Unknown / Missing）
- **I18n翻訳の動作確認**：unrollメソッドのI18n.t呼び出しは、実際のロケールファイルと連携した動作確認が必要
  - 候補：spec/models/setting_spec.rb / config/locales/*.yml
- **ERBテンプレート処理**：ERB評価の実際の動作はconfig/settings.default.ymlの内容に依存
  - 候補：config/settings.default.yml / config/settings.yml

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：List, ResearchToolモデル - 単純な構造で、コードから直接読み取れる機能のみ
- **0（低リスク）**：Settingモデルの基本機能（バリデーション、CRUD）
- **1（中リスク）**：Settingのキャッシュ機構 - 並行処理時の挙動確認が必要
- **1（中リスク）**：method_missingによる動的アクセス - 予期しないメソッド呼び出しの可能性

## 6) レビュアーチェックリスト（最小）
- [ ] List.controllerメソッドの正規表現が期待通りの動作をするか確認
- [ ] Setting.unrollのI18n翻訳が実際のロケールファイルと整合しているか確認
- [ ] Setting.load_settings_from_yamlのERB処理が安全か確認（インジェクションリスク）
- [ ] Settingのキャッシュ機構がマルチスレッド環境で安全か確認
- [ ] database_and_table_exists?の例外ハンドリングが適切か確認
