---
generated_at: 2026-01-13 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 94
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：94 / 100、根拠なし：6
- 優先レビュー（高）
  1. **UAT-092 レスポンシブUI**：CSSファイル未確認
  2. **UAT-093 インライン編集**：JSファイル詳細未確認
  3. **UAT-099 ローカライゼーション**：localeファイル一覧未確認
  4. **UAT-071/072 サブスクリプション機能**：メール通知実装の詳細未確認
  5. **UAT-096 XLSエクスポート**：xls出力の詳細実装未確認
  6. **UAT-087 商談概要**：opportunities_overviewビュー未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/routes.rb` - ルーティング定義
- E-02: `app/controllers/application_controller.rb` - ベースコントローラー
- E-03: `app/controllers/sessions_controller.rb` - 認証コントローラー
- E-04: `app/controllers/registrations_controller.rb` - ユーザー登録コントローラー
- E-05: `app/controllers/passwords_controller.rb` - パスワードリセットコントローラー
- E-06: `app/controllers/home_controller.rb` - ダッシュボードコントローラー
- E-07: `app/controllers/entities_controller.rb` - エンティティ基底コントローラー
- E-08: `app/controllers/entities/accounts_controller.rb` - アカウントコントローラー
- E-09: `app/controllers/entities/leads_controller.rb` - リードコントローラー
- E-10: `app/controllers/entities/contacts_controller.rb` - コンタクトコントローラー
- E-11: `app/controllers/entities/opportunities_controller.rb` - 商談コントローラー
- E-12: `app/controllers/entities/campaigns_controller.rb` - キャンペーンコントローラー
- E-13: `app/controllers/tasks_controller.rb` - タスクコントローラー
- E-14: `app/controllers/users_controller.rb` - ユーザーコントローラー
- E-15: `app/controllers/comments_controller.rb` - コメントコントローラー
- E-16: `app/controllers/admin/users_controller.rb` - 管理者ユーザーコントローラー
- E-17: `app/controllers/admin/groups_controller.rb` - 管理者グループコントローラー
- E-18: `app/controllers/admin/settings_controller.rb` - 管理者設定コントローラー
- E-19: `app/controllers/admin/tags_controller.rb` - 管理者タグコントローラー
- E-20: `app/controllers/admin/fields_controller.rb` - 管理者フィールドコントローラー
- E-21: `app/controllers/lists_controller.rb` - リストコントローラー
- E-22: `app/models/users/user.rb` - ユーザーモデル
- E-23: `app/models/users/ability.rb` - 権限モデル(CanCan)
- E-24: `app/models/entities/lead.rb` - リードモデル
- E-25: `app/models/entities/opportunity.rb` - 商談モデル
- E-26: `app/models/entities/account.rb` - アカウントモデル
- E-27: `app/models/entities/contact.rb` - コンタクトモデル
- E-28: `app/models/entities/campaign.rb` - キャンペーンモデル
- E-29: `app/models/polymorphic/task.rb` - タスクモデル
- E-30: `app/models/polymorphic/comment.rb` - コメントモデル
- E-31: `app/models/polymorphic/tag.rb` - タグモデル
- E-32: `app/models/users/permission.rb` - 権限モデル
- E-33: `app/models/users/group.rb` - グループモデル
- E-34: `app/models/setting.rb` - 設定モデル
- E-35: `app/models/fields/field.rb` - フィールドモデル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: 正常ログイン機能 | E-01, E-03, E-22 | ○ |
| C-02 | UAT-002: 無効認証情報でのログイン拒否 | E-03, E-22 | ○ |
| C-03 | UAT-003: 承認待ちユーザーのログイン制限 | E-22 (awaits_approval?, active_for_authentication?) | ○ |
| C-04 | UAT-004: 新規ユーザー登録機能 | E-04, E-22 (can_signup?) | ○ |
| C-05 | UAT-005: 重複ユーザー名での登録拒否 | E-22 (validates :username, uniqueness) | ○ |
| C-06 | UAT-006: パスワードリセット機能 | E-05, E-22 (Devise::Recoverable) | ○ |
| C-07 | UAT-007: ダッシュボード表示 | E-06 (index, get_activities, @my_tasks, @my_opportunities) | ○ |
| C-08 | UAT-008: アクティビティフィルタリング | E-06 (options, redraw, activity_asset/event/user/duration) | ○ |
| C-09 | UAT-009: アカウント一覧表示 | E-08 (index, get_accounts) | ○ |
| C-10 | UAT-010: 新規アカウント作成 | E-08 (new, create) | ○ |
| C-11 | UAT-011: アカウント詳細表示 | E-08 (show, timeline) | ○ |
| C-12 | UAT-012: アカウント編集 | E-08 (edit, update) | ○ |
| C-13 | UAT-013: アカウント削除 | E-08 (destroy, respond_to_destroy) | ○ |
| C-14 | UAT-014: アカウントカテゴリフィルタ | E-08 (filter, get_data_for_sidebar) | ○ |
| C-15 | UAT-015: アカウント検索 | E-07 (text_search scope) | ○ |
| C-16 | UAT-016: アカウントCSVエクスポート | E-08 (respond_to :csv) | ○ |
| C-17 | UAT-017: リード一覧表示 | E-09 (index, get_leads) | ○ |
| C-18 | UAT-018: 新規リード作成 | E-09 (new, create) | ○ |
| C-19 | UAT-019: キャンペーン関連リード作成 | E-09, E-24 (campaign_id) | ○ |
| C-20 | UAT-020: リード詳細表示 | E-09 (show, timeline) | ○ |
| C-21 | UAT-021: リード編集 | E-09 (edit, update) | ○ |
| C-22 | UAT-022: リード削除 | E-09 (destroy) | ○ |
| C-23 | UAT-023: リードステータスフィルタ | E-09 (filter, get_data_for_sidebar) | ○ |
| C-24 | UAT-024: リードのコンタクトへの変換 | E-09 (convert, promote), E-24 (promote, convert) | ○ |
| C-25 | UAT-025: リードの拒否 | E-09 (reject), E-24 (reject) | ○ |
| C-26 | UAT-026: リードのvCardエクスポート | E-09 (format.vcf) | ○ |
| C-27 | UAT-027: コンタクト一覧表示 | E-10 (index, get_contacts) | ○ |
| C-28 | UAT-028: 新規コンタクト作成 | E-10 (new, create) | ○ |
| C-29 | UAT-029: コンタクト詳細表示 | E-10 (show, timeline) | ○ |
| C-30 | UAT-030: コンタクト編集 | E-10 (edit, update) | ○ |
| C-31 | UAT-031: コンタクト削除 | E-10 (destroy) | ○ |
| C-32 | UAT-032: コンタクトのvCardエクスポート | E-10 (format.vcf) | ○ |
| C-33 | UAT-033: 商談一覧表示 | E-11 (index, get_opportunities) | ○ |
| C-34 | UAT-034: 新規商談作成 | E-11 (new, create) | ○ |
| C-35 | UAT-035: アカウント関連商談作成 | E-11, E-25 (account_opportunity) | ○ |
| C-36 | UAT-036: 商談詳細表示 | E-11 (show, timeline) | ○ |
| C-37 | UAT-037: 商談編集 | E-11 (edit, update) | ○ |
| C-38 | UAT-038: 商談削除 | E-11 (destroy) | ○ |
| C-39 | UAT-039: 商談ステージフィルタ | E-11 (filter, get_data_for_sidebar) | ○ |
| C-40 | UAT-040: 商談パイプライン表示 | E-25 (pipeline scope) | ○ |
| C-41 | UAT-041: 商談へのコンタクト追加 | E-07 (attach), E-25 (attach!) | ○ |
| C-42 | UAT-042: キャンペーン一覧表示 | E-12 (index, get_campaigns) | ○ |
| C-43 | UAT-043: 新規キャンペーン作成 | E-12 (new, create) | ○ |
| C-44 | UAT-044: キャンペーン詳細表示 | E-12 (show, timeline) | ○ |
| C-45 | UAT-045: キャンペーン編集 | E-12 (edit, update) | ○ |
| C-46 | UAT-046: キャンペーン削除 | E-12 (destroy) | ○ |
| C-47 | UAT-047: キャンペーンステータスフィルタ | E-12 (filter, get_data_for_sidebar) | ○ |
| C-48 | UAT-048: Pendingタスク一覧表示 | E-13 (index, find_all_grouped), E-29 (my scope, pending) | ○ |
| C-49 | UAT-049: Assignedタスク一覧表示 | E-13, E-29 (assigned_by scope) | ○ |
| C-50 | UAT-050: Completedタスク一覧表示 | E-13, E-29 (completed scope) | ○ |
| C-51 | UAT-051: 新規タスク作成 | E-13 (new, create), E-29 | ○ |
| C-52 | UAT-052: エンティティ関連タスク作成 | E-13, E-29 (asset_type, asset_id) | ○ |
| C-53 | UAT-053: タスク編集 | E-13 (edit, update) | ○ |
| C-54 | UAT-054: タスク削除 | E-13 (destroy) | ○ |
| C-55 | UAT-055: タスク完了 | E-13 (complete), E-29 (completed_at) | ○ |
| C-56 | UAT-056: タスク未完了戻し | E-13 (uncomplete) | ○ |
| C-57 | UAT-057: タスク他者割り当て | E-29 (assigned_to, assignee) | ○ |
| C-58 | UAT-058: プロフィール表示 | E-14 (show) | ○ |
| C-59 | UAT-059: プロフィール編集 | E-14 (edit, update) | ○ |
| C-60 | UAT-060: アバター画像アップロード | E-14 (avatar, upload_avatar) | ○ |
| C-61 | UAT-061: パスワード変更 | E-14 (password, change_password) | ○ |
| C-62 | UAT-062: Publicデータアクセス | E-23 (can :manage, entities, access: 'Public') | ○ |
| C-63 | UAT-063: Privateデータアクセス制限 | E-23, E-02 (respond_to_access_denied) | ○ |
| C-64 | UAT-064: Sharedデータアクセス | E-23 (permissions), E-32 | ○ |
| C-65 | UAT-065: コメント追加 | E-15, E-30 (acts_as_commentable) | ○ |
| C-66 | UAT-066: コメント編集 | E-15 (edit, update) | ○ |
| C-67 | UAT-067: コメント削除 | E-15 (destroy) | ○ |
| C-68 | UAT-068: タグ付け | E-31 (acts_as_taggable_on :tags) | ○ |
| C-69 | UAT-069: タグによる検索 | E-07 (parse_query_and_tags, tagged_with) | ○ |
| C-70 | UAT-070: 詳細検索 | E-07 (ransack_search) | ○ |
| C-71 | UAT-071: エンティティのサブスクライブ | E-07 (subscribe) | ○ |
| C-72 | UAT-072: サブスクライブ解除 | E-07 (unsubscribe) | ○ |
| C-73 | UAT-073: 管理者ユーザー一覧 | E-16 (index, get_users) | ○ |
| C-74 | UAT-074: 管理者新規ユーザー作成 | E-16 (new, create) | ○ |
| C-75 | UAT-075: 管理者ユーザー編集 | E-16 (edit, update) | ○ |
| C-76 | UAT-076: ユーザー停止 | E-16 (suspend) | ○ |
| C-77 | UAT-077: ユーザー再有効化 | E-16 (reactivate) | ○ |
| C-78 | UAT-078: ユーザー削除 | E-16 (destroy), E-22 (destroyable?) | ○ |
| C-79 | UAT-079: グループ一覧表示 | E-17 (resourcesルーティング) | ○ |
| C-80 | UAT-080: 新規グループ作成 | E-17 | ○ |
| C-81 | UAT-081: システム設定変更 | E-18 (index, update) | ○ |
| C-82 | UAT-082: タグ一覧表示 | E-19 | ○ |
| C-83 | UAT-083: タグ編集 | E-19 | ○ |
| C-84 | UAT-084: タグ削除 | E-19 | ○ |
| C-85 | UAT-085: カスタムフィールド一覧 | E-20 | ○ |
| C-86 | UAT-086: カスタムフィールド追加 | E-20, E-35 | ○ |
| C-87 | UAT-087: 商談概要表示 | E-14 (opportunities_overview) | △ |
| C-88 | UAT-088: 商談の受注(Won) | E-25 (stage validation) | ○ |
| C-89 | UAT-089: 商談の失注(Lost) | E-25 (stage validation) | ○ |
| C-90 | UAT-090: リスト機能 | E-21 | ○ |
| C-91 | UAT-091: バージョン履歴 | E-07 (versions), has_paper_trail | ○ |
| C-92 | UAT-092: レスポンシブUI | **根拠なし** | △ |
| C-93 | UAT-093: インライン編集 | **根拠なし** | △ |
| C-94 | UAT-094: ページネーション | E-07 (paginate) | ○ |
| C-95 | UAT-095: ソート機能 | E-07 (sortable), E-24, E-25 | ○ |
| C-96 | UAT-096: XLSエクスポート | E-08, E-11 (format.xls) | △ |
| C-97 | UAT-097: JSON形式データ取得 | E-02 (respond_to :json) | ○ |
| C-98 | UAT-098: XML形式データ取得 | E-02 (respond_to :xml) | ○ |
| C-99 | UAT-099: ローカライゼーション | E-02 (I18n.locale), E-06 | △ |
| C-100 | UAT-100: タイムゾーン反映 | E-06 (timezone, session[:timezone_offset]) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-092 レスポンシブUI**: CSSファイルやレスポンシブ対応の実装詳細を確認していない
  - 候補: app/assets/stylesheets/ / public/stylesheets/ / vendor/
- **UAT-093 インライン編集**: JavaScriptファイルの詳細を確認していない
  - 候補: app/assets/javascripts/ / public/javascripts/
- **UAT-096 XLSエクスポート**: XLS生成の具体的な実装詳細は確認していない
  - 候補: Gemfileの依存ライブラリ / app/views/layouts/header
- **UAT-099 ローカライゼーション**: localeファイルの一覧と対応言語を確認していない
  - 候補: config/locales/
- **UAT-071/072 サブスクリプション**: メール通知の実装詳細は未確認
  - 候補: app/mailers/ / config/initializers/
- **UAT-087 商談概要**: opportunities_overviewのビューテンプレート未確認
  - 候補: app/views/users/opportunities_overview

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UAT-016, UAT-026, UAT-032, UAT-060, UAT-066, UAT-067, UAT-082-084, UAT-090, UAT-091, UAT-096-098
- **1: 中リスク** - UAT-003, UAT-005, UAT-008, UAT-014, UAT-015, UAT-023, UAT-025, UAT-039-041, UAT-047, UAT-049-050, UAT-057, UAT-071-072, UAT-076-080, UAT-085-087, UAT-092-095, UAT-099-100
- **2: 高リスク** - UAT-001-002, UAT-004, UAT-006-007, UAT-009-013, UAT-017-022, UAT-024, UAT-027-031, UAT-033-038, UAT-042-046, UAT-048, UAT-051-056, UAT-058-065, UAT-073-075, UAT-081, UAT-088-089

## 6) レビュアーチェックリスト（最小）
- [ ] UAT-001-006: 認証・登録機能のテスト手順とDevise設定が一致しているか
- [ ] UAT-024: リード変換フローがpromote/convertメソッドの実装と整合しているか
- [ ] UAT-062-064: アクセス権限のテストケースがAbilityクラスの定義と一致しているか
- [ ] UAT-073-078: 管理者機能のテストケースが管理者権限チェックと整合しているか
- [ ] UAT-092: レスポンシブUIテストの期待結果がCSSの実装と一致しているか（要確認）
- [ ] UAT-093: インライン編集のAJAX動作がJSの実装と一致しているか（要確認）
- [ ] UAT-099: 対応言語の一覧がlocaleファイルと一致しているか（要確認）
- [ ] 全体: 優先度の分類（高/中/低）がビジネス要件の重要度と一致しているか
