---
generated_at: 2026-01-13 16:45:00
metrics:
  claims_total: 7
  claims_with_evidence: 7
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：7 / 7、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/accounts/index.xls.builder` - 取引先XLSエクスポートテンプレート
- E-02: `app/views/contacts/index.xls.builder` - 連絡先XLSエクスポートテンプレート
- E-03: `app/views/leads/index.xls.builder` - リードXLSエクスポートテンプレート
- E-04: `app/views/opportunities/index.xls.builder` - 商談XLSエクスポートテンプレート
- E-05: `app/views/campaigns/index.xls.builder` - キャンペーンXLSエクスポートテンプレート
- E-06: `app/views/tasks/index.xls.builder` - タスクXLSエクスポートテンプレート
- E-07: `app/views/home/index.xls.builder` - アクティビティXLSエクスポートテンプレート
- E-08: `app/views/layouts/header.xls.builder` - XLS共通レイアウトテンプレート
- E-09: `lib/fat_free_crm/export_csv.rb` - CSVエクスポート共通モジュール
- E-10: `app/controllers/entities/accounts_controller.rb` - 取引先コントローラー（XLS/CSVレスポンス定義）
- E-11: `app/controllers/entities/contacts_controller.rb` - 連絡先コントローラー（XLS/CSVレスポンス定義）
- E-12: `app/controllers/entities/leads_controller.rb` - リードコントローラー（XLS/CSVレスポンス定義）
- E-13: `app/controllers/entities/opportunities_controller.rb` - 商談コントローラー（XLS/CSVレスポンス定義）
- E-14: `app/controllers/entities/campaigns_controller.rb` - キャンペーンコントローラー（XLS/CSVレスポンス定義）
- E-15: `app/controllers/tasks_controller.rb` - タスクコントローラー（XLS/CSVレスポンス定義）
- E-16: `app/controllers/home_controller.rb` - ホームコントローラー（XLSレスポンス定義）
- E-17: `app/helpers/application_helper.rb` - links_to_exportヘルパーメソッド（エクスポートリンク生成）
- E-18: `app/views/shared/_export.html.haml` - エクスポートリンク表示用パーシャル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 取引先一覧帳票が存在し、XLS/CSV形式でエクスポート可能 | E-01, E-09, E-10, E-17 | ○ |
| C-02 | 連絡先一覧帳票が存在し、XLS/CSV形式でエクスポート可能 | E-02, E-09, E-11, E-17 | ○ |
| C-03 | リード一覧帳票が存在し、XLS/CSV形式でエクスポート可能 | E-03, E-09, E-12, E-17 | ○ |
| C-04 | 商談一覧帳票が存在し、XLS/CSV形式でエクスポート可能 | E-04, E-09, E-13, E-17 | ○ |
| C-05 | キャンペーン一覧帳票が存在し、XLS/CSV形式でエクスポート可能 | E-05, E-09, E-14, E-17 | ○ |
| C-06 | タスク一覧帳票が存在し、XLS/CSV形式でエクスポート可能 | E-06, E-09, E-15, E-17 | ○ |
| C-07 | アクティビティ一覧帳票が存在し、XLS形式でエクスポート可能 | E-07, E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての帳票はソースコード（XLSビルダーファイル、コントローラー、CSVエクスポートモジュール）から直接確認できた。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての帳票情報はソースコードから直接抽出されており、信頼性が高い。
- 注意点：カスタムフィールドの具体的な内容は実行時に動的に決定されるため、帳票の出力項目は設定により変動する可能性がある。

## 6) レビュアーチェックリスト（最小）
- [x] 全ての帳票（XLS/CSVエクスポート機能）が網羅されているか確認
- [ ] 各帳票の出力項目がXLSビルダーファイルの定義と一致しているか確認
- [ ] CSVエクスポート機能（lib/fat_free_crm/export_csv.rb）の動作を確認
- [ ] エクスポートリンク（app/helpers/application_helper.rb#links_to_export）が正しく動作するか確認
- [ ] カスタムフィールドのエクスポート対応を確認（各モデルの.fieldsメソッド）
