---
generated_at: 2026-01-13 17:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-取引先一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：根拠不足
  2. **同時出力数上限**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/accounts/index.xls.builder`（1-87行目）
- E-02: `app/models/entities/account.rb`（1-153行目）
- E-03: `app/controllers/entities_controller.rb`（138-178行目）
- E-04: `app/controllers/application_controller.rb`（27行目）
- E-05: `lib/fat_free_crm/export_csv.rb`（15-34行目）
- E-06: `app/views/layouts/header.xls.builder`（1-11行目）
- E-07: `config/routes.rb`（44-62行目）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（2行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 取引先データをXLS/CSV形式でエクスポートする | E-01, E-04, E-05 | ○ |
| C-02 | 出力項目にID、ユーザー、担当者、名前等22項目を含む | E-01（8-29行目） | ○ |
| C-03 | カスタムフィールドを動的に追加出力 | E-01（32-34行目、72-74行目） | ○ |
| C-04 | 住所情報はbilling_addressから取得 | E-01（47行目）, E-02（39行目） | ○ |
| C-05 | シート名はI18n.t(:tab_accounts)で国際化対応 | E-01（3行目） | ○ |
| C-06 | ファイル形式はXML Spreadsheet形式 | E-06（4-8行目） | ○ |
| C-07 | URLは/accounts.xlsまたは/accounts.csv | E-07（44行目）, E-04（27行目） | ○ |
| C-08 | AccountモデルはUser、Addressとの関連を持つ | E-02（31-41行目） | ○ |
| C-09 | uses_user_permissionsによるアクセス制御 | E-02（64行目） | ○ |
| C-10 | acts_as_taggable_onによるタグ機能 | E-02（67行目） | ○ |
| C-11 | has_fieldsによるカスタムフィールド対応 | E-02（69行目） | ○ |
| C-12 | exportableによるエクスポート機能有効化 | E-02（70行目） | ○ |
| C-13 | sortableでデフォルトソートはcreated_at DESC | E-02（71行目） | ○ |
| C-14 | ratingは0-5の整数値 | E-02（78行目） | ○ |
| C-15 | XLS/CSV出力時はページネーション無効化 | E-03（166行目） | ○ |
| C-16 | get_list_of_recordsでRansack検索実行 | E-03（146行目） | ○ |
| C-17 | CSVエクスポートでpassword/tokenカラムを除外 | E-05（20行目） | ○ |
| C-18 | CSVエクスポートでタグを含む | E-05（21行目、26-28行目） | ○ |
| C-19 | respond_to :xls, :csv宣言 | E-04（27行目） | ○ |
| C-20 | 認証が必要（authenticate_user!） | E-04（12行目） | ○ |
| C-21 | データ型判定はrespond_to?(:abs)で実施 | E-01（79行目） | ○ |
| C-22 | ユーザー名はtry(:name)で安全に取得 | E-01（49-50行目） | ○ |
| C-23 | 住所フィールドもtry()で安全に取得 | E-01（63-69行目） | ○ |
| C-24 | @accounts.empty?時はヘッダー・データ行を出力しない | E-01（5行目） | ○ |
| C-25 | per_pageのデフォルト値は20 | E-02（88-90行目） | ○ |
| C-26 | Accountの必須バリデーションはname | E-02（76行目） | ○ |
| C-27 | 目標出力時間は5秒以内（1000件程度） | **根拠なし** | △ |
| C-28 | 同時出力数上限は明示的な制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の目標出力時間について、ソースコードに明示的な記載なし
  - 候補：パフォーマンステスト結果 / 要件定義書 / 運用マニュアル
- 同時出力数上限について、コードレベルでの制限設定を確認できず
  - 候補：Webサーバー設定（Puma/Unicorn） / アプリケーション設定 / インフラ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張がソースコードから直接検証可能
- 1: 中リスク - パフォーマンス要件は実測値に基づく調整が必要な可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] XLS出力の22項目が実際のビジネス要件と合致しているか確認
- [ ] カスタムフィールド出力が正しく動作することをテスト環境で確認
- [ ] 大量データ（1000件以上）でのエクスポート性能を実測確認
- [ ] CSV出力時のpassword/token除外が意図通り動作するか確認
- [ ] 多言語環境でのヘッダーラベル表示を確認
