---
generated_at: 2026-01-13 17:48:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：2-連絡先一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：根拠不足
  2. **同時出力数上限**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/contacts/index.xls.builder`（1-105行目）
- E-02: `app/models/entities/contact.rb`（1-229行目）
- E-03: `app/controllers/entities_controller.rb`（138-178行目）
- E-04: `app/controllers/application_controller.rb`（27行目）
- E-05: `lib/fat_free_crm/export_csv.rb`（15-34行目）
- E-06: `app/views/layouts/header.xls.builder`（1-11行目）
- E-07: `config/routes.rb`（84-101行目）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（3行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 連絡先データをXLS/CSV形式でエクスポートする | E-01, E-04, E-05 | ○ |
| C-02 | 出力項目にID、リード、役職、氏名等31項目を含む | E-01（8-38行目） | ○ |
| C-03 | カスタムフィールドを動的に追加出力 | E-01（40-43行目、90-92行目） | ○ |
| C-04 | 住所情報はbusiness_addressから取得 | E-01（56行目）, E-02（50行目） | ○ |
| C-05 | シート名はI18n.t(:tab_contacts)で国際化対応 | E-01（3行目） | ○ |
| C-06 | URLは/contacts.xlsまたは/contacts.csv | E-07（84行目）, E-04（27行目） | ○ |
| C-07 | Contactモデルはlead、account、business_addressとの関連を持つ | E-02（42-51行目） | ○ |
| C-08 | uses_user_permissionsによるアクセス制御 | E-02（86行目） | ○ |
| C-09 | full_nameメソッドで名前を結合 | E-02（125-132行目） | ○ |
| C-10 | first_name_positionで名前表示順序を制御 | E-02（120-123行目） | ○ |
| C-11 | has_fieldsによるカスタムフィールド対応 | E-02（92行目） | ○ |
| C-12 | exportableによるエクスポート機能有効化 | E-02（93行目） | ○ |
| C-13 | sortableでデフォルトソートはcreated_at DESC | E-02（94行目） | ○ |
| C-14 | first_nameは最大64文字 | E-02（100行目） | ○ |
| C-15 | last_nameは最大64文字 | E-02（101行目） | ○ |
| C-16 | emailは最大254文字 | E-02（104行目） | ○ |
| C-17 | SNS項目（blog, linkedin, facebook, twitter）は最大128文字 | E-02（109-112行目） | ○ |
| C-18 | do_not_callはブール値 | E-02（33行目） | ○ |
| C-19 | born_onは日付型 | E-02（32行目） | ○ |
| C-20 | XLS/CSV出力時はページネーション無効化 | E-03（166行目） | ○ |
| C-21 | get_list_of_recordsでRansack検索実行 | E-03（146行目） | ○ |
| C-22 | respond_to :xls, :csv宣言 | E-04（27行目） | ○ |
| C-23 | 認証が必要（authenticate_user!） | E-04（12行目） | ○ |
| C-24 | データ型判定はrespond_to?(:abs)で実施 | E-01（97行目） | ○ |
| C-25 | lead.try(:name)で元リード名を取得 | E-01（58行目） | ○ |
| C-26 | assignee.try(:name)で担当者名を取得 | E-01（76行目） | ○ |
| C-27 | @contacts.empty?時はヘッダー・データ行を出力しない | E-01（5行目） | ○ |
| C-28 | per_pageのデフォルト値は20 | E-02（116-118行目） | ○ |
| C-29 | 目標出力時間は5秒以内（1000件程度） | **根拠なし** | △ |
| C-30 | 同時出力数上限は明示的な制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の目標出力時間について、ソースコードに明示的な記載なし
  - 候補：パフォーマンステスト結果 / 要件定義書 / 運用マニュアル
- 同時出力数上限について、コードレベルでの制限設定を確認できず
  - 候補：Webサーバー設定 / アプリケーション設定 / インフラ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張がソースコードから直接検証可能
- 1: 中リスク - do_not_callフラグの取り扱いについて、GDPR等のコンプライアンス観点での確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] XLS出力の31項目が実際のビジネス要件と合致しているか確認
- [ ] do_not_callフラグがエクスポートデータに含まれることの適切性を確認
- [ ] SNS項目（LinkedIn, Facebook, Twitter）のURLフォーマットを確認
- [ ] 大量データ（1000件以上）でのエクスポート性能を実測確認
- [ ] リードから変換された連絡先のlead_id出力が正しいか確認
