---
generated_at: 2026-01-13 17:52:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：3-リード一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：根拠不足
  2. **同時出力数上限**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/leads/index.xls.builder`（1-103行目）
- E-02: `app/models/entities/lead.rb`（1-187行目）
- E-03: `app/controllers/entities_controller.rb`（138-178行目）
- E-04: `app/controllers/application_controller.rb`（27行目）
- E-05: `lib/fat_free_crm/export_csv.rb`（15-34行目）
- E-06: `app/views/layouts/header.xls.builder`（1-11行目）
- E-07: `config/routes.rb`（103-123行目）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（4行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リードデータをXLS/CSV形式でエクスポートする | E-01, E-04, E-05 | ○ |
| C-02 | 出力項目にID、ユーザー、キャンペーン、氏名等30項目を含む | E-01（8-37行目） | ○ |
| C-03 | カスタムフィールドを動的に追加出力 | E-01（40-42行目、88-90行目） | ○ |
| C-04 | 住所情報はbusiness_addressから取得 | E-01（55行目）, E-02（46行目） | ○ |
| C-05 | シート名はI18n.t(:tab_leads)で国際化対応 | E-01（3行目） | ○ |
| C-06 | URLは/leads.xlsまたは/leads.csv | E-07（103行目）, E-04（27行目） | ○ |
| C-07 | Leadモデルはuser、campaign、assigneeとの関連を持つ | E-02（41-43行目） | ○ |
| C-08 | uses_user_permissionsによるアクセス制御 | E-02（64行目） | ○ |
| C-09 | has_one :contactでリードから連絡先への変換関連 | E-02（44行目） | ○ |
| C-10 | promoteメソッドで連絡先への変換処理 | E-02（124-133行目） | ○ |
| C-11 | has_fieldsによるカスタムフィールド対応 | E-02（69行目） | ○ |
| C-12 | exportableによるエクスポート機能有効化 | E-02（70行目） | ○ |
| C-13 | sortableでデフォルトソートはcreated_at DESC | E-02（71行目） | ○ |
| C-14 | ratingはデフォルト0、0-5の整数値 | E-02（32行目） | ○ |
| C-15 | statusはSetting.unroll(:lead_status)で検証 | E-02（79行目） | ○ |
| C-16 | convertedステータスへの変換はconvertメソッド | E-02（136-138行目） | ○ |
| C-17 | after_createでincrement_leads_count実行 | E-02（81行目、170-172行目） | ○ |
| C-18 | after_destroyでdecrement_leads_count実行 | E-02（82行目、174-177行目） | ○ |
| C-19 | stateスコープでステータスフィルタ | E-02（54-56行目） | ○ |
| C-20 | full_nameメソッドで名前を結合 | E-02（158-165行目） | ○ |
| C-21 | XLS/CSV出力時はページネーション無効化 | E-03（166行目） | ○ |
| C-22 | get_list_of_recordsでRansack検索実行 | E-03（146行目） | ○ |
| C-23 | respond_to :xls, :csv宣言 | E-04（27行目） | ○ |
| C-24 | 認証が必要（authenticate_user!） | E-04（12行目） | ○ |
| C-25 | データ型判定はrespond_to?(:abs)で実施 | E-01（95行目） | ○ |
| C-26 | user.try(:name)で作成ユーザー名を取得 | E-01（57行目） | ○ |
| C-27 | campaign.try(:name)でキャンペーン名を取得 | E-01（58行目） | ○ |
| C-28 | assignee.try(:name)で担当者名を取得 | E-01（73行目） | ○ |
| C-29 | @leads.empty?時はヘッダー・データ行を出力しない | E-01（5行目） | ○ |
| C-30 | per_pageのデフォルト値は20 | E-02（86-88行目） | ○ |
| C-31 | 目標出力時間は5秒以内（1000件程度） | **根拠なし** | △ |
| C-32 | 同時出力数上限は明示的な制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の目標出力時間について、ソースコードに明示的な記載なし
  - 候補：パフォーマンステスト結果 / 要件定義書 / 運用マニュアル
- 同時出力数上限について、コードレベルでの制限設定を確認できず
  - 候補：Webサーバー設定 / アプリケーション設定 / インフラ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張がソースコードから直接検証可能
- 1: 中リスク - キャンペーンとの紐付け情報がマーケティング分析に重要なため、正確性の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] XLS出力の30項目が実際のビジネス要件と合致しているか確認
- [ ] キャンペーン紐付け情報が正しく出力されることをテスト環境で確認
- [ ] ステータスフィルタ（converted/rejected等）が正しく適用されるか確認
- [ ] 大量データ（1000件以上）でのエクスポート性能を実測確認
- [ ] リードから連絡先への変換後、lead_id参照が正しいか確認
