---
generated_at: 2026-01-13 18:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：5-キャンペーン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：根拠不足
  2. **同時出力数上限**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/campaigns/index.xls.builder`（1-80行目）
- E-02: `app/models/entities/campaign.rb`（1-117行目）
- E-03: `app/models/entities/lead.rb`（81-82行目、170-177行目）
- E-04: `app/models/entities/opportunity.rb`（89行目、178-180行目）
- E-05: `app/controllers/entities_controller.rb`（138-178行目）
- E-06: `app/controllers/application_controller.rb`（27行目）
- E-07: `lib/fat_free_crm/export_csv.rb`（15-34行目）
- E-08: `app/views/layouts/header.xls.builder`（1-11行目）
- E-09: `config/routes.rb`（64-82行目）
- E-10: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（6行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャンペーンデータをXLS/CSV形式でエクスポートする | E-01, E-06, E-07 | ○ |
| C-02 | 出力項目にID、名前、予算、目標、実績等19項目を含む | E-01（8-26行目） | ○ |
| C-03 | カスタムフィールドを動的に追加出力 | E-01（28-31行目、65-67行目） | ○ |
| C-04 | シート名はI18n.t(:tab_campaigns)で国際化対応 | E-01（3行目） | ○ |
| C-05 | URLは/campaigns.xlsまたは/campaigns.csv | E-09（64行目）, E-06（27行目） | ○ |
| C-06 | Campaignモデルはuser、assigneeとの関連を持つ | E-02（35-36行目） | ○ |
| C-07 | has_many :leadsでリードとの関連を持つ | E-02（38行目） | ○ |
| C-08 | has_many :opportunitiesで商談との関連を持つ | E-02（39行目） | ○ |
| C-09 | uses_user_permissionsによるアクセス制御 | E-02（52行目） | ○ |
| C-10 | has_fieldsによるカスタムフィールド対応 | E-02（57行目） | ○ |
| C-11 | exportableによるエクスポート機能有効化 | E-02（58行目） | ○ |
| C-12 | sortableでデフォルトソートはcreated_at DESC | E-02（59行目） | ○ |
| C-13 | budgetはdecimal(12,2)型 | E-02（18行目、スキーマコメント） | ○ |
| C-14 | target_conversionはfloat型 | E-02（20行目、スキーマコメント） | ○ |
| C-15 | statusはSetting.unroll(:campaign_status)で検証 | E-02（68行目） | ○ |
| C-16 | start_and_end_datesでends_on > starts_onを検証 | E-02（66行目、105-107行目） | ○ |
| C-17 | Leadのafter_createでleads_countを増加 | E-03（81行目、170-172行目） | ○ |
| C-18 | Leadのafter_destroyでleads_countを減少 | E-03（82行目、174-177行目） | ○ |
| C-19 | Opportunityのafter_createでopportunities_countを増加 | E-04（89行目、178-180行目） | ○ |
| C-20 | Opportunityのafter_destroyでopportunities_countを減少 | E-04（90行目、182-185行目） | ○ |
| C-21 | stateスコープでステータスフィルタ | E-02（44-46行目） | ○ |
| C-22 | XLS/CSV出力時はページネーション無効化 | E-05（166行目） | ○ |
| C-23 | get_list_of_recordsでRansack検索実行 | E-05（146行目） | ○ |
| C-24 | respond_to :xls, :csv宣言 | E-06（27行目） | ○ |
| C-25 | 認証が必要（authenticate_user!） | E-06（12行目） | ○ |
| C-26 | データ型判定はrespond_to?(:abs)で実施 | E-01（71行目） | ○ |
| C-27 | user.try(:name)、assignee.try(:name)で名前を取得 | E-01（45-46行目） | ○ |
| C-28 | @campaigns.empty?時はヘッダー・データ行を出力しない | E-01（5行目） | ○ |
| C-29 | 目標出力時間は3秒以内（100件程度） | **根拠なし** | △ |
| C-30 | 同時出力数上限は明示的な制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の目標出力時間について、ソースコードに明示的な記載なし
  - 候補：パフォーマンステスト結果 / 要件定義書 / 運用マニュアル
- 同時出力数上限について、コードレベルでの制限設定を確認できず
  - 候補：Webサーバー設定 / アプリケーション設定 / インフラ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張がソースコードから直接検証可能
- 1: 中リスク - leads_count/opportunities_countの整合性が重要（カウンターキャッシュの不整合可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] XLS出力の19項目が実際のビジネス要件と合致しているか確認
- [ ] leads_countとopportunities_countが実際のリード・商談数と一致するか確認
- [ ] ステータス別フィルタが正しく適用されるか確認
- [ ] 開始日・終了日のバリデーションが正しく機能するか確認
- [ ] 予算・売上情報を含むためファイルの取り扱いポリシーを確認
