---
generated_at: 2026-01-13 18:04:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：6-タスク一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：根拠不足
  2. **同時出力数上限**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/tasks/index.xls.builder`（1-52行目）
- E-02: `app/models/polymorphic/task.rb`（1-293行目）
- E-03: `app/controllers/tasks_controller.rb`（1-229行目）
- E-04: `app/controllers/application_controller.rb`（27行目）
- E-05: `lib/fat_free_crm/export_csv.rb`（15-34行目）
- E-06: `app/views/layouts/header.xls.builder`（1-11行目）
- E-07: `config/routes.rb`（144-153行目）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（7行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タスクデータをXLS/CSV形式でエクスポートする | E-01, E-03（19-20行目） | ○ |
| C-02 | 出力項目にID、名前、期限、カテゴリ等10項目を含む | E-01（8-17行目） | ○ |
| C-03 | シート名はI18n.t(:tab_tasks)で国際化対応 | E-01（3行目） | ○ |
| C-04 | URLは/tasks.xlsまたは/tasks.csv | E-07（144行目）, E-04（27行目） | ○ |
| C-05 | ALLOWED_VIEWSはpending/assigned/completedの3種類 | E-02（35行目） | ○ |
| C-06 | Taskモデルはuser、assigneeとの関連を持つ | E-02（37-38行目） | ○ |
| C-07 | belongs_to :asset（ポリモーフィック関連） | E-02（40行目） | ○ |
| C-08 | myスコープで自分のタスクを取得 | E-02（46-53行目） | ○ |
| C-09 | assigned_byスコープで自分が割り当てたタスクを取得 | E-02（59-62行目） | ○ |
| C-10 | tracked_byスコープで関連タスクを取得 | E-02（66-69行目） | ○ |
| C-11 | バケットスコープ（due_asap/overdue/due_today等） | E-02（89-95行目） | ○ |
| C-12 | find_all_groupedメソッドでバケット別グループ化 | E-02（177-186行目） | ○ |
| C-13 | computed_bucketメソッドで期限バケットを算出 | E-02（157-173行目） | ○ |
| C-14 | TasksController#indexでTask.find_all_grouped呼び出し | E-03（16行目） | ○ |
| C-15 | XLS出力時はheaderレイアウトを使用 | E-03（19行目） | ○ |
| C-16 | CSV出力時は@tasks.map(&:second).flattenでフラット化 | E-03（20行目） | ○ |
| C-17 | I18n.t(task.computed_bucket)で期限を国際化表示 | E-01（32行目） | ○ |
| C-18 | @tasks.map(&:second).flattenでデータフラット化 | E-01（28行目） | ○ |
| C-19 | user.try(:name)で作成ユーザー名を取得 | E-01（36行目） | ○ |
| C-20 | assignee.try(:name)で担当者名を取得 | E-01（37行目） | ○ |
| C-21 | タスクはカスタムフィールドに非対応 | E-01（カスタムフィールド処理なし） | ○ |
| C-22 | @tasks.empty?時はヘッダー・データ行を出力しない | E-01（5行目） | ○ |
| C-23 | 認証が必要（authenticate_user!） | E-04（12行目） | ○ |
| C-24 | respond_to :xls, :csv宣言 | E-04（27行目） | ○ |
| C-25 | データ型判定はrespond_to?(:abs)で実施 | E-01（44行目） | ○ |
| C-26 | タスクはアクセス制御（access列）を持たない | E-02（スキーマコメント、アクセス制御なし） | ○ |
| C-27 | 目標出力時間は2秒以内（100件程度） | **根拠なし** | △ |
| C-28 | 同時出力数上限は明示的な制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の目標出力時間について、ソースコードに明示的な記載なし
  - 候補：パフォーマンステスト結果 / 要件定義書 / 運用マニュアル
- 同時出力数上限について、コードレベルでの制限設定を確認できず
  - 候補：Webサーバー設定 / アプリケーション設定 / インフラ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張がソースコードから直接検証可能
- 0: 低リスク - タスクはアクセス制御を持たないが、myスコープにより自分関連のみ参照可能

## 6) レビュアーチェックリスト（最小）
- [ ] XLS出力の10項目が実際のビジネス要件と合致しているか確認
- [ ] computed_bucketの算出ロジックがタイムゾーンを正しく考慮しているか確認
- [ ] 3種類のビュー（pending/assigned/completed）で正しくデータがフィルタされるか確認
- [ ] @tasks.map(&:second).flattenによるフラット化が正しく動作するか確認
- [ ] カスタムフィールド非対応が業務要件として適切か確認
