---
generated_at: 2026-01-13 18:08:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：7-アクティビティ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：根拠不足
  2. **同時出力数上限**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/home/index.xls.builder`（1-53行目）
- E-02: `app/models/polymorphic/version.rb`（1-85行目）
- E-03: `app/controllers/home_controller.rb`（1-170行目）
- E-04: `app/controllers/application_controller.rb`（12行目）
- E-05: `app/views/layouts/header.xls.builder`（1-11行目）
- E-06: `config/routes.rb`（11行目）
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（8行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクティビティデータをXLS形式でエクスポートする | E-01, E-03（19行目） | ○ |
| C-02 | 出力項目にID、アイテムタイプ、イベント等11項目を含む | E-01（8-18行目） | ○ |
| C-03 | シート名はI18n.t(:tab_dashboard)で国際化対応 | E-01（3行目） | ○ |
| C-04 | URLはルート（/）でアクセス | E-06（11行目） | ○ |
| C-05 | VersionモデルはPaperTrail::Versionを継承 | E-02（10行目） | ○ |
| C-06 | ASSETS定数でフィルタ対象エンティティを定義 | E-02（11行目） | ○ |
| C-07 | EVENTS定数でフィルタ対象イベントを定義 | E-02（12行目） | ○ |
| C-08 | DURATION定数で期間オプションを定義 | E-02（13行目） | ○ |
| C-09 | latestクラスメソッドでフィルタリング実行 | E-02（46-54行目） | ○ |
| C-10 | visible_toメソッドでアクセス権フィルタリング | E-02（65-82行目） | ○ |
| C-11 | HomeController#indexでget_activities呼び出し | E-03（14行目） | ○ |
| C-12 | get_activitiesでVersion.latest呼び出し | E-03（108行目） | ○ |
| C-13 | 最大取得件数は500件 | E-03（106行目） | ○ |
| C-14 | デフォルト期間は2日間 | E-02（51行目：options[:duration] \|\| 2.days） | ○ |
| C-15 | activity_assetでアセットフィルタを設定 | E-03（112-119行目） | ○ |
| C-16 | activity_eventでイベントフィルタを設定 | E-03（122-129行目） | ○ |
| C-17 | activity_userでユーザーフィルタを設定 | E-03（135-148行目） | ○ |
| C-18 | activity_durationで期間フィルタを設定 | E-03（161-167行目） | ○ |
| C-19 | XLS出力時はheaderレイアウトを使用 | E-03（19行目） | ○ |
| C-20 | ヘッダーラベルは固定英語 | E-01（8-18行目） | ○ |
| C-21 | @activities.empty?時はヘッダー・データ行を出力しない | E-01（5行目） | ○ |
| C-22 | 認証が必要（authenticate_user!） | E-04（12行目） | ○ |
| C-23 | データ型判定はrespond_to?(:abs)で実施 | E-01（45行目） | ○ |
| C-24 | event種別はcreate/update/destroy/view | E-02（12行目）、E-03（125-126行目） | ○ |
| C-25 | item_type、item_id、eventを出力 | E-01（31-34行目） | ○ |
| C-26 | object、object_changesを出力 | E-01（36-37行目） | ○ |
| C-27 | related_id、related_typeを出力 | E-01（38-39行目） | ○ |
| C-28 | CSV出力は未対応（XLSのみ） | E-03（18-20行目：format.xlsのみ定義） | ○ |
| C-29 | 目標出力時間は3秒以内 | **根拠なし** | △ |
| C-30 | 同時出力数上限は明示的な制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の目標出力時間について、ソースコードに明示的な記載なし
  - 候補：パフォーマンステスト結果 / 要件定義書 / 運用マニュアル
- 同時出力数上限について、コードレベルでの制限設定を確認できず
  - 候補：Webサーバー設定 / アプリケーション設定 / インフラ設計書

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - objectフィールドに機密情報が含まれる可能性があるため、取り扱いポリシーの確認が必要
- 1: 中リスク - object_changesにパスワード変更履歴等が含まれる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] XLS出力の11項目が監査要件と合致しているか確認
- [ ] objectおよびobject_changesに機密情報が含まれないか確認
- [ ] visible_toによるアクセス制御が適切に機能するか確認
- [ ] 500件の上限が監査要件を満たすか確認
- [ ] whodunnitからユーザー名への変換が必要か確認（現状はIDのみ）
- [ ] CSV出力非対応が業務要件として適切か確認
