---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 58
  claims_with_evidence: 55
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：55 / 58、根拠なし：3
- 優先レビュー（高）
  1. **BR-049（メールドロップボックス）**：設定項目のみ確認、実装コードは未確認
  2. **BR-050（コメント返信メール）**：設定項目のみ確認、実装コードは未確認
  3. **BR-058（ユーザー別言語設定）**：設定のみで実装詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/entities/lead.rb`
- E-02: `app/models/entities/contact.rb`
- E-03: `app/models/entities/account.rb`
- E-04: `app/models/entities/opportunity.rb`
- E-05: `app/models/entities/campaign.rb`
- E-06: `app/models/polymorphic/task.rb`
- E-07: `app/models/users/user.rb`
- E-08: `app/models/users/ability.rb`
- E-09: `app/models/users/permission.rb`
- E-10: `app/models/polymorphic/comment.rb`
- E-11: `app/models/setting.rb`
- E-12: `app/controllers/entities/leads_controller.rb`
- E-13: `app/controllers/entities/contacts_controller.rb`
- E-14: `app/controllers/entities/accounts_controller.rb`
- E-15: `app/controllers/entities/opportunities_controller.rb`
- E-16: `app/controllers/entities/campaigns_controller.rb`
- E-17: `app/controllers/tasks_controller.rb`
- E-18: `app/controllers/admin/users_controller.rb`
- E-19: `app/controllers/entities_controller.rb`
- E-20: `app/controllers/home_controller.rb`
- E-21: `app/controllers/comments_controller.rb`
- E-22: `config/settings.default.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 リードの登録 | E-01, E-12 | ○ |
| C-02 | BR-002 リードのステータス管理 | E-01, E-22 | ○ |
| C-03 | BR-003 リードのコンバージョン | E-01, E-12 | ○ |
| C-04 | BR-004 リードの却下 | E-01, E-12 | ○ |
| C-05 | BR-005 リードとキャンペーンの紐付け | E-01, E-05 | ○ |
| C-06 | BR-006 連絡先の登録 | E-02, E-13 | ○ |
| C-07 | BR-007 連絡先とアカウントの紐付け | E-02, E-03 | ○ |
| C-08 | BR-008 連絡先と商談の紐付け | E-02, E-04 | ○ |
| C-09 | BR-009 アカウントの登録 | E-03, E-14 | ○ |
| C-10 | BR-010 アカウントカテゴリの管理 | E-03, E-22 | ○ |
| C-11 | BR-011 アカウントの評価 | E-03 | ○ |
| C-12 | BR-012 商談の登録 | E-04, E-15 | ○ |
| C-13 | BR-013 商談ステージの管理 | E-04, E-22 | ○ |
| C-14 | BR-014 商談の加重金額計算 | E-04 | ○ |
| C-15 | BR-015 商談パイプライン表示 | E-04 | ○ |
| C-16 | BR-016 キャンペーンの登録 | E-05, E-16 | ○ |
| C-17 | BR-017 キャンペーンステータスの管理 | E-05, E-22 | ○ |
| C-18 | BR-018 キャンペーン成果の追跡 | E-05, E-01, E-04 | ○ |
| C-19 | BR-019 キャンペーン期間の検証 | E-05 | ○ |
| C-20 | BR-020 タスクの登録 | E-06, E-17 | ○ |
| C-21 | BR-021 タスクの期日管理 | E-06, E-22 | ○ |
| C-22 | BR-022 タスクの完了管理 | E-06, E-17 | ○ |
| C-23 | BR-023 タスクの担当者割り当て | E-06 | ○ |
| C-24 | BR-024 期限切れタスクの識別 | E-06 | ○ |
| C-25 | BR-025 ユーザーの登録 | E-07, E-18 | ○ |
| C-26 | BR-026 ユーザーの停止・再有効化 | E-07, E-18 | ○ |
| C-27 | BR-027 ユーザーサインアップ制御 | E-07, E-22 | ○ |
| C-28 | BR-028 ユーザー削除の制約 | E-07, E-18 | ○ |
| C-29 | BR-029 レコードのアクセス権限管理 | E-08, E-22 | ○ |
| C-30 | BR-030 共有アクセスの検証 | E-01, E-02, E-03, E-04, E-05 | ○ |
| C-31 | BR-031 グループによる権限管理 | E-08, E-09 | ○ |
| C-32 | BR-032 管理者権限 | E-08 | ○ |
| C-33 | BR-033 コメントの追加 | E-10, E-21 | ○ |
| C-34 | BR-034 コメント通知 | E-10 | ○ |
| C-35 | BR-035 メンション機能 | E-10 | ○ |
| C-36 | BR-036 タグの付与 | E-01, E-02, E-03, E-04, E-05 | ○ |
| C-37 | BR-037 タグによる検索 | E-19 | ○ |
| C-38 | BR-038 テキスト検索 | E-01, E-02, E-03, E-04 | ○ |
| C-39 | BR-039 ステータスフィルタ | E-01, E-04, E-05 | ○ |
| C-40 | BR-040 高度な検索 | E-19 | ○ |
| C-41 | BR-041 ダッシュボード表示 | E-20 | ○ |
| C-42 | BR-042 アクティビティ履歴表示 | E-20 | ○ |
| C-43 | BR-043 アクティビティフィルタ | E-20 | ○ |
| C-44 | BR-044 CSVエクスポート | E-12, E-13, E-15, E-16 | ○ |
| C-45 | BR-045 Excelエクスポート | E-12, E-13, E-15, E-16 | ○ |
| C-46 | BR-046 vCard出力 | E-12, E-13 | ○ |
| C-47 | BR-047 複合住所管理 | E-22 | ○ |
| C-48 | BR-048 請求先・配送先住所管理 | E-03 | ○ |
| C-49 | BR-049 メールドロップボックス | E-22 | △ |
| C-50 | BR-050 コメント返信メール | E-22 | △ |
| C-51 | BR-051 カスタムフィールド追加 | E-01, E-02, E-03, E-04 | ○ |
| C-52 | BR-052 フィールドグループ管理 | E-19 | ○ |
| C-53 | BR-053 変更履歴の記録 | E-01, E-02, E-03, E-04 | ○ |
| C-54 | BR-054 バージョン確認 | E-19 | ○ |
| C-55 | BR-055 システム設定の管理 | E-11, E-22 | ○ |
| C-56 | BR-056 ユーザー設定の保存 | E-07 | ○ |
| C-57 | BR-057 多言語対応 | E-22 | ○ |
| C-58 | BR-058 ユーザー別言語設定 | E-22 | △ |

## 4) 不足情報（Unknown / Missing）
- BR-049（メールドロップボックス）：設定ファイルに項目は存在するが、実際のIMAP接続・処理ロジックの実装コードは確認できず
  - 候補：`app/models/email.rb` / `lib/fat_free_crm/dropbox.rb` / Rakeタスク
- BR-050（コメント返信メール）：同様に設定項目のみ確認、実装詳細は未確認
  - 候補：`lib/fat_free_crm/comment_replies.rb` / バックグラウンドジョブ
- BR-058（ユーザー別言語設定）：`per_user_locale`設定は存在するが、UIでの言語選択機能の実装は未確認
  - 候補：`app/views/users/edit` / Preferenceコントローラー

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：BR-001〜BR-048, BR-051〜BR-057 - ソースコードで直接確認済み
- 1（中リスク）：BR-058 - 設定は存在するが、フロントエンド実装の確認が必要
- 2（高リスク）：BR-049, BR-050 - メール連携機能は設定のみで、実装状況の詳細確認が必要。本番環境でのテストが推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] BR-001〜BR-005（リード管理）：`app/models/entities/lead.rb`の`promote`/`reject`/`convert`メソッドの動作確認
- [ ] BR-012〜BR-015（商談管理）：`weighted_amount`計算ロジックと`pipeline`スコープの確認
- [ ] BR-029〜BR-032（アクセス管理）：`Ability`クラスの権限定義と実際のアクセス制御テスト
- [ ] BR-049〜BR-050（メール連携）：IMAP設定と実装コードの存在確認、統合テスト実施
- [ ] BR-053〜BR-054（変更履歴）：PaperTrailによるバージョン管理の動作確認
- [ ] 全体：Setting.default.ymlで定義されたステータス値が実際の画面で正しく表示されることの確認
