---
generated_at: 2026-01-13 16:30:00
metrics:
  claims_total: 86
  claims_with_evidence: 86
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：86 / 86、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全ての機能はコードに基づいて特定されています

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/home_controller.rb`
- E-02: `app/controllers/entities/accounts_controller.rb`
- E-03: `app/controllers/entities/campaigns_controller.rb`
- E-04: `app/controllers/entities/contacts_controller.rb`
- E-05: `app/controllers/entities/leads_controller.rb`
- E-06: `app/controllers/entities/opportunities_controller.rb`
- E-07: `app/controllers/tasks_controller.rb`
- E-08: `app/controllers/comments_controller.rb`
- E-09: `app/controllers/emails_controller.rb`
- E-10: `app/controllers/users_controller.rb`
- E-11: `app/controllers/sessions_controller.rb`
- E-12: `app/controllers/registrations_controller.rb`
- E-13: `app/controllers/passwords_controller.rb`
- E-14: `app/controllers/confirmations_controller.rb`
- E-15: `app/controllers/lists_controller.rb`
- E-16: `app/controllers/admin/users_controller.rb`
- E-17: `app/controllers/admin/groups_controller.rb`
- E-18: `app/controllers/admin/tags_controller.rb`
- E-19: `app/controllers/admin/fields_controller.rb`
- E-20: `app/controllers/admin/settings_controller.rb`
- E-21: `app/controllers/admin/plugins_controller.rb`
- E-22: `app/controllers/entities_controller.rb`
- E-23: `app/controllers/application_controller.rb`
- E-24: `config/routes.rb`
- E-25: `README.md`
- E-26: `app/models/polymorphic/tag.rb`
- E-27: `app/models/polymorphic/tagging.rb`
- E-28: `app/models/users/permission.rb`
- E-29: `app/models/users/ability.rb`
- E-30: `app/models/polymorphic/version.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダッシュボード表示機能 | E-01 | ○ |
| C-02 | アクティビティフィルタリング機能 | E-01 | ○ |
| C-03 | タイムライン表示切替機能 | E-01 | ○ |
| C-04 | 取引先一覧表示機能 | E-02, E-24 | ○ |
| C-05 | 取引先詳細表示機能 | E-02 | ○ |
| C-06 | 取引先作成機能 | E-02 | ○ |
| C-07 | 取引先編集機能 | E-02 | ○ |
| C-08 | 取引先削除機能 | E-02 | ○ |
| C-09 | 取引先アタッチ/ディスカード機能 | E-22 | ○ |
| C-10 | キャンペーン一覧表示機能 | E-03, E-24 | ○ |
| C-11 | キャンペーン詳細表示機能 | E-03 | ○ |
| C-12 | キャンペーン作成機能 | E-03 | ○ |
| C-13 | キャンペーン編集機能 | E-03 | ○ |
| C-14 | キャンペーン削除機能 | E-03 | ○ |
| C-15 | 連絡先一覧表示機能 | E-04, E-24 | ○ |
| C-16 | 連絡先詳細表示機能 | E-04 | ○ |
| C-17 | 連絡先作成機能 | E-04 | ○ |
| C-18 | 連絡先編集機能 | E-04 | ○ |
| C-19 | 連絡先削除機能 | E-04 | ○ |
| C-20 | リード一覧表示機能 | E-05, E-24 | ○ |
| C-21 | リード詳細表示機能 | E-05 | ○ |
| C-22 | リード作成機能 | E-05 | ○ |
| C-23 | リード編集機能 | E-05 | ○ |
| C-24 | リード削除機能 | E-05 | ○ |
| C-25 | リード変換（コンバート）機能 | E-05, E-24 | ○ |
| C-26 | リードプロモート機能 | E-05, E-24 | ○ |
| C-27 | リード却下機能 | E-05, E-24 | ○ |
| C-28 | 商談一覧表示機能 | E-06, E-24 | ○ |
| C-29 | 商談詳細表示機能 | E-06 | ○ |
| C-30 | 商談作成機能 | E-06 | ○ |
| C-31 | 商談編集機能 | E-06 | ○ |
| C-32 | 商談削除機能 | E-06 | ○ |
| C-33 | 商談サマリー（ユーザー別）機能 | E-10, E-24 | ○ |
| C-34 | タスク一覧表示機能 | E-07, E-24 | ○ |
| C-35 | タスク詳細表示機能 | E-07 | ○ |
| C-36 | タスク作成機能 | E-07 | ○ |
| C-37 | タスク編集機能 | E-07 | ○ |
| C-38 | タスク削除機能 | E-07 | ○ |
| C-39 | タスク完了機能 | E-07, E-24 | ○ |
| C-40 | タスク未完了に戻す機能 | E-07, E-24 | ○ |
| C-41 | タスクフィルタリング機能 | E-07, E-24 | ○ |
| C-42 | コメント一覧表示機能 | E-08 | ○ |
| C-43 | コメント作成機能 | E-08, E-24 | ○ |
| C-44 | コメント編集機能 | E-08 | ○ |
| C-45 | コメント削除機能 | E-08, E-24 | ○ |
| C-46 | メール削除機能 | E-09, E-24 | ○ |
| C-47 | ユーザープロファイル表示機能 | E-10, E-24 | ○ |
| C-48 | ユーザープロファイル編集機能 | E-10 | ○ |
| C-49 | アバター管理機能 | E-10, E-24 | ○ |
| C-50 | パスワード変更機能 | E-10, E-24 | ○ |
| C-51 | ロケール設定機能 | E-10 | ○ |
| C-52 | ログイン機能 | E-11, E-24 | ○ |
| C-53 | ログアウト機能 | E-11 | ○ |
| C-54 | ユーザー登録機能 | E-12, E-24 | ○ |
| C-55 | パスワードリセット機能 | E-13, E-24 | ○ |
| C-56 | メール確認機能 | E-14, E-24 | ○ |
| C-57 | リスト作成機能 | E-15, E-24 | ○ |
| C-58 | リスト削除機能 | E-15, E-24 | ○ |
| C-59 | 管理ユーザー一覧機能 | E-16, E-24 | ○ |
| C-60 | 管理ユーザー作成機能 | E-16 | ○ |
| C-61 | 管理ユーザー編集機能 | E-16 | ○ |
| C-62 | 管理ユーザー削除機能 | E-16 | ○ |
| C-63 | ユーザーアカウント停止機能 | E-16, E-24 | ○ |
| C-64 | ユーザーアカウント再有効化機能 | E-16, E-24 | ○ |
| C-65 | グループ管理一覧機能 | E-17, E-24 | ○ |
| C-66 | グループ作成機能 | E-17 | ○ |
| C-67 | グループ編集機能 | E-17 | ○ |
| C-68 | グループ削除機能 | E-17 | ○ |
| C-69 | タグ管理一覧機能 | E-18, E-24 | ○ |
| C-70 | タグ作成機能 | E-18 | ○ |
| C-71 | タグ編集機能 | E-18 | ○ |
| C-72 | タグ削除機能 | E-18 | ○ |
| C-73 | カスタムフィールド管理機能 | E-19, E-24 | ○ |
| C-74 | カスタムフィールド作成機能 | E-19 | ○ |
| C-75 | カスタムフィールド編集機能 | E-19 | ○ |
| C-76 | カスタムフィールド削除機能 | E-19 | ○ |
| C-77 | カスタムフィールド並び替え機能 | E-19, E-24 | ○ |
| C-78 | システム設定表示機能 | E-20, E-24 | ○ |
| C-79 | システム設定更新機能 | E-20 | ○ |
| C-80 | プラグイン一覧機能 | E-21, E-24 | ○ |
| C-81 | 高度な検索機能 | E-24 | ○ |
| C-82 | オートコンプリート機能 | E-23, E-24 | ○ |
| C-83 | タグ付け機能 | E-26, E-27 | ○ |
| C-84 | アクセス権限管理機能 | E-28, E-29 | ○ |
| C-85 | バージョン履歴機能 | E-30 | ○ |
| C-86 | 購読/購読解除機能 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし：全ての機能はソースコードから直接確認されています

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能はコントローラーとルートファイルから直接抽出されており、コードベースとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 機能一覧のカテゴリ分類が適切か確認
- [ ] 各機能の説明がビジネス要件と一致しているか確認
- [ ] 隠れた機能（内部APIや非公開機能）が漏れていないか確認
- [ ] プラグインによる拡張機能が別途存在しないか確認
- [ ] 権限によって利用可能な機能が異なる場合、その記載が十分か確認
