# 機能設計書 11-キャンペーン詳細表示

## 概要

本ドキュメントは、Fat Free CRMにおけるキャンペーン詳細表示機能の設計を記述する。キャンペーンの詳細情報、関連するリード・商談、タイムラインを表示する機能である。

### 本機能の処理概要

**業務上の目的・背景**：マーケティングキャンペーンの詳細情報を一元的に確認することで、キャンペーンの進捗状況、目標達成度、関連するリードや商談の状況を把握できる。これにより、マーケティング活動の効果測定や意思決定をサポートする。

**機能の利用シーン**：マーケティング担当者がキャンペーンの詳細を確認する際、リードや商談の状況を確認する際、キャンペーンにコメントを追加する際に利用される。また、キャンペーンのパフォーマンス指標（予算、目標リード数、目標収益等）を確認する場面でも使用される。

**主要な処理内容**：
1. キャンペーンIDに基づいてキャンペーン情報をデータベースから取得
2. 関連するリード、商談、タスクを取得
3. タイムライン情報（コメント、メール）を時系列で取得
4. 商談ステージ設定を取得
5. 各種フォーマット（HTML、JS、XLS、CSV、RSS、ATOM）でレスポンスを生成

**関連システム・外部連携**：RSS/ATOMフィード形式でのデータエクスポートに対応しており、外部のRSSリーダーやフィードアグリゲーターとの連携が可能。

**権限による制御**：CanCanによるアクセス権限管理が行われ、ユーザーがアクセス可能なキャンペーンのみ表示される。キャンペーンのアクセス設定（Public/Private/Shared）により閲覧可否が決定される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | キャンペーン詳細画面 | 主画面 | キャンペーン詳細、関連リード・商談、タイムライン表示 |
| 11 | キャンペーン一覧画面 | 参照画面 | 一覧から詳細画面への遷移元 |

## 機能種別

データ参照（Read操作）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | キャンペーンID | 数値形式、存在チェック |
| format | String | No | レスポンス形式（html/js/xls/csv/rss/atom） | 許可された形式のみ |

### 入力データソース

- URLパラメータ（キャンペーンID）
- セッション情報（現在のユーザー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @campaign | Campaign | キャンペーンオブジェクト |
| @stage | Array | 商談ステージ設定リスト |
| @comment | Comment | 新規コメント用オブジェクト |
| @timeline | Array | コメントとメールの時系列リスト |

### 出力先

- HTML画面表示
- AJAX（JS）レスポンス
- XLS/CSVファイルダウンロード（リード一覧）
- RSS/ATOMフィード

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ authenticate_user!でログイン状態を確認
2. キャンペーン取得
   └─ load_and_authorize_resourceでID指定のキャンペーンを取得し権限確認
3. 関連データ取得（HTMLフォーマットの場合）
   └─ 商談ステージ設定、新規コメントオブジェクト、タイムライン生成
4. 閲覧履歴記録
   └─ update_recently_viewedでVersionテーブルにviewイベント記録
5. レスポンス生成
   └─ フォーマットに応じた出力（HTML/JS/XLS/CSV/RSS/ATOM）
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[ユーザー認証]
    B --> C{認証OK?}
    C -->|No| D[ログインページへリダイレクト]
    C -->|Yes| E[キャンペーン取得]
    E --> F{存在確認}
    F -->|No| G[404エラー]
    F -->|Yes| H{アクセス権限確認}
    H -->|No| I[403エラー]
    H -->|Yes| J{フォーマット判定}
    J -->|HTML/JS| K[詳細データ取得]
    K --> L[タイムライン生成]
    L --> M[ビュー描画]
    J -->|XLS/CSV| N[リード一覧取得]
    N --> O[ファイル生成]
    J -->|RSS/ATOM| P[フィード生成]
    M --> Q[閲覧履歴記録]
    O --> Q
    P --> Q
    Q --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-11-01 | アクセス権限制御 | キャンペーンのaccess設定に基づき閲覧可否を判定 | 常時 |
| BR-11-02 | タイムライン並び順 | コメントとメールを作成日時の降順でソート | タイムライン表示時 |
| BR-11-03 | 閲覧履歴記録 | showアクション完了時にVersionテーブルに記録 | HTML/JSリクエスト時 |

### 計算ロジック

タイムライン生成ロジック：
```ruby
(campaign.comments + campaign.emails).sort { |x, y| y.created_at <=> x.created_at }
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| キャンペーン取得 | campaigns | SELECT | ID指定でキャンペーン情報取得 |
| リード取得 | leads | SELECT | campaign_idで関連リード取得 |
| 商談取得 | opportunities | SELECT | campaign_idで関連商談取得 |
| コメント取得 | comments | SELECT | commentable_type/idで取得 |
| メール取得 | emails | SELECT | mediator_type/idで取得 |
| 閲覧履歴記録 | versions | INSERT | viewイベント記録 |

### テーブル別操作詳細

#### campaigns

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = パラメータ指定値 | deleted_at IS NULL も適用 |

#### versions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | item_type | 'Campaign' | |
| INSERT | item_id | キャンペーンID | |
| INSERT | event | 'view' | |
| INSERT | whodunnit | 現在ユーザーID | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | 未ログイン状態でアクセス | ログインページへリダイレクト |
| 403 | 権限エラー | アクセス権限がないキャンペーン | アクセス拒否メッセージ表示 |
| 404 | 存在しないリソース | 指定IDのキャンペーンが存在しない | 警告メッセージと一覧へリダイレクト |

### リトライ仕様

本機能にリトライ処理は実装されていない。

## トランザクション仕様

参照系処理が主であり、閲覧履歴記録のINSERTは独立したトランザクションで実行される。

## パフォーマンス要件

- キャンペーン詳細ページの表示は2秒以内を目標
- 関連リード・商談は各20件を上限として初期表示

## セキュリティ考慮事項

- CanCanによるアクセス権限チェック実施
- CSRF対策（protect_from_forgery）
- SQLインジェクション対策（ActiveRecord使用）
- XSS対策（ERB::Util使用）

## 備考

- キャンペーンの購読/購読解除機能は別機能（No.86）として管理
- バージョン履歴表示は別機能（No.85）として管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、キャンペーンエンティティの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | campaign.rb | `app/models/entities/campaign.rb` | Campaignモデルの属性、関連（has_many :leads, :opportunities等）、バリデーション |

**読解のコツ**:
- **34-39行目**: `belongs_to`と`has_many`の関連定義でキャンペーンと他エンティティの関係を把握
- **52-62行目**: `uses_user_permissions`, `acts_as_commentable`, `has_paper_trail`等のモジュール適用でキャンペーンの機能を理解

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのshowアクションを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | campaigns_controller.rb | `app/controllers/entities/campaigns_controller.rb` | showアクションの処理内容 |

**主要処理フロー**:
1. **8行目**: `EntitiesController`を継承、共通機能の継承元を確認
2. **30-63行目**: showアクションの実装。フォーマット別の処理分岐を確認
3. **33-35行目**: HTML/JS形式の場合、商談ステージ設定、コメントオブジェクト、タイムライン生成

#### Step 3: 基底コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | entities_controller.rb | `app/controllers/entities_controller.rb` | 共通処理（権限チェック、閲覧履歴記録等） |

**主要処理フロー**:
- **15行目**: `load_and_authorize_resource`でリソースロードと権限チェック
- **17行目**: `after_action :update_recently_viewed`で閲覧履歴記録
- **215-217行目**: `timeline`メソッドでコメントとメールの時系列リスト生成

#### Step 4: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | show.html.haml | `app/views/campaigns/show.html.haml` | 詳細画面のレイアウト構成 |
| 4-2 | _sidebar_show.html.haml | `app/views/campaigns/_sidebar_show.html.haml` | サイドバー表示内容 |

**主要処理フロー**:
- **9-10行目**: タイトルバーとサイドバーのレンダリング
- **12-13行目**: コメントフォームとタイムライン表示
- **17-23行目**: タスク、リード、商談、バージョン履歴の各セクション表示

### プログラム呼び出し階層図

```
CampaignsController#show
    │
    ├─ EntitiesController (継承)
    │      ├─ load_and_authorize_resource
    │      └─ update_recently_viewed
    │
    ├─ Campaign.find(id)
    │
    ├─ Setting.unroll(:opportunity_stage)
    │
    └─ timeline(@campaign)
           └─ コメント + メールのソート
```

### データフロー図

```
[入力]               [処理]                    [出力]

キャンペーンID ───▶ CampaignsController#show ───▶ HTML画面
                          │
URLパラメータ             ├─▶ Campaign取得
                          │
                          ├─▶ 関連データ取得
                          │     (leads, opportunities)
                          │
                          └─▶ タイムライン生成
                                (comments + emails)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| campaigns_controller.rb | `app/controllers/entities/campaigns_controller.rb` | コントローラー | キャンペーン関連アクションの処理 |
| entities_controller.rb | `app/controllers/entities_controller.rb` | コントローラー | エンティティ共通処理 |
| campaign.rb | `app/models/entities/campaign.rb` | モデル | キャンペーンエンティティ定義 |
| show.html.haml | `app/views/campaigns/show.html.haml` | ビュー | 詳細画面テンプレート |
| _sidebar_show.html.haml | `app/views/campaigns/_sidebar_show.html.haml` | ビュー | サイドバーパーシャル |
| _title_bar.html.haml | `app/views/campaigns/_title_bar.html.haml` | ビュー | タイトルバーパーシャル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
