# 機能設計書 14-キャンペーン削除

## 概要

本ドキュメントは、Fat Free CRMにおけるキャンペーン削除機能の設計を記述する。既存のキャンペーンを削除する機能である。

### 本機能の処理概要

**業務上の目的・背景**：不要になったキャンペーン、誤って作成されたキャンペーン、または終了して保持する必要がなくなったキャンペーンをシステムから削除する。これによりデータの整理と管理効率の向上を実現する。

**機能の利用シーン**：テスト目的で作成したキャンペーンを削除する場合、重複して作成されたキャンペーンを整理する場合、完了後一定期間経過したキャンペーンを削除する場合に利用される。

**主要な処理内容**：
1. 削除対象キャンペーンの取得と権限確認
2. キャンペーンレコードの論理削除（deleted_atに日時設定）
3. 関連データ（タスク等）の処理
4. サイドバーデータの更新（AJAX削除時）
5. 成功/失敗に応じたレスポンス生成

**関連システム・外部連携**：特になし。内部のCRMデータとして管理される。

**権限による制御**：CanCanによるアクセス権限管理が行われる。キャンペーンの所有者または管理者のみ削除可能。削除されたキャンペーンに紐付くリード・商談は、campaign_idがNULLになるが削除はされない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | キャンペーン一覧画面 | 主画面 | キャンペーンの削除処理 |
| 12 | キャンペーン詳細画面 | 参照画面 | 詳細画面からのキャンペーン削除 |

## 機能種別

CRUD操作（Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | キャンペーンID | 数値形式、存在チェック |

### 入力データソース

- URLパラメータ（キャンペーンID）
- セッション情報（現在のユーザー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @campaign | Campaign | 削除されたキャンペーンオブジェクト |
| @campaigns | Array | キャンペーン一覧（一覧ページからの削除時） |

### 出力先

- HTMLリダイレクト（通常リクエスト時）
- AJAX（JS）レスポンス（AJAXリクエスト時）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ authenticate_user!でログイン状態を確認
2. キャンペーン取得と権限確認
   └─ load_and_authorize_resourceでID指定のキャンペーンを取得し権限確認
3. キャンペーン削除実行
   └─ destroyメソッドで論理削除（deleted_atに日時設定）
4. レスポンス分岐
   └─ HTML: フラッシュメッセージ設定、一覧へリダイレクト
   └─ JS: サイドバーデータ更新、一覧更新、destroy.js描画
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[ユーザー認証]
    B --> C{認証OK?}
    C -->|No| D[ログインページへリダイレクト]
    C -->|Yes| E[キャンペーン取得]
    E --> F{存在確認}
    F -->|No| G[404エラー]
    F -->|Yes| H{アクセス権限確認}
    H -->|No| I[403エラー]
    H -->|Yes| J[キャンペーン削除]
    J --> K{フォーマット判定}
    K -->|HTML| L[フラッシュメッセージ設定]
    L --> M[一覧ページへリダイレクト]
    K -->|JS| N[サイドバーデータ更新]
    N --> O[キャンペーン一覧取得]
    O --> P{一覧が空?}
    P -->|Yes| Q{現在ページ > 1?}
    Q -->|Yes| R[前ページの一覧取得]
    R --> S[index描画]
    Q -->|No| S
    P -->|No| T[destroy.js描画]
    M --> U[終了]
    S --> U
    T --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | 論理削除 | 物理削除ではなく論理削除（deleted_at設定）を実行 | 常時 |
| BR-14-02 | 関連リードの扱い | キャンペーンに紐付くリードのcampaign_idはNULLになるが、リード自体は削除されない | キャンペーン削除時 |
| BR-14-03 | 関連商談の扱い | キャンペーンに紐付く商談のcampaign_idはNULLになるが、商談自体は削除されない | キャンペーン削除時 |
| BR-14-04 | 関連タスクの扱い | キャンペーンに紐付くタスクは削除される（dependent: :destroy） | キャンペーン削除時 |
| BR-14-05 | ページネーション維持 | 削除後に一覧が空になった場合、前ページに自動遷移 | AJAX削除時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| キャンペーン取得 | campaigns | SELECT | ID指定でキャンペーン情報取得 |
| キャンペーン削除 | campaigns | UPDATE | deleted_atに現在日時を設定（論理削除） |
| 関連タスク削除 | tasks | DELETE | asset_type='Campaign', asset_id=削除対象ID |
| サイドバー集計 | campaigns | SELECT | ステータス別カウント再取得 |

### テーブル別操作詳細

#### campaigns

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = パラメータ指定値 | |
| UPDATE | deleted_at | 現在日時 | 論理削除 |

#### tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | asset_type='Campaign' AND asset_id=キャンペーンID | dependent: :destroyによる |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | 未ログイン状態でアクセス | ログインページへリダイレクト |
| 403 | 権限エラー | 削除権限がないキャンペーン | アクセス拒否メッセージ表示 |
| 404 | 存在しないリソース | 指定IDのキャンペーンが存在しない | 警告メッセージと一覧へリダイレクト |

### リトライ仕様

本機能にリトライ処理は実装されていない。

## トランザクション仕様

キャンペーン削除と関連タスク削除は同一トランザクションで実行される。

## パフォーマンス要件

- 削除処理は1秒以内を目標

## セキュリティ考慮事項

- CanCanによるアクセス権限チェック実施
- CSRF対策（protect_from_forgery）
- SQLインジェクション対策（ActiveRecord使用）

## 備考

- 削除されたキャンペーンは論理削除のため、データベースには残存する
- 復旧が必要な場合はdeleted_atをNULLに更新することで可能（UI機能はなし）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、キャンペーンエンティティの削除に関する設定を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | campaign.rb | `app/models/entities/campaign.rb` | dependent: :destroyの関連定義 |

**読解のコツ**:
- **37行目**: `has_many :tasks, as: :asset, dependent: :destroy`でタスクの連動削除を確認
- **38-39行目**: `has_many :leads`、`has_many :opportunities`はdependent指定なし（削除されない）

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのdestroyアクションを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | campaigns_controller.rb | `app/controllers/entities/campaigns_controller.rb` | destroyアクションの処理内容 |

**主要処理フロー**:
1. **118-125行目**: destroyアクション - 削除実行、レスポンス分岐
2. **174-188行目**: respond_to_destroyメソッド - HTML/AJAX別の後処理

#### Step 3: レスポンス処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | destroy.js.haml | `app/views/campaigns/destroy.js.haml` | AJAX削除時のJSレスポンス |

**主要処理フロー**:
- 削除されたキャンペーン要素のDOM削除
- サイドバーの更新

### プログラム呼び出し階層図

```
CampaignsController#destroy
    │
    ├─ EntitiesController (継承)
    │      └─ load_and_authorize_resource
    │
    ├─ Campaign#destroy
    │      ├─ UPDATE campaigns (deleted_at設定)
    │      └─ DELETE tasks (dependent: :destroy)
    │
    └─ respond_to_destroy
           ├─ :html -> flash設定、redirect_to campaigns_path
           └─ :ajax -> get_data_for_sidebar、get_campaigns
```

### データフロー図

```
[入力]               [処理]                    [出力]

キャンペーンID ───▶ CampaignsController#destroy ───▶ リダイレクト/JSレスポンス
                          │
                          ├─▶ Campaign#destroy
                          │     ├─▶ campaigns UPDATE (deleted_at)
                          │     └─▶ tasks DELETE
                          │
                          └─▶ respond_to_destroy
                                ├─▶ HTML: リダイレクト
                                └─▶ JS: DOM更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| campaigns_controller.rb | `app/controllers/entities/campaigns_controller.rb` | コントローラー | キャンペーン関連アクションの処理 |
| entities_controller.rb | `app/controllers/entities_controller.rb` | コントローラー | エンティティ共通処理 |
| campaign.rb | `app/models/entities/campaign.rb` | モデル | キャンペーンエンティティ定義 |
| destroy.js.haml | `app/views/campaigns/destroy.js.haml` | ビュー | 削除完了用JSテンプレート |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
