# 機能設計書 16-連絡先詳細表示

## 概要

本ドキュメントは、Fat Free CRMにおける連絡先詳細表示機能の設計を記述する。連絡先の詳細情報、関連する商談、タイムラインを表示し、vCard形式でエクスポートする機能である。

### 本機能の処理概要

**業務上の目的・背景**：顧客担当者や見込み顧客の詳細情報を一元的に確認することで、効果的な顧客コミュニケーションを実現する。連絡先の基本情報だけでなく、関連する商談やコミュニケーション履歴（タイムライン）を確認でき、顧客との関係性を把握できる。

**機能の利用シーン**：営業担当者が顧客との打ち合わせ前に連絡先情報を確認する場合、連絡先に関連する商談の状況を確認する場合、連絡先へのコメントを追加する場合に利用される。また、vCard形式でエクスポートして外部のアドレス帳アプリに登録する場合にも使用される。

**主要な処理内容**：
1. 連絡先IDに基づいて連絡先情報をデータベースから取得
2. 関連する商談、タスクを取得
3. タイムライン情報（コメント、メール）を時系列で取得
4. 商談ステージ設定を取得
5. 各種フォーマット（HTML、JS、VCF）でレスポンスを生成

**関連システム・外部連携**：vCard形式でのデータエクスポートに対応しており、外部のアドレス帳アプリ（Outlook、iOSの連絡先等）との連携が可能。

**権限による制御**：CanCanによるアクセス権限管理が行われ、ユーザーがアクセス可能な連絡先のみ表示される。連絡先のアクセス設定（Public/Private/Shared）により閲覧可否が決定される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | 連絡先詳細画面 | 主画面 | 連絡先詳細情報、関連商談、タイムライン表示、vCardエクスポート |
| 20 | 連絡先一覧画面 | 参照画面 | 一覧から詳細画面への遷移元 |

## 機能種別

データ参照（Read操作）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | 連絡先ID | 数値形式、存在チェック |
| format | String | No | レスポンス形式（html/js/vcf） | 許可された形式のみ |

### 入力データソース

- URLパラメータ（連絡先ID）
- セッション情報（現在のユーザー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @contact | Contact | 連絡先オブジェクト |
| @stage | Array | 商談ステージ設定リスト |
| @comment | Comment | 新規コメント用オブジェクト |
| @timeline | Array | コメントとメールの時系列リスト |

### 出力先

- HTML画面表示
- AJAX（JS）レスポンス
- vCardファイルダウンロード（.vcf）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ authenticate_user!でログイン状態を確認
2. 連絡先取得
   └─ load_and_authorize_resourceでID指定の連絡先を取得し権限確認
3. 関連データ取得
   └─ 商談ステージ設定、新規コメントオブジェクト、タイムライン生成
4. 閲覧履歴記録
   └─ update_recently_viewedでVersionテーブルにviewイベント記録
5. レスポンス生成
   └─ フォーマットに応じた出力（HTML/JS/VCF）
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[ユーザー認証]
    B --> C{認証OK?}
    C -->|No| D[ログインページへリダイレクト]
    C -->|Yes| E[連絡先取得]
    E --> F{存在確認}
    F -->|No| G[404エラー]
    F -->|Yes| H{アクセス権限確認}
    H -->|No| I[403エラー]
    H -->|Yes| J{フォーマット判定}
    J -->|HTML/JS| K[詳細データ取得]
    K --> L[タイムライン生成]
    L --> M[ビュー描画]
    J -->|VCF| N[vCard生成]
    N --> O[ファイルダウンロード]
    M --> P[閲覧履歴記録]
    O --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-16-01 | アクセス権限制御 | 連絡先のaccess設定に基づき閲覧可否を判定 | 常時 |
| BR-16-02 | タイムライン並び順 | コメントとメールを作成日時の降順でソート | タイムライン表示時 |
| BR-16-03 | 閲覧履歴記録 | showアクション完了時にVersionテーブルに記録 | HTML/JSリクエスト時 |
| BR-16-04 | vCardファイル名 | 連絡先のフルネームをファイル名として使用 | VCFエクスポート時 |

### 計算ロジック

タイムライン生成ロジック：
```ruby
(contact.comments + contact.emails).sort { |x, y| y.created_at <=> x.created_at }
```

フルネーム生成ロジック：
```ruby
def full_name(format = nil)
  if format.nil? || format == "before"
    "#{first_name} #{last_name}"
  else
    "#{last_name}, #{first_name}"
  end
end
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 連絡先取得 | contacts | SELECT | ID指定で連絡先情報取得 |
| 取引先取得 | accounts | SELECT | 連絡先に紐付く取引先取得 |
| 商談取得 | opportunities | SELECT | contact_idで関連商談取得 |
| コメント取得 | comments | SELECT | commentable_type/idで取得 |
| メール取得 | emails | SELECT | mediator_type/idで取得 |
| 閲覧履歴記録 | versions | INSERT | viewイベント記録 |

### テーブル別操作詳細

#### contacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = パラメータ指定値 | deleted_at IS NULL も適用 |

#### versions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | item_type | 'Contact' | |
| INSERT | item_id | 連絡先ID | |
| INSERT | event | 'view' | |
| INSERT | whodunnit | 現在ユーザーID | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | 未ログイン状態でアクセス | ログインページへリダイレクト |
| 403 | 権限エラー | アクセス権限がない連絡先 | アクセス拒否メッセージ表示 |
| 404 | 存在しないリソース | 指定IDの連絡先が存在しない | 警告メッセージと一覧へリダイレクト |

### リトライ仕様

本機能にリトライ処理は実装されていない。

## トランザクション仕様

参照系処理が主であり、閲覧履歴記録のINSERTは独立したトランザクションで実行される。

## パフォーマンス要件

- 連絡先詳細ページの表示は2秒以内を目標

## セキュリティ考慮事項

- CanCanによるアクセス権限チェック実施
- CSRF対策（protect_from_forgery）
- SQLインジェクション対策（ActiveRecord使用）
- XSS対策（ERB::Util使用）

## 備考

- 連絡先の購読/購読解除機能は別機能（No.86）として管理
- バージョン履歴表示は別機能（No.85）として管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、連絡先エンティティの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.rb | `app/models/entities/contact.rb` | Contactモデルの属性、関連、メソッド定義 |

**読解のコツ**:
- **40-52行目**: 関連定義（belongs_to :user, has_one :account等）
- **125-131行目**: `full_name`メソッドで名前表示形式を確認
- **86-89行目**: uses_user_permissions, acts_as_commentable等のモジュール適用

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのshowアクションを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | contacts_controller.rb | `app/controllers/entities/contacts_controller.rb` | showアクションの処理内容 |

**主要処理フロー**:
1. **25-32行目**: showアクション - 商談ステージ設定、コメント、タイムライン、vCard対応
2. **30行目**: vCard形式の場合、send_dataでファイルダウンロード

#### Step 3: 基底コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | entities_controller.rb | `app/controllers/entities_controller.rb` | 共通処理（権限チェック、閲覧履歴記録等） |

**主要処理フロー**:
- **15行目**: `load_and_authorize_resource`でリソースロードと権限チェック
- **17行目**: `after_action :update_recently_viewed`で閲覧履歴記録
- **215-217行目**: `timeline`メソッドでコメントとメールの時系列リスト生成

#### Step 4: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | show.html.haml | `app/views/contacts/show.html.haml` | 詳細画面のレイアウト構成 |
| 4-2 | _sidebar_show.html.haml | `app/views/contacts/_sidebar_show.html.haml` | サイドバー表示内容 |

**主要処理フロー**:
- **9-10行目**: タイトルバーとサイドバーのレンダリング
- **12-13行目**: コメントフォームとタイムライン表示
- **17-21行目**: タスク、商談、バージョン履歴の各セクション表示

### プログラム呼び出し階層図

```
ContactsController#show
    │
    ├─ EntitiesController (継承)
    │      ├─ load_and_authorize_resource
    │      └─ update_recently_viewed
    │
    ├─ Contact.find(id)
    │
    ├─ Setting.unroll(:opportunity_stage)
    │
    ├─ timeline(@contact)
    │      └─ コメント + メールのソート
    │
    └─ vcard_for(@contact) [VCF形式の場合]
```

### データフロー図

```
[入力]               [処理]                    [出力]

連絡先ID ─────────▶ ContactsController#show ───▶ HTML画面/vCard
                          │
URLパラメータ             ├─▶ Contact取得
                          │
                          ├─▶ 関連データ取得
                          │     (account, opportunities)
                          │
                          ├─▶ タイムライン生成
                          │     (comments + emails)
                          │
                          └─▶ vCard生成 (VCF形式の場合)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| contacts_controller.rb | `app/controllers/entities/contacts_controller.rb` | コントローラー | 連絡先関連アクションの処理 |
| entities_controller.rb | `app/controllers/entities_controller.rb` | コントローラー | エンティティ共通処理 |
| contact.rb | `app/models/entities/contact.rb` | モデル | 連絡先エンティティ定義 |
| show.html.haml | `app/views/contacts/show.html.haml` | ビュー | 詳細画面テンプレート |
| _sidebar_show.html.haml | `app/views/contacts/_sidebar_show.html.haml` | ビュー | サイドバーパーシャル |
| _title_bar.html.haml | `app/views/contacts/_title_bar.html.haml` | ビュー | タイトルバーパーシャル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
