# 機能設計書 18-連絡先編集

## 概要

本ドキュメントは、Fat Free CRMにおける連絡先編集機能の設計を記述する。既存の連絡先情報を更新する機能である。

### 本機能の処理概要

**業務上の目的・背景**：顧客担当者の情報は変更されることが多い（役職変更、部署異動、連絡先変更等）。これらの変更を適時にシステムに反映することで、正確な顧客情報の管理を実現する。取引先との紐付け変更も可能。

**機能の利用シーン**：連絡先の役職や部署が変わった場合、連絡先のメールアドレスや電話番号が変わった場合、連絡先の所属取引先が変わった場合、アクセス権限を変更する場合に利用される。

**主要な処理内容**：
1. 編集フォームの表示（editアクション）
2. 既存連絡先情報のフォームへの表示
3. 入力された更新情報のバリデーション
4. 取引先との紐付け更新
5. 連絡先レコードの更新
6. 成功/失敗に応じたレスポンス生成

**関連システム・外部連携**：特になし。内部のCRMデータとして管理される。

**権限による制御**：CanCanによるアクセス権限管理が行われる。連絡先の所有者または共有権限を持つユーザーのみ編集可能。アクセス権限を変更する際は、accessパラメータを先に設定する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | 連絡先編集フォーム | 主画面 | 連絡先情報更新 |
| 21 | 連絡先詳細画面 | 参照画面 | 編集完了後の遷移先 |
| 20 | 連絡先一覧画面 | 参照画面 | 一覧からの編集時の遷移元 |

## 機能種別

CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | 連絡先ID | 数値形式、存在チェック |
| contact[first_name] | String | 条件付 | 名（最大64文字） | Setting.require_first_namesで必須化 |
| contact[last_name] | String | 条件付 | 姓（最大64文字） | Setting.require_last_namesで必須化 |
| contact[title] | String | No | 役職（最大64文字） | 最大64文字 |
| contact[department] | String | No | 部門（最大64文字） | 最大64文字 |
| contact[email] | String | No | メールアドレス | 最大254文字 |
| contact[alt_email] | String | No | 代替メール | 最大254文字 |
| contact[phone] | String | No | 電話番号 | 最大32文字 |
| contact[mobile] | String | No | 携帯電話 | 最大32文字 |
| contact[access] | String | No | アクセス権限 | Public/Private/Shared |
| contact[assigned_to] | Integer | No | 担当者ID | 存在するユーザーID |
| account[id] | Integer | No | 既存取引先ID | 存在する取引先ID |
| account[name] | String | No | 新規取引先名 | - |

### 入力データソース

- URLパラメータ（連絡先ID）
- フォーム入力（AJAX PUT/PATCH）
- セッション情報（現在のユーザー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @contact | Contact | 更新された連絡先オブジェクト |
| @account | Account | 紐付いている取引先オブジェクト |
| @accounts | Array | 取引先選択リスト |
| @previous | Contact/Integer | 直前の連絡先（インライン編集時） |

### 出力先

- AJAX（JS）レスポンス
- JSON/XMLレスポンス（API経由）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ authenticate_user!でログイン状態を確認
2. 取引先一覧取得
   └─ get_accountsでユーザーがアクセス可能な取引先リストを取得
3. 連絡先取得と権限確認
   └─ load_and_authorize_resourceでID指定の連絡先を取得し権限確認
4. 編集フォーム表示（editアクション）
   └─ 既存データをフォームに表示、現在の取引先または新規取引先オブジェクト
5. パラメータ受付（updateアクション）
   └─ accessパラメータを先に設定
6. 連絡先更新
   └─ update_with_account_and_permissionsで取引先紐付けを含む更新
7. レスポンス生成
   └─ 成功/失敗に応じたJSレスポンス
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[ユーザー認証]
    B --> C{認証OK?}
    C -->|No| D[ログインページへリダイレクト]
    C -->|Yes| E[取引先一覧取得]
    E --> F[連絡先取得]
    F --> G{存在確認}
    G -->|No| H[404エラー]
    G -->|Yes| I{アクセス権限確認}
    I -->|No| J[403エラー]
    I -->|Yes| K{アクション判定}
    K -->|edit| L[現在取引先取得]
    L --> M[前回連絡先取得]
    M --> N[編集フォーム表示]
    K -->|update| O[access先行設定]
    O --> P[update_with_account_and_permissions]
    P --> Q{更新成功?}
    Q -->|No| R[エラーメッセージ表示]
    Q -->|Yes| S[成功レスポンス]
    R --> T[失敗レスポンス]
    S --> U[終了]
    T --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-18-01 | 名前必須設定 | Setting.require_first_names/last_namesに基づき必須化 | 設定による |
| BR-18-02 | 共有時のユーザー指定 | access=Sharedの場合、共有先ユーザー必須 | Shared選択時 |
| BR-18-03 | access先行設定 | user_ids設定前にaccessを設定する必要がある | 権限変更時 |
| BR-18-04 | 取引先変更 | 取引先の追加・変更・削除が可能 | 取引先入力変更時 |

### 計算ロジック

取引先更新処理ロジック：
```ruby
def update_with_account_and_permissions(params)
  save_account(params)
  # Must set access before user_ids, because user_ids= method depends on access value.
  self.access = params[:contact][:access] if params[:contact][:access]
  self.attributes = params[:contact]
  save
end
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 連絡先取得 | contacts | SELECT | ID指定で連絡先情報取得 |
| 連絡先更新 | contacts | UPDATE | 連絡先レコード更新 |
| 取引先作成 | accounts | INSERT | 新規取引先レコード挿入（同時作成時） |
| 紐付け更新 | account_contacts | DELETE/INSERT | 取引先との紐付け更新 |
| 権限更新 | permissions | DELETE/INSERT | Shared設定変更時の権限レコード更新 |
| 変更履歴記録 | versions | INSERT | 更新イベント記録（PaperTrail） |

### テーブル別操作詳細

#### contacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = パラメータ指定値 | |
| UPDATE | first_name | フォーム入力値 | |
| UPDATE | last_name | フォーム入力値 | |
| UPDATE | title | フォーム入力値 | |
| UPDATE | department | フォーム入力値 | |
| UPDATE | email | フォーム入力値 | |
| UPDATE | phone | フォーム入力値 | |
| UPDATE | access | フォーム入力値 | |
| UPDATE | assigned_to | フォーム入力値 | |
| UPDATE | updated_at | 現在日時 | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | 未ログイン状態でアクセス | ログインページへリダイレクト |
| 403 | 権限エラー | 編集権限がない連絡先 | アクセス拒否メッセージ表示 |
| 404 | 存在しないリソース | 指定IDの連絡先が存在しない | 警告メッセージと一覧へリダイレクト |
| 422 | バリデーションエラー | 必須項目未入力等 | エラーメッセージ表示 |

### リトライ仕様

本機能にリトライ処理は実装されていない。バリデーションエラー時はフォームを再表示し、ユーザーに修正を促す。

## トランザクション仕様

連絡先更新と取引先紐付け更新は同一トランザクションで実行される。

## パフォーマンス要件

- 編集フォーム表示は1秒以内を目標
- 更新処理は2秒以内を目標

## セキュリティ考慮事項

- CanCanによるアクセス権限チェック実施
- CSRF対策（protect_from_forgery）
- Strong Parametersによる許可パラメータ制限
- SQLインジェクション対策（ActiveRecord使用）
- XSS対策（ERB::Util使用）

## 備考

- 変更履歴はPaperTrailにより自動記録される（subscribed_usersは除く）
- タグ編集機能は別機能（No.83）として管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、連絡先エンティティの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.rb | `app/models/entities/contact.rb` | Contactモデルの属性、update_with_account_and_permissions |

**読解のコツ**:
- **144-151行目**: `update_with_account_and_permissions`メソッドで取引先紐付けと更新
- **148行目**: access先行設定の理由がコメントで記載

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのedit/updateアクションを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | contacts_controller.rb | `app/controllers/entities/contacts_controller.rb` | edit/updateアクションの処理内容 |

**主要処理フロー**:
1. **9行目**: `before_action :get_accounts`で取引先リスト取得
2. **54-59行目**: editアクション - 現在取引先取得、前回連絡先取得
3. **78-82行目**: updateアクション - update_with_account_and_permissions呼び出し

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _edit.html.haml | `app/views/contacts/_edit.html.haml` | 編集フォームの構造 |
| 3-2 | edit.js.haml | `app/views/contacts/edit.js.haml` | 編集フォーム表示用JSテンプレート |

**主要処理フロー**:
- **2行目**: simple_form_forでフォーム生成
- **8-13行目**: 各セクションのパーシャルレンダリング（edit: trueオプション付き）
- **17行目**: `crm.save_contact()`でフォーム送信

### プログラム呼び出し階層図

```
ContactsController#edit
    │
    ├─ get_accounts
    │
    ├─ EntitiesController (継承)
    │      └─ load_and_authorize_resource
    │
    └─ 現在取引先または新規Account取得

ContactsController#update
    │
    └─ Contact#update_with_account_and_permissions
           ├─ save_account
           │      └─ Account.create_or_select_for
           │
           ├─ access先行設定
           │
           └─ Contact#save
                  └─ バリデーション実行
```

### データフロー図

```
[入力]               [処理]                    [出力]

連絡先ID ─────────▶ ContactsController#edit ───▶ 編集フォーム
                          │
                          └─▶ Contact取得、現在取引先取得

フォーム入力 ───────▶ ContactsController#update ───▶ JSレスポンス
                          │
                          ├─▶ save_account
                          │
                          ├─▶ access先行設定
                          │
                          └─▶ Contact更新
                                └─▶ contacts UPDATE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| contacts_controller.rb | `app/controllers/entities/contacts_controller.rb` | コントローラー | 連絡先関連アクションの処理 |
| entities_controller.rb | `app/controllers/entities_controller.rb` | コントローラー | エンティティ共通処理 |
| contact.rb | `app/models/entities/contact.rb` | モデル | 連絡先エンティティ定義 |
| _edit.html.haml | `app/views/contacts/_edit.html.haml` | ビュー | 編集フォームテンプレート |
| edit.js.haml | `app/views/contacts/edit.js.haml` | ビュー | 編集フォーム表示用JSテンプレート |
| update.js.haml | `app/views/contacts/update.js.haml` | ビュー | 更新完了用JSテンプレート |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
