# 機能設計書 19-連絡先削除

## 概要

本ドキュメントは、Fat Free CRMにおける連絡先削除機能の設計を記述する。既存の連絡先を削除する機能である。

### 本機能の処理概要

**業務上の目的・背景**：不要になった連絡先、誤って作成された連絡先、または退職等で連絡が取れなくなった連絡先をシステムから削除する。これによりデータの整理と管理効率の向上を実現する。

**機能の利用シーン**：テスト目的で作成した連絡先を削除する場合、重複して作成された連絡先を整理する場合、退職・異動等で不要になった連絡先を削除する場合に利用される。

**主要な処理内容**：
1. 削除対象連絡先の取得と権限確認
2. 連絡先レコードの論理削除（deleted_atに日時設定）
3. 関連データ（タスク等）の処理
4. 成功/失敗に応じたレスポンス生成

**関連システム・外部連携**：特になし。内部のCRMデータとして管理される。

**権限による制御**：CanCanによるアクセス権限管理が行われる。連絡先の所有者または管理者のみ削除可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | 連絡先一覧画面 | 主画面 | 連絡先の削除処理 |
| 21 | 連絡先詳細画面 | 参照画面 | 詳細画面からの連絡先削除 |

## 機能種別

CRUD操作（Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | 連絡先ID | 数値形式、存在チェック |

### 入力データソース

- URLパラメータ（連絡先ID）
- セッション情報（現在のユーザー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @contact | Contact | 削除された連絡先オブジェクト |
| @contacts | Array | 連絡先一覧（一覧ページからの削除時） |

### 出力先

- HTMLリダイレクト（通常リクエスト時）
- AJAX（JS）レスポンス（AJAXリクエスト時）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ authenticate_user!でログイン状態を確認
2. 連絡先取得と権限確認
   └─ load_and_authorize_resourceでID指定の連絡先を取得し権限確認
3. 連絡先削除実行
   └─ destroyメソッドで論理削除（deleted_atに日時設定）
4. レスポンス分岐
   └─ HTML: フラッシュメッセージ設定、一覧へリダイレクト
   └─ JS: 一覧更新、destroy.js描画
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[ユーザー認証]
    B --> C{認証OK?}
    C -->|No| D[ログインページへリダイレクト]
    C -->|Yes| E[連絡先取得]
    E --> F{存在確認}
    F -->|No| G[404エラー]
    F -->|Yes| H{アクセス権限確認}
    H -->|No| I[403エラー]
    H -->|Yes| J[連絡先削除]
    J --> K{フォーマット判定}
    K -->|HTML| L[フラッシュメッセージ設定]
    L --> M[一覧ページへリダイレクト]
    K -->|JS| N{インデックスページから?}
    N -->|Yes| O[連絡先一覧取得]
    O --> P{一覧が空?}
    P -->|Yes| Q{現在ページ > 1?}
    Q -->|Yes| R[前ページの一覧取得]
    R --> S[index描画]
    Q -->|No| S
    P -->|No| T[destroy.js描画]
    N -->|No| U[current_page = 1]
    U --> T
    M --> V[終了]
    S --> V
    T --> V
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-19-01 | 論理削除 | 物理削除ではなく論理削除（deleted_at設定）を実行 | 常時 |
| BR-19-02 | 関連タスクの扱い | 連絡先に紐付くタスクは削除される（dependent: :destroy） | 連絡先削除時 |
| BR-19-03 | 関連商談の扱い | 連絡先に紐付く商談との紐付けは解除される（contact_opportunitiesが削除） | 連絡先削除時 |
| BR-19-04 | 関連取引先の扱い | 連絡先に紐付く取引先との紐付けは解除される（account_contactが削除） | 連絡先削除時 |
| BR-19-05 | ページネーション維持 | 削除後に一覧が空になった場合、前ページに自動遷移 | AJAX削除時（インデックスから） |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 連絡先取得 | contacts | SELECT | ID指定で連絡先情報取得 |
| 連絡先削除 | contacts | UPDATE | deleted_atに現在日時を設定（論理削除） |
| 関連タスク削除 | tasks | DELETE | asset_type='Contact', asset_id=削除対象ID |
| 紐付け削除 | account_contacts | DELETE | contact_id=削除対象ID |
| 紐付け削除 | contact_opportunities | DELETE | contact_id=削除対象ID |

### テーブル別操作詳細

#### contacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = パラメータ指定値 | |
| UPDATE | deleted_at | 現在日時 | 論理削除 |

#### tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | asset_type='Contact' AND asset_id=連絡先ID | dependent: :destroyによる |

#### account_contacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | contact_id=連絡先ID | dependent: :destroyによる |

#### contact_opportunities

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | contact_id=連絡先ID | dependent: :destroyによる |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | 未ログイン状態でアクセス | ログインページへリダイレクト |
| 403 | 権限エラー | 削除権限がない連絡先 | アクセス拒否メッセージ表示 |
| 404 | 存在しないリソース | 指定IDの連絡先が存在しない | 警告メッセージと一覧へリダイレクト |

### リトライ仕様

本機能にリトライ処理は実装されていない。

## トランザクション仕様

連絡先削除と関連レコード削除は同一トランザクションで実行される。

## パフォーマンス要件

- 削除処理は1秒以内を目標

## セキュリティ考慮事項

- CanCanによるアクセス権限チェック実施
- CSRF対策（protect_from_forgery）
- SQLインジェクション対策（ActiveRecord使用）

## 備考

- 削除された連絡先は論理削除のため、データベースには残存する
- 復旧が必要な場合はdeleted_atをNULLに更新することで可能（UI機能はなし）
- リードから変換された連絡先を削除しても、元のリードは影響を受けない（lead_idはNULLになる）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、連絡先エンティティの削除に関する設定を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.rb | `app/models/entities/contact.rb` | dependent: :destroyの関連定義 |

**読解のコツ**:
- **45行目**: `has_one :account_contact, dependent: :destroy`で取引先紐付けの連動削除
- **47行目**: `has_many :contact_opportunities, dependent: :destroy`で商談紐付けの連動削除
- **49行目**: `has_many :tasks, as: :asset, dependent: :destroy`でタスクの連動削除

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのdestroyアクションを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | contacts_controller.rb | `app/controllers/entities/contacts_controller.rb` | destroyアクションの処理内容 |

**主要処理フロー**:
1. **86-93行目**: destroyアクション - 削除実行、レスポンス分岐
2. **151-168行目**: respond_to_destroyメソッド - HTML/AJAX別の後処理

#### Step 3: レスポンス処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | destroy.js.haml | `app/views/contacts/destroy.js.haml` | AJAX削除時のJSレスポンス |

**主要処理フロー**:
- 削除された連絡先要素のDOM削除
- 一覧ページからの呼び出し時とそれ以外での分岐処理

### プログラム呼び出し階層図

```
ContactsController#destroy
    │
    ├─ EntitiesController (継承)
    │      └─ load_and_authorize_resource
    │
    ├─ Contact#destroy
    │      ├─ UPDATE contacts (deleted_at設定)
    │      ├─ DELETE tasks (dependent: :destroy)
    │      ├─ DELETE account_contacts (dependent: :destroy)
    │      └─ DELETE contact_opportunities (dependent: :destroy)
    │
    └─ respond_to_destroy
           ├─ :html -> flash設定、redirect_to contacts_path
           └─ :ajax -> called_from_index_page?による分岐
                       ├─ index -> get_contacts、一覧更新
                       └─ other -> current_page = 1
```

### データフロー図

```
[入力]               [処理]                    [出力]

連絡先ID ─────────▶ ContactsController#destroy ───▶ リダイレクト/JSレスポンス
                          │
                          ├─▶ Contact#destroy
                          │     ├─▶ contacts UPDATE (deleted_at)
                          │     ├─▶ tasks DELETE
                          │     ├─▶ account_contacts DELETE
                          │     └─▶ contact_opportunities DELETE
                          │
                          └─▶ respond_to_destroy
                                ├─▶ HTML: リダイレクト
                                └─▶ JS: DOM更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| contacts_controller.rb | `app/controllers/entities/contacts_controller.rb` | コントローラー | 連絡先関連アクションの処理 |
| entities_controller.rb | `app/controllers/entities_controller.rb` | コントローラー | エンティティ共通処理 |
| contact.rb | `app/models/entities/contact.rb` | モデル | 連絡先エンティティ定義 |
| destroy.js.haml | `app/views/contacts/destroy.js.haml` | ビュー | 削除完了用JSテンプレート |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
