# 機能設計書 35-タスク詳細表示

## 概要

本ドキュメントは、Fat Free CRMシステムにおける「タスク詳細表示」機能の設計を定義する。個別のタスクの詳細情報を表示するための機能である。

### 本機能の処理概要

タスク詳細表示機能は、特定のタスクの完全な情報を確認するための機能である。

**業務上の目的・背景**：タスク一覧では概要情報のみが表示されるため、タスクの詳細な内容（背景情報、関連エンティティ、担当者情報など）を確認する際に本機能を使用する。特に、関連するエンティティ（取引先、連絡先、商談など）へのナビゲーションが可能となり、タスクのコンテキストを理解しやすくなる。

**機能の利用シーン**：タスクの詳細内容を確認する場合、関連エンティティへ移動する場合、タスクの背景情報を確認する場合、タスクの割り当て状況を確認する場合。

**主要な処理内容**：
1. タスクIDによるレコード取得
2. ユーザーがトラック可能なタスクかの確認
3. タスク詳細情報の表示

**関連システム・外部連携**：タスクは取引先、連絡先、リード、商談、キャンペーンなどのエンティティに紐付け可能（ポリモーフィック関連）。

**権限による制御**：ユーザーは自分が作成したタスク、または自分に割り当てられたタスクのみ詳細を表示可能（tracked_byスコープ）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | タスク一覧画面 | 参照画面 | 一覧からの詳細表示遷移 |

## 機能種別

CRUD操作（Read） / データ表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | タスクID | 存在チェック、アクセス権チェック |

### 入力データソース

- URLパラメータ（タスクID）
- セッション情報（current_user）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @task | Task | タスクオブジェクト |

### 出力先

- 画面表示（HTML/JS）

## 処理フロー

### 処理シーケンス

```
1. showリクエスト受信
   └─ GET /tasks/:id
2. タスクの取得
   └─ Task.tracked_by(current_user).find(params[:id])
3. 詳細情報の表示
   └─ respond_with(@task)
```

### フローチャート

```mermaid
flowchart TD
    A[詳細表示リクエスト] --> B[タスク取得]
    B --> C{追跡可能?}
    C -->|No| D[404エラー]
    C -->|Yes| E[詳細表示]
    E --> F[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-01 | 追跡可能条件 | user_id = current_user OR assigned_to = current_user | 常時 |
| BR-35-02 | 関連エンティティ表示 | タスクに紐付くエンティティ（asset）の情報を表示 | asset_id存在時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| タスク取得 | tasks | SELECT | 指定IDのタスク取得 |
| 担当者取得 | users | SELECT | assigneeの取得（includes） |

### テーブル別操作詳細

#### tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | id = params[:id] AND (user_id = current_user OR assigned_to = current_user) | tracked_byスコープ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | Not Found | 指定IDのタスクが存在しない、またはアクセス権がない | エラー画面表示 |

### リトライ仕様

特になし。

## トランザクション仕様

読み取り専用のため、トランザクション制御は不要。

## パフォーマンス要件

- ページ表示: 500ミリ秒以内
- includes(:assignee)によるN+1問題の回避

## セキュリティ考慮事項

- tracked_byスコープにより、ユーザーは自分に関連するタスクのみ表示可能
- 他ユーザーのタスクは表示不可（自分が割り当てた場合を除く）
- XSS対策（出力時のエスケープ）

## 備考

- タスクの関連エンティティ（asset）はポリモーフィック関連で実装
- asset_type に "Account"、"Contact"、"Lead"、"Opportunity"、"Campaign" のいずれかが設定される
- 詳細表示は主にAPI/XMLアクセス用に使用される（一覧画面から直接編集が多い）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タスクモデルのtracked_byスコープとポリモーフィック関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task.rb | `app/models/polymorphic/task.rb` | tracked_byスコープとasset関連 |

**読解のコツ**:
- **40行目**: `belongs_to :asset, polymorphic: true, optional: true` - ポリモーフィック関連
- **66-69行目**: `tracked_by` スコープ - user_id OR assigned_to でフィルタ
- **143-146行目**: `tracked_by?` メソッド - 追跡可能かの判定

#### Step 2: エントリーポイントを理解する

TasksControllerのshowアクションが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tasks_controller.rb | `app/controllers/tasks_controller.rb` | showアクションの実装 |

**主要処理フロー**:
1. **25-30行目**: showアクション全体
2. **28行目**: `Task.tracked_by(current_user).find(params[:id])` - 追跡可能なタスクを取得
3. **29行目**: `respond_with(@task)` - 応答

### プログラム呼び出し階層図

```
TasksController#show
    │
    ├─ Task.tracked_by(current_user)
    │      └─ includes(:assignee)
    │             .where('user_id = ? OR assigned_to = ?', user.id, user.id)
    │
    ├─ find(params[:id])
    │      └─ SELECT * FROM tasks WHERE id = ? AND (user_id = ? OR assigned_to = ?)
    │
    └─ respond_with(@task)
           └─ format dependent rendering
```

### データフロー図

```
[入力]                      [処理]                           [出力]

GET /tasks/:id         TasksController#show
                               │
                               ▼
                       tracked_by(current_user)
                               │
                               ▼
                       find(params[:id])
                               │
                               ▼
                           @task
                               │
                               ▼
                       respond_with
                               │
                    ┌──────────┴──────────┐
                    ▼                     ▼
              HTML表示               XML/JSON応答
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tasks_controller.rb | `app/controllers/tasks_controller.rb` | コントローラ | showアクション |
| task.rb | `app/models/polymorphic/task.rb` | モデル | tracked_byスコープ |
| routes.rb | `config/routes.rb` | 設定 | GET /tasks/:id ルーティング |
