# 機能設計書 42-コメント一覧表示

## 概要

本ドキュメントは、Fat Free CRMのコメント一覧表示機能（CommentsController#index）の設計仕様を定義するものである。

### 本機能の処理概要

コメント一覧表示機能は、取引先・キャンペーン・リード・連絡先・商談などのエンティティに紐付くコメントを一覧形式で取得・表示する機能である。

**業務上の目的・背景**：CRMシステムにおいて、顧客や商談に関するコミュニケーション履歴を追跡することは極めて重要である。コメント機能により、チームメンバー間で情報共有が可能になり、顧客対応の経緯を把握できる。また、メンション機能（@username）により特定のユーザーに通知することで、迅速なコラボレーションを実現する。

**機能の利用シーン**：ユーザーがエンティティ詳細画面（取引先詳細、リード詳細など）を表示した際に、そのエンティティに関連するコメント履歴を確認する場面で利用される。API経由でのJSON/XML形式での取得も可能。

**主要な処理内容**：
1. リクエストパラメータからコメント対象のエンティティを特定
2. 対象エンティティへのアクセス権限を検証
3. エンティティに紐付くコメントを作成日時の降順で取得
4. 適切なフォーマット（HTML/JSON/XML）で応答

**関連システム・外部連携**：なし（内部処理のみ）

**権限による制御**：ユーザーは自分がアクセス可能なエンティティ（my scopeで絞り込み）に紐付くコメントのみ閲覧可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 取引先詳細画面 | 参照画面 | 取引先に紐付くコメント表示 |
| 12 | キャンペーン詳細画面 | 参照画面 | キャンペーンに紐付くコメント表示 |
| 16 | リード詳細画面 | 参照画面 | リードに紐付くコメント表示 |
| 21 | 連絡先詳細画面 | 参照画面 | 連絡先に紐付くコメント表示 |
| 25 | 商談詳細画面 | 参照画面 | 商談に紐付くコメント表示 |

## 機能種別

データ取得処理 / READ操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| {entity}_id | Integer | Yes | コメント対象エンティティのID（account_id, campaign_id等） | 存在するエンティティであること |

### 入力データソース

- URLパラメータ：ネストされたリソースパラメータ（例：/accounts/1/comments）
- データベース：commentsテーブル、関連エンティティテーブル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | コメントID |
| user_id | Integer | 作成者ユーザーID |
| commentable_id | Integer | 対象エンティティID |
| commentable_type | String | 対象エンティティ種別 |
| private | Boolean | プライベートフラグ |
| title | String | コメントタイトル |
| comment | Text | コメント本文 |
| state | String | 表示状態（Expanded/Collapsed） |
| created_at | DateTime | 作成日時 |
| updated_at | DateTime | 更新日時 |

### 出力先

- HTML形式：対象エンティティ詳細画面へリダイレクト
- JSON形式：JSONレスポンス
- XML形式：XMLレスポンス

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信・パラメータ解析
   └─ extract_commentable_nameでエンティティ種別を特定

2. 対象エンティティ取得
   └─ find_classでモデルクラスを取得
   └─ my(current_user)スコープでアクセス権限付きで検索

3. コメント一覧取得
   └─ @asset.comments.order("created_at DESC")で降順取得

4. レスポンス生成
   ├─ HTML形式：エンティティ詳細画面へリダイレクト
   ├─ JSON形式：コメント配列をJSON形式で返却
   └─ XML形式：コメント配列をXML形式で返却

5. エラー時（エンティティ未発見）
   └─ flash警告メッセージを設定
   └─ HTMLはルートへリダイレクト、JSON/XMLは404応答
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[エンティティ種別特定]
    B --> C[エンティティ取得]
    C --> D{アクセス権限あり?}
    D -->|No| E[RecordNotFound例外]
    D -->|Yes| F[コメント一覧取得]
    E --> G[flash警告設定]
    G --> H{フォーマット?}
    F --> I[レスポンス生成]
    I --> J{フォーマット?}
    H -->|HTML| K[ルートへリダイレクト]
    H -->|JSON/XML| L[404エラー応答]
    J -->|HTML| M[エンティティ詳細へリダイレクト]
    J -->|JSON/XML| N[データ返却]
    K --> O[終了]
    L --> O
    M --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-42-01 | アクセス制御 | ユーザーは自分がアクセス可能なエンティティのコメントのみ閲覧可能 | 常時 |
| BR-42-02 | 並び順 | コメントは作成日時の降順（新しい順）で表示 | 常時 |
| BR-42-03 | HTMLリダイレクト | HTML形式の場合は対象エンティティ詳細画面へリダイレクト | HTML形式リクエスト時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント取得 | comments | SELECT | エンティティに紐付くコメント一覧取得 |
| エンティティ取得 | accounts/campaigns/leads/contacts/opportunities | SELECT | 対象エンティティの存在確認とアクセス権限検証 |

### テーブル別操作詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | commentable_id = :entity_id AND commentable_type = :entity_type | ORDER BY created_at DESC |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | RecordNotFound | 対象エンティティが存在しないまたはアクセス権限なし | HTML:ルートへリダイレクト、API:404応答 |

### リトライ仕様

リトライ不要（即座にエラー応答）

## トランザクション仕様

読み取り専用のためトランザクション不要

## パフォーマンス要件

- コメント数が多い場合でも1秒以内に応答
- N+1クエリを避けるためeager loadingは未実装（要改善点）

## セキュリティ考慮事項

- 認証必須：ApplicationControllerで認証チェック
- アクセス制御：my(current_user)スコープでユーザーのアクセス可能なエンティティに限定
- XSS対策：ビューでのエスケープ処理

## 備考

- ポリモーフィック関連を使用しており、様々なエンティティに対してコメントを紐付け可能
- HTML形式でのアクセスは一覧ではなくエンティティ詳細へリダイレクトされる設計

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメントモデルの構造とポリモーフィック関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | comment.rb | `app/models/polymorphic/comment.rb` | スキーマ情報（9-22行目）、belongs_to関連（25-26行目） |

**読解のコツ**: Commentモデルはポリモーフィック関連（commentable）を持ち、様々なエンティティ（Account, Campaign, Lead, Contact, Opportunity）に紐付く。commentable_typeとcommentable_idで対象エンティティを特定する。

#### Step 2: エントリーポイントを理解する

indexアクションの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | comments_controller.rb | `app/controllers/comments_controller.rb` | indexアクション（13-29行目） |

**主要処理フロー**:
1. **14行目**: extract_commentable_nameでエンティティ種別を抽出
2. **15-17行目**: エンティティ取得とアクセス権限チェック
3. **17行目**: コメント一覧を作成日時降順で取得
4. **19-21行目**: レスポンス形式に応じた応答
5. **22-28行目**: RecordNotFound例外のハンドリング

#### Step 3: ヘルパーメソッドを理解する

エンティティ種別抽出のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | comments_controller.rb | `app/controllers/comments_controller.rb` | extract_commentable_nameメソッド（99-101行目） |

**主要処理フロー**:
- **100行目**: パラメータキーから`_id`で終わるものを検出し、`_id`を除去してエンティティ名を取得

### プログラム呼び出し階層図

```
CommentsController#index
    │
    ├─ extract_commentable_name (private method)
    │      └─ パラメータからエンティティ種別を抽出
    │
    ├─ find_class (inherited from ApplicationController)
    │      └─ 文字列からモデルクラスを取得
    │
    └─ respond_with
           ├─ HTML: redirect_to @asset
           ├─ JSON: コメント配列をJSON形式で返却
           └─ XML: コメント配列をXML形式で返却
```

### データフロー図

```
[入力]                        [処理]                           [出力]

URLパラメータ ───▶ CommentsController#index ───▶ レスポンス
  └─ entity_id            │                             │
                           ├─ エンティティ取得            ├─ HTML: リダイレクト
                           ├─ アクセス権限チェック         ├─ JSON: コメント配列
                           └─ コメント一覧取得            └─ XML: コメント配列
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| comments_controller.rb | `app/controllers/comments_controller.rb` | コントローラー | indexアクション、ヘルパーメソッド |
| comment.rb | `app/models/polymorphic/comment.rb` | モデル | Commentモデル、ポリモーフィック関連定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング設定（41行目） |
