# 機能設計書 44-コメント編集

## 概要

本ドキュメントは、Fat Free CRMのコメント編集機能（CommentsController#edit, #update）の設計仕様を定義するものである。

### 本機能の処理概要

コメント編集機能は、既存のコメントの内容を修正・更新する機能である。editアクションで編集フォームを表示し、updateアクションで変更内容を保存する。

**業務上の目的・背景**：CRMシステムにおいて、記録したコメントに誤りがあった場合や、追加情報が発生した場合に内容を修正する必要がある。コメント編集機能により、ユーザーは過去のコメントを適切に更新し、正確な情報を維持できる。

**機能の利用シーン**：ユーザーがエンティティ詳細画面でコメント一覧を確認し、既存コメントの「編集」リンクをクリックして内容を修正する場面で利用される。誤字脱字の修正、情報の追記、表現の改善などに使用される。

**主要な処理内容**：
1. 【edit】コメントIDから対象コメントを取得
2. 【edit】対象エンティティへのアクセス権限を検証
3. 【edit】編集フォームをAJAXで表示
4. 【update】更新パラメータを受信してコメントを更新
5. 【update】更新結果をAJAXで応答

**関連システム・外部連携**：なし（内部処理のみ）

**権限による制御**：ユーザーは自分がアクセス可能なエンティティ（my scopeで絞り込み）に紐付くコメントのみ編集可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 取引先詳細画面 | 主画面 | 取引先に紐付くコメント編集 |
| 12 | キャンペーン詳細画面 | 主画面 | キャンペーンに紐付くコメント編集 |
| 16 | リード詳細画面 | 主画面 | リードに紐付くコメント編集 |
| 21 | 連絡先詳細画面 | 主画面 | 連絡先に紐付くコメント編集 |
| 25 | 商談詳細画面 | 主画面 | 商談に紐付くコメント編集 |

## 機能種別

データ更新処理 / UPDATE操作

## 入力仕様

### 入力パラメータ

#### editアクション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | 編集対象コメントのID | 存在するコメントであること |
| cancel | String | No | キャンセルフラグ | "true"でキャンセル処理 |

#### updateアクション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | 更新対象コメントのID | 存在するコメントであること |
| comment[comment] | Text | Yes | コメント本文 | 空でないこと |
| comment[private] | Boolean | No | プライベートフラグ | true/false |
| comment[title] | String | No | コメントタイトル | - |

### 入力データソース

- URLパラメータ：コメントID
- 画面入力：編集フォーム

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @comment | Comment | 編集対象コメントオブジェクト |

### 出力先

- 画面表示：AJAXレスポンスで編集フォームまたは更新後のコメント表示

## 処理フロー

### 処理シーケンス

```
【editアクション】
1. コメント取得
   └─ Comment.find(params[:id])でコメントを取得

2. アクセス権限検証
   └─ find_classでモデルクラス取得
   └─ my(current_user)スコープで検索

3. キャンセル処理判定
   ├─ cancel=true: 元のコメント表示に戻る
   └─ cancel=false: 編集フォームを表示

【updateアクション】
1. コメント取得
   └─ Comment.find(params[:id])

2. コメント更新
   └─ @comment.update(comment_params)

3. レスポンス生成
   └─ update.js.hamlでJavaScript応答
```

### フローチャート

```mermaid
flowchart TD
    subgraph editアクション
        A1[編集リクエスト受信] --> B1[コメント取得]
        B1 --> C1[アクセス権限チェック]
        C1 --> D1{権限あり?}
        D1 -->|No| E1[エラー応答]
        D1 -->|Yes| F1{cancel=true?}
        F1 -->|Yes| G1[元のコメント表示]
        F1 -->|No| H1[編集フォーム表示]
    end

    subgraph updateアクション
        A2[更新リクエスト受信] --> B2[コメント取得]
        B2 --> C2[コメント更新]
        C2 --> D2{更新成功?}
        D2 -->|Yes| E2[更新後コメント表示]
        D2 -->|No| F2[エラー表示]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | アクセス制御 | ユーザーは自分がアクセス可能なエンティティに紐付くコメントのみ編集可能 | 常時 |
| BR-44-02 | 変更履歴記録 | コメント更新時にpaper_trailで変更履歴を記録 | 更新時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント取得 | comments | SELECT | 対象コメント取得 |
| コメント更新 | comments | UPDATE | コメント内容更新 |
| バージョン履歴 | versions | INSERT | 変更履歴レコード作成（paper_trail） |

### テーブル別操作詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = :comment_id | 対象コメント取得 |
| UPDATE | comment | params[:comment][:comment] | コメント本文 |
| UPDATE | private | params[:comment][:private] | プライベートフラグ |
| UPDATE | title | params[:comment][:title] | タイトル |
| UPDATE | updated_at | 現在時刻 | 自動更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RecordNotFound | 対象コメントが存在しない | 404エラー応答 |
| - | アクセス権限エラー | 対象エンティティにアクセス権限なし | エラーメッセージ表示 |
| - | バリデーションエラー | コメント本文が空 | 入力フォームにエラー表示 |

### リトライ仕様

リトライ不要（ユーザーが再入力して再送信）

## トランザクション仕様

コメント更新はActiveRecordのデフォルトトランザクションで実行

## パフォーマンス要件

- 編集フォーム表示は500ms以内に応答
- 更新処理は500ms以内に応答

## セキュリティ考慮事項

- 認証必須：ApplicationControllerで認証チェック
- アクセス制御：my(current_user)スコープでユーザーのアクセス可能なエンティティに限定
- パラメータサニタイズ：Strong Parametersで許可パラメータを制限
- XSS対策：ビューでのエスケープ処理

## 備考

- 編集フォームはインライン表示され、既存コメントを置き換える形式
- キャンセル時は元のコメント表示に戻る

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメントモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | comment.rb | `app/models/polymorphic/comment.rb` | スキーマ情報（9-22行目）、バリデーション（30行目） |

**読解のコツ**: Commentモデルはuser, commentable, commentの3つが必須バリデーション対象。

#### Step 2: エントリーポイントを理解する

edit/updateアクションの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | comments_controller.rb | `app/controllers/comments_controller.rb` | editアクション（33-39行目） |
| 2-2 | comments_controller.rb | `app/controllers/comments_controller.rb` | updateアクション（64-68行目） |

**主要処理フロー**:
1. **34行目**: Comment.findでコメント取得
2. **36-38行目**: アクセス権限チェック
3. **65行目**: Comment.findでコメント取得
4. **66行目**: updateメソッドでコメント更新

#### Step 3: ビューレスポンスを理解する

JavaScript応答の生成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.js.haml | `app/views/comments/edit.js.haml` | 編集フォーム表示/キャンセル処理（1-11行目） |
| 3-2 | update.js.haml | `app/views/comments/update.js.haml` | 更新後の表示（存在する場合） |

**主要処理フロー**:
- **3行目**: cancel=trueの場合、元のコメント表示に戻す
- **10行目**: 編集フォームをインラインで表示

### プログラム呼び出し階層図

```
CommentsController#edit
    │
    ├─ Comment.find
    │      └─ コメント取得
    │
    ├─ find_class
    │      └─ モデルクラス取得
    │
    └─ my(current_user).find_by_id
           └─ アクセス権限チェック

CommentsController#update
    │
    ├─ Comment.find
    │      └─ コメント取得
    │
    └─ @comment.update(comment_params)
           └─ コメント更新
```

### データフロー図

```
[入力]                        [処理]                           [出力]

【edit】
コメントID ───▶ CommentsController#edit ───▶ JavaScript応答
                    │                              └─ 編集フォーム表示
                    ├─ コメント取得
                    └─ アクセス権限チェック

【update】
編集フォーム ───▶ CommentsController#update ───▶ データベース
  └─ comment             │                         └─ comments
                          ├─ コメント取得
                          └─ コメント更新          ───▶ JavaScript応答
                                                        └─ 更新後コメント表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| comments_controller.rb | `app/controllers/comments_controller.rb` | コントローラー | edit/updateアクション |
| comment.rb | `app/models/polymorphic/comment.rb` | モデル | Commentモデル |
| edit.js.haml | `app/views/comments/edit.js.haml` | ビュー | 編集フォーム表示JavaScript |
| update.js.haml | `app/views/comments/update.js.haml` | ビュー | 更新後表示JavaScript |
| _edit.html.haml | `app/views/comments/_edit.html.haml` | ビュー | 編集フォームパーシャル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング設定（41行目） |
