# 機能設計書 45-コメント削除

## 概要

本ドキュメントは、Fat Free CRMのコメント削除機能（CommentsController#destroy）の設計仕様を定義するものである。

### 本機能の処理概要

コメント削除機能は、エンティティに紐付く既存のコメントを削除する機能である。削除はAJAXで実行され、画面上から該当コメントがスライドアウトアニメーションで消去される。

**業務上の目的・背景**：CRMシステムにおいて、誤って作成されたコメントや不要になった情報を削除する必要がある。コメント削除機能により、ユーザーは不要なコメントを整理し、情報の正確性と可読性を維持できる。

**機能の利用シーン**：ユーザーがエンティティ詳細画面でコメント一覧を確認し、削除したいコメントの「削除」リンクをクリックしてコメントを削除する場面で利用される。誤入力の訂正、古い情報の整理などに使用される。

**主要な処理内容**：
1. コメントIDから対象コメントを取得
2. コメントをデータベースから削除
3. 削除結果をAJAXで応答（スライドアウトアニメーション）

**関連システム・外部連携**：なし（内部処理のみ）

**権限による制御**：認証済みユーザーのみアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 取引先詳細画面 | 主画面 | 取引先に紐付くコメント削除 |
| 12 | キャンペーン詳細画面 | 主画面 | キャンペーンに紐付くコメント削除 |
| 16 | リード詳細画面 | 主画面 | リードに紐付くコメント削除 |
| 21 | 連絡先詳細画面 | 主画面 | 連絡先に紐付くコメント削除 |
| 25 | 商談詳細画面 | 主画面 | 商談に紐付くコメント削除 |

## 機能種別

データ削除処理 / DELETE操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | 削除対象コメントのID | 存在するコメントであること |

### 入力データソース

- URLパラメータ：コメントID

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @comment | Comment | 削除対象コメントオブジェクト |

### 出力先

- データベース：commentsテーブルから該当レコード削除
- 画面表示：AJAXレスポンスで該当コメントをスライドアウト

## 処理フロー

### 処理シーケンス

```
1. 削除リクエスト受信
   └─ params[:id]でコメントIDを取得

2. コメント取得
   └─ Comment.find(params[:id])

3. コメント削除
   └─ @comment.destroy

4. レスポンス生成
   └─ destroy.js.hamlでJavaScript応答
   └─ shown_notesの更新
   └─ DOM要素のスライドアウトアニメーション
```

### フローチャート

```mermaid
flowchart TD
    A[削除リクエスト受信] --> B[コメント取得]
    B --> C{コメント存在?}
    C -->|No| D[RecordNotFound例外]
    C -->|Yes| E[コメント削除]
    E --> F[JavaScript応答生成]
    F --> G[shown_notes更新]
    G --> H[スライドアウトアニメーション]
    D --> I[エラー応答]
    H --> J[終了]
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 物理削除 | コメントはデータベースから物理削除される | 常時 |
| BR-45-02 | 関連更新 | 削除後、エンティティのshown_notes（表示中コメントID一覧）を更新 | 削除成功時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント取得 | comments | SELECT | 対象コメント取得 |
| コメント削除 | comments | DELETE | コメントレコード削除 |

### テーブル別操作詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = :comment_id | 対象コメント取得 |
| DELETE | - | id = :comment_id | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RecordNotFound | 対象コメントが存在しない | 404エラー応答 |

### リトライ仕様

リトライ不要

## トランザクション仕様

削除処理はActiveRecordのデフォルトトランザクションで実行

## パフォーマンス要件

- 削除処理は500ms以内に応答

## セキュリティ考慮事項

- 認証必須：ApplicationControllerで認証チェック
- XSS対策：JavaScriptテンプレートでjヘルパーを使用

## 備考

- 削除はソフトデリート（論理削除）ではなく物理削除
- スライドアウトアニメーションで視覚的フィードバックを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメントモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | comment.rb | `app/models/polymorphic/comment.rb` | スキーマ情報（9-22行目）、ポリモーフィック関連（26行目） |

**読解のコツ**: Commentモデルはcommentable関連を持ち、削除時にはこの関連を通じて親エンティティにアクセスする。

#### Step 2: エントリーポイントを理解する

destroyアクションの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | comments_controller.rb | `app/controllers/comments_controller.rb` | destroyアクション（74-78行目） |

**主要処理フロー**:
1. **75行目**: Comment.findでコメント取得
2. **76行目**: destroyメソッドでコメント削除
3. **77行目**: respond_withでレスポンス生成

#### Step 3: ビューレスポンスを理解する

JavaScript応答の生成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | destroy.js.haml | `app/views/comments/destroy.js.haml` | DOM操作（1-5行目） |

**主要処理フロー**:
- **1-2行目**: クラス名とIDプレフィックスの生成
- **4行目**: shown_notesの更新
- **5行目**: スライドアウトアニメーション（背景色変更後に250msでスライドアップ）

### プログラム呼び出し階層図

```
CommentsController#destroy
    │
    ├─ Comment.find
    │      └─ コメント取得
    │
    └─ @comment.destroy
           └─ コメント削除（ActiveRecord）
```

### データフロー図

```
[入力]                        [処理]                           [出力]

コメントID ───▶ CommentsController#destroy ───▶ データベース
                    │                               └─ DELETE from comments
                    ├─ コメント取得
                    └─ コメント削除               ───▶ JavaScript応答
                                                        ├─ shown_notes更新
                                                        └─ スライドアウト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| comments_controller.rb | `app/controllers/comments_controller.rb` | コントローラー | destroyアクション |
| comment.rb | `app/models/polymorphic/comment.rb` | モデル | Commentモデル |
| destroy.js.haml | `app/views/comments/destroy.js.haml` | ビュー | 削除後のJavaScript応答 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング設定（41行目） |
