# 機能設計書 46-メール削除

## 概要

本ドキュメントは、Fat Free CRMのメール削除機能（EmailsController#destroy）の設計仕様を定義するものである。

### 本機能の処理概要

メール削除機能は、エンティティに関連付けられたメールレコードを削除する機能である。Fat Free CRMでは、IMAPやDropboxメール連携機能により取り込まれたメールがエンティティに紐付けられるが、この機能により不要なメールを削除できる。

**業務上の目的・背景**：CRMシステムにおいて、顧客とのメールコミュニケーション履歴を管理することは重要である。しかし、誤って関連付けられたメールや不要なメールを整理する必要もある。メール削除機能により、ユーザーはエンティティに関連付けられたメールを適切に管理できる。

**機能の利用シーン**：ユーザーがエンティティ詳細画面でメール一覧を確認し、削除したいメールの「削除」リンクをクリックしてメールを削除する場面で利用される。誤って関連付けられたメールの解除、古いメールの整理などに使用される。

**主要な処理内容**：
1. メールIDから対象メールを取得
2. メールをデータベースから削除
3. 削除結果をAJAXで応答

**関連システム・外部連携**：なし（内部処理のみ。メール取り込みは別機能）

**権限による制御**：認証済みユーザーのみアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 取引先詳細画面 | 参照画面 | メール削除（タイムライン表示からの削除） |
| 12 | キャンペーン詳細画面 | 参照画面 | メール削除（タイムライン表示からの削除） |
| 16 | リード詳細画面 | 参照画面 | メール削除（タイムライン表示からの削除） |
| 21 | 連絡先詳細画面 | 参照画面 | メール削除（タイムライン表示からの削除） |
| 25 | 商談詳細画面 | 参照画面 | メール削除（タイムライン表示からの削除） |

## 機能種別

データ削除処理 / DELETE操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | 削除対象メールのID | 存在するメールであること |

### 入力データソース

- URLパラメータ：メールID

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @email | Email | 削除対象メールオブジェクト |

### 出力先

- データベース：emailsテーブルから該当レコード削除
- 画面表示：AJAXレスポンスで削除結果を反映

## 処理フロー

### 処理シーケンス

```
1. 削除リクエスト受信
   └─ params[:id]でメールIDを取得

2. メール取得
   └─ Email.find(params[:id])

3. メール削除
   └─ @email.destroy

4. レスポンス生成
   └─ respond_withでJSON/XML/JS応答
```

### フローチャート

```mermaid
flowchart TD
    A[削除リクエスト受信] --> B[メール取得]
    B --> C{メール存在?}
    C -->|No| D[RecordNotFound例外]
    C -->|Yes| E[メール削除]
    E --> F[レスポンス生成]
    D --> G[エラー応答]
    F --> H[終了]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | 物理削除 | メールはデータベースから物理削除される | 常時 |
| BR-46-02 | 変更履歴 | 削除時にpaper_trailで変更履歴を記録 | 削除時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メール取得 | emails | SELECT | 対象メール取得 |
| メール削除 | emails | DELETE | メールレコード削除 |
| バージョン履歴 | versions | INSERT | 変更履歴レコード作成（paper_trail） |

### テーブル別操作詳細

#### emails

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = :email_id | 対象メール取得 |
| DELETE | - | id = :email_id | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RecordNotFound | 対象メールが存在しない | 404エラー応答 |

### リトライ仕様

リトライ不要

## トランザクション仕様

削除処理はActiveRecordのデフォルトトランザクションで実行

## パフォーマンス要件

- 削除処理は500ms以内に応答

## セキュリティ考慮事項

- 認証必須：ApplicationControllerで認証チェック
- XSS対策：ビューでのエスケープ処理

## 備考

- Emailモデルはmediator（ポリモーフィック関連）を通じて各エンティティに紐付く
- メールにはstate属性があり、Expanded/Collapsedで表示状態を管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | email.rb | `app/models/polymorphic/email.rb` | スキーマ情報（9-30行目）、ポリモーフィック関連（33-34行目） |

**読解のコツ**: Emailモデルはmediator関連を持ち、Account, Campaign, Lead, Contact, Opportunityなど様々なエンティティに紐付く。stateフィールドで表示状態（Expanded/Collapsed）を管理している。

#### Step 2: エントリーポイントを理解する

destroyアクションの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | emails_controller.rb | `app/controllers/emails_controller.rb` | destroyアクション（13-17行目） |

**主要処理フロー**:
1. **14行目**: Email.findでメール取得
2. **15行目**: destroyメソッドでメール削除
3. **16行目**: respond_withでレスポンス生成

### プログラム呼び出し階層図

```
EmailsController#destroy
    │
    ├─ Email.find
    │      └─ メール取得
    │
    └─ @email.destroy
           └─ メール削除（ActiveRecord）
                  └─ paper_trail: バージョン履歴記録
```

### データフロー図

```
[入力]                        [処理]                           [出力]

メールID ───▶ EmailsController#destroy ───▶ データベース
                    │                           ├─ DELETE from emails
                    ├─ メール取得                └─ INSERT into versions
                    └─ メール削除
                                              ───▶ レスポンス
                                                   └─ JSON/XML/JS応答
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| emails_controller.rb | `app/controllers/emails_controller.rb` | コントローラー | destroyアクション |
| email.rb | `app/models/polymorphic/email.rb` | モデル | Emailモデル、ポリモーフィック関連 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング設定（42行目） |
