# 機能設計書 47-ユーザープロファイル表示

## 概要

本ドキュメントは、Fat Free CRMのユーザープロファイル表示機能（UsersController#show）の設計仕様を定義するものである。

### 本機能の処理概要

ユーザープロファイル表示機能は、ユーザーの個人情報（名前、連絡先、会社情報、アバターなど）を表示する機能である。自分自身のプロファイルまたは他のユーザーのプロファイルを閲覧できる。

**業務上の目的・背景**：CRMシステムにおいて、チームメンバーの情報を確認することは重要である。ユーザープロファイル表示機能により、ユーザーは自分の登録情報を確認したり、他のチームメンバーの連絡先や所属を確認したりできる。

**機能の利用シーン**：ユーザーがナビゲーションバーの「プロファイル」リンクをクリックして自分の情報を確認する場面、または他のユーザーのアバターや名前をクリックしてそのユーザーの情報を確認する場面で利用される。

**主要な処理内容**：
1. URLパラメータまたはセッションから対象ユーザーIDを取得
2. 権限チェック（CanCanCan）を実行
3. ユーザー情報を取得して表示

**関連システム・外部連携**：なし（内部処理のみ）

**権限による制御**：CanCanCanで権限管理。自分のプロファイルは常に閲覧可能。他ユーザーのプロファイルはアクセス権限に応じて閲覧可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザー一覧画面 | 参照画面 | ユーザー一覧からの詳細表示遷移 |
| 32 | ユーザー詳細画面（プロフィール） | 主画面 | ユーザーのプロフィール情報表示 |

## 機能種別

データ取得処理 / READ操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | No | 表示対象ユーザーのID（省略時はcurrent_user） | 存在するユーザーであること |

### 入力データソース

- URLパラメータ：ユーザーID（省略可能）
- セッション：current_user（IDが省略された場合）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | ユーザーID |
| username | String | ユーザー名 |
| email | String | メールアドレス |
| first_name | String | 名 |
| last_name | String | 姓 |
| title | String | 役職 |
| company | String | 会社名 |
| alt_email | String | 代替メールアドレス |
| phone | String | 電話番号 |
| mobile | String | 携帯電話番号 |
| aim | String | AIM ID |
| yahoo | String | Yahoo ID |
| google | String | Google ID |
| avatar | Avatar | アバター画像 |

### 出力先

- 画面表示：ユーザープロファイルページ

## 処理フロー

### 処理シーケンス

```
1. プロファイル表示リクエスト受信
   └─ params[:id]でユーザーIDを取得

2. ユーザーID判定
   ├─ IDが指定されている場合：指定ユーザーを取得
   └─ IDが未指定の場合：current_userを使用

3. 権限チェック
   └─ CanCanCanのload_and_authorize_resourceで自動チェック

4. レスポンス生成
   └─ show.html.hamlでプロファイル表示
```

### フローチャート

```mermaid
flowchart TD
    A[表示リクエスト受信] --> B{IDパラメータあり?}
    B -->|No| C[current_userを使用]
    B -->|Yes| D[指定ユーザーを取得]
    C --> E[権限チェック]
    D --> E
    E --> F{権限あり?}
    F -->|No| G[アクセス拒否]
    F -->|Yes| H[プロファイル表示]
    G --> I[終了]
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | デフォルトユーザー | IDパラメータが未指定の場合、current_userのプロファイルを表示 | ID未指定時 |
| BR-47-02 | 権限チェック | CanCanCanで閲覧権限をチェック | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー取得 | users | SELECT | 対象ユーザー情報取得 |
| アバター取得 | avatars | SELECT | ユーザーのアバター画像取得 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id = :user_id | 対象ユーザー取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RecordNotFound | 対象ユーザーが存在しない | 404エラー応答 |
| - | CanCan::AccessDenied | アクセス権限なし | 403エラー応答 |

### リトライ仕様

リトライ不要

## トランザクション仕様

読み取り専用のためトランザクション不要

## パフォーマンス要件

- 表示処理は500ms以内に応答

## セキュリティ考慮事項

- 認証必須：ApplicationControllerで認証チェック
- 権限管理：CanCanCanで詳細な権限制御
- XSS対策：ビューでのエスケープ処理

## 備考

- /profileへのアクセスは自動的に現在のユーザーのプロファイルを表示
- アバター画像はGravatarまたはアップロード画像を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | スキーマ情報（9-46行目）、関連定義（53-65行目） |

**読解のコツ**: Userモデルは多くの関連（avatar, accounts, campaigns, leads, contacts, opportunities等）を持つ。Deviseを使用した認証機能も含まれている。

#### Step 2: エントリーポイントを理解する

showアクションの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | users_controller.rb | `app/controllers/users_controller.rb` | showアクション（20-23行目） |
| 2-2 | users_controller.rb | `app/controllers/users_controller.rb` | load_and_authorize_resource（13行目） |

**主要処理フロー**:
1. **13行目**: load_and_authorize_resourceで自動的にユーザー取得と権限チェック
2. **21行目**: IDがnilの場合、current_userを使用
3. **22行目**: respond_withでレスポンス生成

#### Step 3: ビューを理解する

プロファイル表示のビューを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/users/show.html.haml` | プロファイルページ構造（1-15行目） |
| 3-2 | _user.html.haml | `app/views/users/_user.html.haml` | ユーザー情報パーシャル |

**主要処理フロー**:
- **2-5行目**: 編集、アバター変更、パスワード変更へのリンク表示
- **6行目**: タイトル表示（自分のプロファイル or プロファイル）
- **11行目**: _userパーシャルでユーザー情報表示

### プログラム呼び出し階層図

```
UsersController#show
    │
    ├─ load_and_authorize_resource (CanCanCan)
    │      ├─ User.find (or current_user)
    │      └─ authorize! :read, @user
    │
    └─ respond_with(@user)
           └─ show.html.haml
                  └─ _user.html.haml
```

### データフロー図

```
[入力]                        [処理]                           [出力]

ユーザーID ───▶ UsersController#show ───▶ 画面表示
(or current_user)      │                       └─ プロファイルページ
                        ├─ 権限チェック
                        └─ ユーザー取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| users_controller.rb | `app/controllers/users_controller.rb` | コントローラー | showアクション |
| user.rb | `app/models/users/user.rb` | モデル | Userモデル |
| show.html.haml | `app/views/users/show.html.haml` | ビュー | プロファイルページ |
| _user.html.haml | `app/views/users/_user.html.haml` | ビュー | ユーザー情報パーシャル |
| _profile.html.haml | `app/views/users/_profile.html.haml` | ビュー | 編集フォームパーシャル |
| ability.rb | `app/models/users/ability.rb` | モデル | CanCanCan権限定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング設定（155-163行目） |
