# 機能設計書 53-ログアウト

## 概要

本ドキュメントは、Fat Free CRMにおけるユーザーログアウト機能の設計書である。Deviseライブラリを利用したセッション終了処理について、処理仕様・セキュリティ・コード構造を定義する。

### 本機能の処理概要

ログイン済みユーザーがシステムからログアウトし、セッションを終了する機能である。ログアウト後はログイン画面にリダイレクトされる。

**業務上の目的・背景**：CRMシステムには機密情報が含まれるため、業務終了時やデバイスを離れる際にセッションを明示的に終了できる必要がある。共有PCでの利用時には特に重要な機能である。また、セキュリティポリシーによりログアウト操作が必須とされる場合もある。

**機能の利用シーン**：
- 業務終了時にシステムからログアウトする場面
- 共有PCでの作業終了時
- 別のアカウントでログインしたい場面
- セキュリティ上の理由でセッションを終了したい場面

**主要な処理内容**：
1. ユーザーがログアウトリンク/ボタンをクリック
2. DELETE /users/sign_outリクエストが送信される
3. Devise::SessionsController#destroyが呼び出される
4. セッションが破棄される
5. remember_meトークンがクリアされる
6. ログイン画面にリダイレクトされる

**関連システム・外部連携**：特になし

**権限による制御**：ログイン済みユーザーのみがログアウト可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全画面共通（ヘッダー） | 主機能 | ログアウトリンク |
| 1 | ログイン画面 | 遷移先画面 | ログアウト後のリダイレクト先 |

## 機能種別

認証処理 / セッション削除

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| _method | String | Yes | HTTPメソッドオーバーライド（"delete"） | DELETE |
| authenticity_token | String | Yes | CSRFトークン | 有効なトークン |

### 入力データソース

- ヘッダーメニューのログアウトリンク/ボタン

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フラッシュメッセージ | String | ログアウト成功メッセージ |

### 出力先

- HTTPセッション（クリア）
- ブラウザCookie（remember_meトークンクリア）

## 処理フロー

### 処理シーケンス

```
1. ユーザーがログアウトリンクをクリック
   └─ DELETE /users/sign_out へリクエスト送信
2. Devise::SessionsController#destroyが呼び出される
   └─ sign_out(current_user)
3. セッション破棄
   └─ Wardenがセッションをクリア
4. remember_meトークンをクリア
   └─ remember_tokenをNULLに更新
5. after_sign_out_path_for実行
   └─ SessionsController#after_sign_out_path_for
6. ログイン画面にリダイレクト
   └─ new_user_session_path
```

### フローチャート

```mermaid
flowchart TD
    A[ログアウトリンククリック] --> B[DELETE /users/sign_out]
    B --> C{ログイン中?}
    C -->|Yes| D[セッション破棄]
    C -->|No| F[ログイン画面へリダイレクト]
    D --> E[remember_meトークンクリア]
    E --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | 完全ログアウト | セッションとremember_meトークンの両方をクリアする | 常時 |
| BR-53-02 | リダイレクト先 | ログアウト後はログイン画面にリダイレクト | 常時 |
| BR-53-03 | CSRF検証 | ログアウト操作にはCSRFトークンが必要 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| トークンクリア | users | UPDATE | remember_tokenをNULLに更新 |
| セッション削除 | sessions | DELETE | セッションレコードを削除 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | remember_token | NULL | リマインバートークンクリア |
| UPDATE | remember_created_at | NULL | リマインバー作成日時クリア |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 422 | CSRFエラー | CSRFトークンが不正 | エラーページ表示 |

### リトライ仕様

特になし

## トランザクション仕様

単純なセッション破棄操作のため、特別なトランザクション制御は不要。

## パフォーマンス要件

- レスポンス時間: 500ms以内
- 単純なセッション破棄のみのため、負荷は軽微

## セキュリティ考慮事項

- CSRFトークン検証によりクロスサイトリクエストフォージェリを防止
- ログアウト時にセッションIDを完全に破棄（セッション乗っ取り防止）
- remember_meトークンもクリアして永続的な認証状態を解除

## 備考

- DeviseのSessionsControllerを継承してカスタマイズ
- ログアウト後のリダイレクト先はafter_sign_out_path_forでカスタマイズ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sessions_controller.rb | `app/controllers/sessions_controller.rb` | after_sign_out_path_forのオーバーライド |
| 1-2 | routes.rb | `config/routes.rb` | devise_forルーティング |

**主要処理フロー**:
1. **12-14行目（sessions_controller.rb）**: after_sign_out_path_forでログアウト後のリダイレクト先を指定
2. **17-20行目（routes.rb）**: devise_forでsessions: 'sessions'を指定

#### Step 2: Deviseの動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | user.rb | `app/models/users/user.rb` | rememberableモジュールの設定 |

**読解のコツ**: ログアウト処理の大部分はDeviseライブラリが担当するため、カスタマイズ部分（after_sign_out_path_for）に注目する。

### プログラム呼び出し階層図

```
ログアウトリンク（ヘッダー）
    │
    └─ DELETE /users/sign_out
           │
           └─ Devise::SessionsController#destroy
                  │
                  ├─ sign_out(current_user)
                  │      ├─ セッション破棄（Warden）
                  │      └─ remember_meトークンクリア
                  │
                  └─ redirect_to after_sign_out_path_for
                         └─ SessionsController#after_sign_out_path_for
                                └─ new_user_session_path
```

### データフロー図

```
[入力]               [処理]                    [出力]

ログアウト ───▶ SessionsController#destroy ───▶ セッション破棄
ボタン                  │                           │
                       │                           ▼
                       │                      sessionsテーブル
                       │                      usersテーブル
                       │                      （トークンクリア）
                       │
                       └─────────────────────▶ ログイン画面へ
                                                リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sessions_controller.rb | `app/controllers/sessions_controller.rb` | コントローラー | ログアウト後リダイレクト先指定 |
| user.rb | `app/models/users/user.rb` | モデル | rememberableモジュール |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
