# 機能設計書 55-パスワードリセット

## 概要

本ドキュメントは、Fat Free CRMにおけるパスワードリセット機能の設計書である。Deviseライブラリを利用したパスワードリカバリー処理について、処理仕様・セキュリティ・コード構造を定義する。

### 本機能の処理概要

パスワードを忘れたユーザーがメールアドレスを入力し、パスワードリセット用のリンクを受け取り、新しいパスワードを設定する機能である。2段階のプロセス（リセットメール送信、新パスワード設定）で構成される。

**業務上の目的・背景**：ユーザーがパスワードを忘れた場合、管理者に依存せずに自分でパスワードを再設定できることで、業務の中断を最小限に抑える。また、セキュリティ上の理由でパスワードを変更したい場合にも利用できる。

**機能の利用シーン**：
- パスワードを忘れてログインできない場面
- 長期休暇後にパスワードを思い出せない場面
- セキュリティ上の理由でパスワードを変更したい場面
- 不正アクセスの疑いがありパスワードを緊急変更したい場面

**主要な処理内容**：
1. パスワードリセット申請画面でメールアドレスを入力
2. システムがリセット用トークンを生成し、メールで送信
3. ユーザーがメール内のリンクをクリック
4. パスワードリセット画面で新しいパスワードを入力
5. パスワードが更新され、ログイン画面にリダイレクト

**関連システム・外部連携**：
- メール送信（パスワードリセットメール）：Action Mailer経由

**権限による制御**：未認証ユーザーが利用可能（パスワードを忘れた場合のため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | パスワードリセット申請画面 | 主画面 | メールアドレス入力、リセットメール送信 |
| 4 | パスワードリセット画面 | 主画面 | 新しいパスワード入力、パスワード変更 |

## 機能種別

パスワードリカバリー処理 / UPDATE操作

## 入力仕様

### 入力パラメータ（リセット申請）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| user[email] | String | Yes | メールアドレス | 必須、メール形式 |

### 入力パラメータ（パスワード変更）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| user[reset_password_token] | String | Yes | リセットトークン | 有効なトークン |
| user[password] | String | Yes | 新しいパスワード | 必須 |
| user[password_confirmation] | String | Yes | パスワード確認 | passwordと一致 |

### 入力データソース

- 画面入力（パスワードリセット申請フォーム、パスワード変更フォーム）
- メール内リンク（リセットトークン）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リセットメール | Email | パスワードリセット用リンクを含むメール |
| フラッシュメッセージ | String | 処理結果のメッセージ |

### 出力先

- メール（パスワードリセットメール）
- usersテーブル（パスワード更新）

## 処理フロー

### 処理シーケンス

```
【パスワードリセット申請】
1. パスワードリセット申請画面表示（GET /users/password/new）
   └─ Devise::PasswordsController#new
2. メールアドレスを入力してフォーム送信（POST /users/password）
   └─ Devise::PasswordsController#create
3. メールアドレスでユーザーを検索
   └─ 存在しない場合もセキュリティ上同じメッセージを表示
4. リセットトークン生成・保存
   └─ reset_password_token, reset_password_sent_atを更新
5. リセットメール送信
   └─ reset_password_instructionsメール
6. ログイン画面にリダイレクト

【パスワード変更】
1. メール内リンクをクリック（GET /users/password/edit?reset_password_token=xxx）
   └─ Devise::PasswordsController#edit
2. 新しいパスワードを入力してフォーム送信（PUT /users/password）
   └─ Devise::PasswordsController#update
3. トークン検証
   └─ 有効期限内かチェック
4. パスワード更新
   └─ encrypted_passwordを更新、トークンをクリア
5. ログイン画面にリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    subgraph 申請フロー
    A[パスワードリセット申請画面] --> B[メールアドレス入力]
    B --> C[フォーム送信]
    C --> D{ユーザー存在?}
    D -->|Yes| E[トークン生成]
    D -->|No| F[メッセージ表示（同一）]
    E --> G[リセットメール送信]
    G --> F
    F --> H[ログイン画面へ]
    end

    subgraph 変更フロー
    I[メール内リンククリック] --> J[パスワードリセット画面]
    J --> K[新パスワード入力]
    K --> L[フォーム送信]
    L --> M{トークン有効?}
    M -->|No| N[エラー表示]
    M -->|Yes| O[パスワード更新]
    O --> P[トークンクリア]
    P --> Q[ログイン画面へ]
    N --> J
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | トークン有効期限 | リセットトークンには有効期限がある（Devise設定依存） | 常時 |
| BR-55-02 | 一度きりトークン | リセットトークンは使用後に無効化される | 常時 |
| BR-55-03 | 情報漏洩防止 | ユーザー存在有無に関わらず同一メッセージを表示 | 常時 |
| BR-55-04 | パスワード確認 | 新パスワードと確認用パスワードが一致すること | 常時 |
| BR-55-05 | メール送信確認 | ユーザーが存在する場合のみメール送信 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー検索 | users | SELECT | メールアドレスでユーザー検索 |
| トークン保存 | users | UPDATE | リセットトークンを保存 |
| パスワード更新 | users | UPDATE | 新パスワードのハッシュを保存 |

### テーブル別操作詳細

#### users（トークン生成時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | reset_password_token | ランダムトークン | Deviseが生成 |
| UPDATE | reset_password_sent_at | 現在日時 | 有効期限計算用 |

#### users（パスワード更新時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | encrypted_password | bcryptハッシュ値 | 新パスワード |
| UPDATE | reset_password_token | NULL | トークンクリア |
| UPDATE | reset_password_sent_at | NULL | 送信日時クリア |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | メールアドレス形式不正 | エラーメッセージ表示 |
| - | トークンエラー | トークンが無効または期限切れ | エラーメッセージ表示 |
| - | バリデーションエラー | パスワードと確認が不一致 | エラーメッセージ表示 |

### リトライ仕様

- リセット申請は何度でも可能（前のトークンは無効化される）
- パスワード変更失敗時は同一画面で修正・再試行可能

## トランザクション仕様

トークン生成・保存およびパスワード更新は単一トランザクションで処理。メール送信は非同期で実行される場合がある。

## パフォーマンス要件

- レスポンス時間: 2秒以内（メール送信を含む場合）
- パスワードハッシュ化にbcryptを使用

## セキュリティ考慮事項

- リセットトークンは暗号化され、推測困難
- トークンには有効期限があり、使用後は無効化
- ユーザー存在有無を漏らさないメッセージ設計
- パスワードはbcryptでハッシュ化して保存
- CSRFトークン検証あり
- HTTPSでの通信を推奨

## 備考

- DeviseのRecoverableモジュールを使用
- トークン有効期限はDevise設定で変更可能（config/initializers/devise.rb）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | recoverableモジュール |
| 1-2 | schema.rb | `db/schema.rb` | reset_password_token関連カラム |

**読解のコツ**:
- **49-50行目（user.rb）**: `devise :recoverable`の設定
- **459-460行目（schema.rb）**: reset_password_token, reset_password_sent_atカラム

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/passwords_controller.rb` | Devise拡張 |
| 2-2 | routes.rb | `config/routes.rb` | ルーティング |

**主要処理フロー**:
1. **8-11行目（passwords_controller.rb）**: Devise::PasswordsControllerを継承、HTML形式のみ対応

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/passwords/new.html.haml` | リセット申請フォーム |
| 3-2 | edit.html.haml | `app/views/devise/passwords/edit.html.haml` | パスワード変更フォーム |

**主要処理フロー**:
- **new.html.haml**: メールアドレス入力フォーム（3-10行目）
- **edit.html.haml**: 新パスワード入力フォーム（9-15行目）、hidden fieldでトークン送信

#### Step 4: メールテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | reset_password_instructions.html.haml | `app/views/devise/mailer/reset_password_instructions.html.haml` | リセットメール |

### プログラム呼び出し階層図

```
【リセット申請】
GET /users/password/new
    └─ Devise::PasswordsController#new
           └─ views/devise/passwords/new.html.haml

POST /users/password
    └─ Devise::PasswordsController#create
           ├─ User.find_by_email
           ├─ user.send_reset_password_instructions
           │      ├─ reset_password_token生成
           │      └─ メール送信
           └─ redirect_to new_user_session_path

【パスワード変更】
GET /users/password/edit?reset_password_token=xxx
    └─ Devise::PasswordsController#edit
           └─ views/devise/passwords/edit.html.haml

PUT /users/password
    └─ Devise::PasswordsController#update
           ├─ User.reset_password_by_token
           │      ├─ トークン検証
           │      └─ パスワード更新
           └─ redirect_to new_user_session_path
```

### データフロー図

```
[入力]               [処理]                    [出力]

【申請フロー】
メールアドレス ───▶ ユーザー検索 ───────────▶ トークン生成
                          │                       │
                          │                       ▼
                          │                  usersテーブル更新
                          │
                          └───────────────────▶ リセットメール送信

【変更フロー】
リセットトークン ──▶ トークン検証 ───────────▶ パスワード更新
新パスワード ──────▶ bcryptハッシュ化 ───────▶ usersテーブル更新
確認パスワード ────▶ 一致チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/passwords_controller.rb` | コントローラー | パスワードリセット |
| user.rb | `app/models/users/user.rb` | モデル | recoverableモジュール |
| new.html.haml | `app/views/devise/passwords/new.html.haml` | ビュー | 申請フォーム |
| edit.html.haml | `app/views/devise/passwords/edit.html.haml` | ビュー | 変更フォーム |
| reset_password_instructions.html.haml | `app/views/devise/mailer/reset_password_instructions.html.haml` | ビュー | リセットメール |
| routes.rb | `config/routes.rb` | 設定 | ルーティング |
| schema.rb | `db/schema.rb` | スキーマ | usersテーブル定義 |
