# 機能設計書 56-メール確認

## 概要

本ドキュメントは、Fat Free CRMにおけるメールアドレス確認機能の設計書である。Deviseライブラリを利用したメールアドレス検証処理について、処理仕様・セキュリティ・コード構造を定義する。

### 本機能の処理概要

ユーザー登録時に入力されたメールアドレスの有効性を確認する機能である。確認メールに含まれるリンクをクリックすることで、メールアドレスの所有権を検証し、アカウントを有効化する。

**業務上の目的・背景**：CRMシステムでは重要な通知やレポートがメールで送信されるため、有効なメールアドレスが登録されていることが重要である。また、不正なアカウント作成を防止し、メールアドレスの所有者本人であることを確認することでセキュリティを向上させる。

**機能の利用シーン**：
- 新規ユーザー登録後のメールアドレス確認
- 確認メールを受信できなかった場合の再送信
- メールアドレス変更後の再確認（設定による）

**主要な処理内容**：
1. ユーザー登録時に確認トークンを生成し、確認メールを送信
2. ユーザーがメール内のリンクをクリック
3. トークンを検証し、有効であればアカウントを確認済みに更新
4. 確認完了後、ログイン画面にリダイレクト
5. 確認メール再送信機能も提供

**関連システム・外部連携**：
- メール送信（確認メール）：Action Mailer経由

**権限による制御**：未認証ユーザーが利用可能（ログイン前に確認が必要なため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | メール確認画面 | 主画面 | メール確認再送信 |

## 機能種別

メールアドレス検証処理 / UPDATE操作

## 入力仕様

### 入力パラメータ（確認実行）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| confirmation_token | String | Yes | 確認トークン（URLパラメータ） | 有効なトークン |

### 入力パラメータ（再送信）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| user[email] | String | Yes | メールアドレス | 必須、メール形式 |

### 入力データソース

- メール内リンク（確認トークン）
- 画面入力（再送信フォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 確認メール | Email | 確認リンクを含むメール |
| フラッシュメッセージ | String | 処理結果のメッセージ |

### 出力先

- メール（確認メール）
- usersテーブル（確認ステータス更新）

## 処理フロー

### 処理シーケンス

```
【メール確認実行】
1. ユーザーが確認メール内のリンクをクリック
   └─ GET /users/confirmation?confirmation_token=xxx
2. Devise::ConfirmationsController#showが呼び出される
3. トークン検証
   └─ confirmation_tokenでユーザーを検索
4. 確認状態更新
   └─ confirmed_atを現在日時に更新
5. ログイン画面にリダイレクト

【確認メール再送信】
1. 確認メール再送信画面表示（GET /users/confirmation/new）
   └─ Devise::ConfirmationsController#new
2. メールアドレスを入力してフォーム送信（POST /users/confirmation）
   └─ Devise::ConfirmationsController#create
3. ユーザー検索
   └─ 既に確認済みの場合はエラー
4. 新しい確認トークン生成・メール送信
5. ログイン画面にリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    subgraph 確認フロー
    A[確認メール受信] --> B[リンククリック]
    B --> C{トークン有効?}
    C -->|Yes| D[confirmed_at更新]
    C -->|No| E[エラー表示]
    D --> F[ログイン画面へ]
    end

    subgraph 再送信フロー
    G[再送信画面] --> H[メールアドレス入力]
    H --> I[フォーム送信]
    I --> J{ユーザー存在?}
    J -->|No| K[メッセージ表示]
    J -->|Yes| L{確認済み?}
    L -->|Yes| M[既確認エラー]
    L -->|No| N[新トークン生成]
    N --> O[確認メール送信]
    O --> K
    K --> P[ログイン画面へ]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-01 | 確認必須 | メール未確認のユーザーはログイン不可 | 常時 |
| BR-56-02 | 一度きりトークン | 確認トークンは使用後に無効化 | 常時 |
| BR-56-03 | 再送信制限 | 既に確認済みのユーザーには再送信不可 | 常時 |
| BR-56-04 | 情報漏洩防止 | ユーザー存在有無に関わらず同一メッセージ | 常時 |
| BR-56-05 | トークン有効期限 | 確認トークンには有効期限がある（設定依存） | 設定依存 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー検索 | users | SELECT | confirmation_tokenでユーザー検索 |
| 確認状態更新 | users | UPDATE | confirmed_atを更新 |
| トークン再生成 | users | UPDATE | 新しいconfirmation_tokenを生成 |

### テーブル別操作詳細

#### users（確認実行時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | confirmed_at | 現在日時 | 確認完了日時 |
| UPDATE | confirmation_token | NULL | トークンクリア |

#### users（再送信時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | confirmation_token | 新しいトークン | 再生成 |
| UPDATE | confirmation_sent_at | 現在日時 | 送信日時更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | トークンエラー | トークンが無効または期限切れ | エラーメッセージ表示 |
| - | 確認済みエラー | 既に確認済みのユーザー | エラーメッセージ表示 |
| - | バリデーションエラー | メールアドレス形式不正 | エラーメッセージ表示 |

### リトライ仕様

- 確認メールは何度でも再送信可能（前のトークンは無効化）
- 確認失敗時は再送信画面から再試行

## トランザクション仕様

確認状態の更新は単一トランザクションで処理。メール送信は非同期で実行される場合がある。

## パフォーマンス要件

- レスポンス時間: 1秒以内
- メール送信を含む場合は2秒以内

## セキュリティ考慮事項

- 確認トークンは暗号化され、推測困難
- トークン使用後は無効化（再利用防止）
- ユーザー存在有無を漏らさないメッセージ設計
- CSRFトークン検証あり
- HTTPSでの通信を推奨

## 備考

- DeviseのConfirmableモジュールを使用
- トークン有効期限はDevise設定で変更可能（config/initializers/devise.rb）
- reconfirmable設定によりメールアドレス変更時の再確認も可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | confirmableモジュール |
| 1-2 | schema.rb | `db/schema.rb` | confirmation関連カラム |

**読解のコツ**:
- **49-50行目（user.rb）**: `devise :confirmable`の設定
- **464-466行目（schema.rb）**: confirmation_token, confirmed_at, confirmation_sent_atカラム

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | confirmations_controller.rb | `app/controllers/confirmations_controller.rb` | Devise拡張 |
| 2-2 | routes.rb | `config/routes.rb` | ルーティング |

**主要処理フロー**:
1. **7-10行目（confirmations_controller.rb）**: Devise::ConfirmationsControllerを継承、HTML形式のみ対応

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/confirmations/new.html.haml` | 再送信フォーム |

**主要処理フロー**:
- **2-9行目**: メールアドレス入力フォーム、再送信ボタン

#### Step 4: メールテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | confirmation_instructions.html.haml | `app/views/devise/mailer/confirmation_instructions.html.haml` | 確認メール |

### プログラム呼び出し階層図

```
【確認実行】
GET /users/confirmation?confirmation_token=xxx
    └─ Devise::ConfirmationsController#show
           ├─ User.confirm_by_token(token)
           │      ├─ トークン検証
           │      └─ confirmed_at更新
           └─ redirect_to new_user_session_path

【再送信】
GET /users/confirmation/new
    └─ Devise::ConfirmationsController#new
           └─ views/devise/confirmations/new.html.haml

POST /users/confirmation
    └─ Devise::ConfirmationsController#create
           ├─ User.send_confirmation_instructions
           │      ├─ 新トークン生成
           │      └─ 確認メール送信
           └─ redirect_to new_user_session_path
```

### データフロー図

```
[入力]               [処理]                    [出力]

【確認フロー】
確認トークン ──────▶ トークン検証 ───────────▶ ユーザー特定
                          │
                          └───────────────────▶ confirmed_at更新
                                                   │
                                                   ▼
                                              ログイン可能に

【再送信フロー】
メールアドレス ────▶ ユーザー検索 ───────────▶ 確認済み判定
                          │
                          └───────────────────▶ トークン生成
                                                   │
                                                   ▼
                                              確認メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| confirmations_controller.rb | `app/controllers/confirmations_controller.rb` | コントローラー | メール確認 |
| user.rb | `app/models/users/user.rb` | モデル | confirmableモジュール |
| new.html.haml | `app/views/devise/confirmations/new.html.haml` | ビュー | 再送信フォーム |
| confirmation_instructions.html.haml | `app/views/devise/mailer/confirmation_instructions.html.haml` | ビュー | 確認メール |
| routes.rb | `config/routes.rb` | 設定 | ルーティング |
| schema.rb | `db/schema.rb` | スキーマ | usersテーブル定義 |
