# 機能設計書 58-リスト削除

## 概要

本ドキュメントは、Fat Free CRMにおけるリスト（検索条件保存）削除機能の設計書である。保存した検索条件リストを削除する機能について、処理仕様・データベース操作・コード構造を定義する。

### 本機能の処理概要

ユーザーが保存したリスト（検索条件）を削除する機能である。サイドバーに表示されたリストの削除ボタンをクリックすることで、該当リストをデータベースから削除する。

**業務上の目的・背景**：不要になった検索条件リストを削除することで、サイドバーの整理を行い、使いやすさを維持する。プロジェクト終了時や検索条件が不要になった場合に利用する。

**機能の利用シーン**：
- 不要になったリストを整理したい場面
- 誤って作成したリストを削除したい場面
- グローバルリストを削除して他ユーザーへの影響を解消したい場面

**主要な処理内容**：
1. サイドバーのリスト削除ボタンをクリック
2. DELETEリクエストを送信
3. リストレコードを削除
4. サイドバーから該当リストをアニメーション付きで削除

**関連システム・外部連携**：特になし

**権限による制御**：
- 自分が作成した個人リストは削除可能
- グローバルリスト（user_id=NULL）は全ユーザーが削除可能（要注意）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | リスト（Lists） | 主画面 | 保存したリストの削除 |

## 機能種別

削除処理 / DELETE操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | Integer | Yes | リストID | 存在するリストID |

### 入力データソース

- サイドバーの削除ボタン（リンク）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| JavaScript | String | リスト要素をスライドアップで削除するJS |

### 出力先

- listsテーブル（レコード削除）
- 画面（サイドバーからリスト要素を削除）

## 処理フロー

### 処理シーケンス

```
1. 削除ボタンクリック
   └─ DELETE /lists/:id へリクエスト送信
2. ListsController#destroyが呼び出される
   └─ List.find(params[:id])
3. リスト削除
   └─ @list.destroy
4. JSレスポンス
   └─ 該当リスト要素をスライドアップで非表示→削除
```

### フローチャート

```mermaid
flowchart TD
    A[削除ボタンクリック] --> B[DELETE /lists/:id]
    B --> C[List.find]
    C --> D{リスト存在?}
    D -->|Yes| E[@list.destroy]
    D -->|No| F[404エラー]
    E --> G[JSレスポンス]
    G --> H[要素をスライドアップで削除]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-01 | 物理削除 | リストレコードは完全に削除される（論理削除ではない） | 常時 |
| BR-58-02 | 確認なし削除 | 削除時の確認ダイアログはJSのdata-confirmで実装（ブラウザ標準） | 常時 |
| BR-58-03 | アニメーション | 削除時は背景色変更後にスライドアップで非表示 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リスト取得 | lists | SELECT | IDでリストを検索 |
| リスト削除 | lists | DELETE | リストレコードを削除 |

### テーブル別操作詳細

#### lists

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | params[:id] | 削除対象リストの取得 |
| DELETE | - | 該当レコード | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | NotFound | 指定IDのリストが存在しない | エラーページ表示 |

### リトライ仕様

特になし（削除は一度のみ）

## トランザクション仕様

単一レコードのDELETEのため、特別なトランザクション制御は不要。

## パフォーマンス要件

- レスポンス時間: 500ms以内
- 単純なDELETE操作のため、負荷は軽微

## セキュリティ考慮事項

- CSRFトークン検証あり
- 削除はログインユーザーのみ可能
- 現状は全ユーザーが任意のリストを削除可能（認可制御なし）

## 備考

- 削除時のアニメーションは背景色を#ffe4e1（薄いピンク）に変更後、スライドアップ
- グローバルリストの削除権限については運用上の注意が必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | list.rb | `app/models/list.rb` | Listモデル |
| 1-2 | schema.rb | `db/schema.rb` | listsテーブル構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lists_controller.rb | `app/controllers/lists_controller.rb` | destroyアクション |
| 2-2 | routes.rb | `config/routes.rb` | ルーティング |

**主要処理フロー**:
1. **27-31行目（lists_controller.rb）**: List.findでリスト取得、destroyで削除

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | destroy.js.haml | `app/views/lists/destroy.js.haml` | 削除時のJS処理 |

**主要処理フロー**:
- **1行目（destroy.js.haml）**: 背景色変更後にスライドアップでDOM要素を削除

### プログラム呼び出し階層図

```
DELETE /lists/:id
    │
    └─ ListsController#destroy
           │
           ├─ List.find(params[:id])
           │
           ├─ @list.destroy
           │
           └─ respond_with(@list)
                  └─ destroy.js.haml
                         └─ スライドアップで削除
```

### データフロー図

```
[入力]               [処理]                    [出力]

リストID ────────▶ List.find ─────────────▶ リスト取得
                          │
                          └───────────────────▶ @list.destroy
                                                   │
                                                   ▼
                                              listsテーブル削除
                                                   │
                                                   ▼
                                              JSレスポンス
                                                   │
                                                   ▼
                                              DOM要素削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lists_controller.rb | `app/controllers/lists_controller.rb` | コントローラー | リスト削除 |
| list.rb | `app/models/list.rb` | モデル | Listモデル |
| destroy.js.haml | `app/views/lists/destroy.js.haml` | ビュー | 削除時のJS |
| routes.rb | `config/routes.rb` | 設定 | ルーティング |
| schema.rb | `db/schema.rb` | スキーマ | listsテーブル定義 |
