# 機能設計書 59-ユーザー管理一覧

## 概要

本ドキュメントは、Fat Free CRMにおける管理者向けユーザー管理一覧機能の設計書である。システム管理者が全ユーザーを一覧表示・管理するための機能について、処理仕様・データベース操作・コード構造を定義する。

### 本機能の処理概要

管理者がシステム内の全ユーザーを一覧表示し、ユーザー管理操作（作成、編集、削除、停止、再有効化）へのアクセスを提供する機能である。ユーザー名での検索、ページネーション、高度な検索（Ransack）に対応する。

**業務上の目的・背景**：システム管理者がユーザーアカウントを一元管理するための機能である。新規ユーザーの追加、退職者のアカウント停止、権限変更などの日常的なユーザー管理業務を効率的に行うことができる。

**機能の利用シーン**：
- 新規ユーザーを追加する前の既存ユーザー確認
- ユーザーアカウントの状態（有効/停止）を確認したい場面
- 特定のユーザーを検索して管理操作を行いたい場面
- ユーザー一覧をエクスポートしたい場面

**主要な処理内容**：
1. 管理者画面（/admin）にアクセス
2. ユーザー一覧を取得してページネーション表示
3. テキスト検索またはRansack高度な検索でフィルタリング
4. 各ユーザーに対する管理操作リンクを提供
5. ユーザー作成フォームへのリンクを提供

**関連システム・外部連携**：特になし

**権限による制御**：管理者（admin=true）のみアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | ユーザー管理一覧画面 | 主画面 | 全ユーザー一覧表示（管理者用） |
| 35 | ユーザー管理詳細画面 | 遷移先画面 | ユーザー詳細確認（管理者用） |

## 機能種別

一覧表示処理 / SELECT操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | Integer | No | ページ番号 | 正の整数 |
| query | String | No | 検索クエリ（ユーザー名、メール、姓名） | なし |
| q | Hash | No | Ransack検索条件 | Ransack形式 |

### 入力データソース

- URLパラメータ（ページネーション、検索条件）
- 検索フォーム入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ユーザー一覧 | Array<User> | ページネーションされたユーザーリスト |
| ページネーション情報 | Object | 現在ページ、総ページ数など |

### 出力先

- 画面（ユーザー一覧表示）

## 処理フロー

### 処理シーケンス

```
1. 管理者画面アクセス（GET /admin/users または GET /admin）
   └─ Admin::UsersController#index
2. 管理者権限チェック
   └─ Admin::ApplicationController#require_admin
3. ユーザー一覧取得
   ├─ Ransack検索条件の適用
   ├─ テキスト検索の適用（query）
   └─ ページネーションの適用
4. ビュー表示
   └─ ユーザー一覧、ページネーション、検索フォーム
```

### フローチャート

```mermaid
flowchart TD
    A[/admin/usersアクセス] --> B{管理者?}
    B -->|No| C[ダッシュボードへリダイレクト]
    B -->|Yes| D[get_users呼び出し]
    D --> E[Ransack検索]
    E --> F{query指定?}
    F -->|Yes| G[text_search適用]
    F -->|No| H[検索スキップ]
    G --> I[ページネーション]
    H --> I
    I --> J[ビュー表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-59-01 | 管理者限定 | 管理者（admin=true）のみアクセス可能 | 常時 |
| BR-59-02 | ID降順 | ユーザーはIDの降順で表示 | 常時 |
| BR-59-03 | テキスト検索 | username, email, first_name, last_nameで検索 | query指定時 |
| BR-59-04 | 大文字小文字無視 | 検索は大文字小文字を区別しない | 常時 |
| BR-59-05 | ページネーション | HTML/JS/XML形式のみページネーション適用 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー一覧取得 | users | SELECT | 全ユーザーを取得 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | ORDER BY id DESC | ID降順で取得 |
| SELECT（検索時） | username, email, first_name, last_name | LIKE '%query%' | テキスト検索 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | リダイレクト | 非管理者がアクセス | ダッシュボードにリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用のため、特別なトランザクション制御は不要。

## パフォーマンス要件

- レスポンス時間: 1秒以内
- ページネーションにより一度に表示するレコード数を制限

## セキュリティ考慮事項

- 管理者のみアクセス可能（Admin::ApplicationController#require_admin）
- 管理画面専用のレイアウト・スタイル
- CSRFトークン検証あり

## 備考

- /adminへのアクセスはAdmin::UsersController#indexにルーティング
- 高度な検索はRansack gemを使用
- ユーザー作成、編集、削除、停止、再有効化の各機能へのリンクを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | ユーザーモデル、スコープ |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブル構造 |

**読解のコツ**:
- **69行目（user.rb）**: `scope :by_id` - ID降順ソート
- **74-77行目（user.rb）**: `scope :text_search` - テキスト検索ロジック

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admin/users_controller.rb | `app/controllers/admin/users_controller.rb` | indexアクション |
| 2-2 | routes.rb | `config/routes.rb` | 管理者ルーティング |

**主要処理フロー**:
1. **9行目（admin/users_controller.rb）**: setup_current_tab - タブ設定
2. **16-18行目（admin/users_controller.rb）**: index - get_users呼び出し
3. **134-147行目（admin/users_controller.rb）**: get_users - 検索・ページネーションロジック

#### Step 3: 管理者認可を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | admin/application_controller.rb | `app/controllers/admin/application_controller.rb` | 管理者チェック |

**読解のコツ**: Admin名前空間のコントローラーは管理者権限を前提としている。

#### Step 4: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.html.haml | `app/views/admin/users/index.html.haml` | 一覧表示 |
| 4-2 | _user.html.haml | `app/views/admin/users/_user.html.haml` | ユーザー行テンプレート |

**主要処理フロー**:
- **4行目（index.html.haml）**: ユーザー作成リンク
- **11行目（index.html.haml）**: ユーザー一覧レンダリング
- **12-13行目（index.html.haml）**: ページネーション、エクスポート

### プログラム呼び出し階層図

```
GET /admin/users
    │
    └─ Admin::UsersController#index
           │
           ├─ require_admin（Admin::ApplicationController）
           │
           ├─ get_users
           │      ├─ User.ransack(params[:q])
           │      ├─ @search.result
           │      ├─ text_search（query指定時）
           │      └─ paginate
           │
           └─ respond_with(@users)
                  └─ index.html.haml
                         └─ _user.html.haml（各ユーザー）
```

### データフロー図

```
[入力]               [処理]                    [出力]

page ─────────────▶ ページネーション ─────────▶ @users
query ────────────▶ text_search
q ────────────────▶ Ransack検索
                          │
                          └───────────────────▶ ユーザー一覧HTML
                                                ページネーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| admin/users_controller.rb | `app/controllers/admin/users_controller.rb` | コントローラー | ユーザー管理 |
| admin/application_controller.rb | `app/controllers/admin/application_controller.rb` | コントローラー | 管理者認可 |
| user.rb | `app/models/users/user.rb` | モデル | ユーザーモデル |
| index.html.haml | `app/views/admin/users/index.html.haml` | ビュー | 一覧画面 |
| _user.html.haml | `app/views/admin/users/_user.html.haml` | ビュー | ユーザー行 |
| _sidebar_index.html.haml | `app/views/admin/users/_sidebar_index.html.haml` | ビュー | サイドバー |
| routes.rb | `config/routes.rb` | 設定 | ルーティング |
| schema.rb | `db/schema.rb` | スキーマ | usersテーブル定義 |
